/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovePipe
extends BasePipe {
    Logger logger = LoggerFactory.getLogger(MovePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/mv";

    public MovePipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    public Iterator<Resource> getOutput() {
        Iterator<Resource> output = Collections.emptyIterator();
        Resource resource = this.getInput();
        if (resource != null && resource.adaptTo(Item.class) != null) {
            String targetPath = this.getExpr();
            try {
                Session session = (Session)this.resolver.adaptTo(Session.class);
                if (session.itemExists(targetPath)) {
                    this.logger.warn("{} already exists, nothing will be done here, nothing outputed");
                } else {
                    this.logger.info("moving resource {} to {}", (Object)resource.getPath(), (Object)targetPath);
                    if (!this.isDryRun()) {
                        if (resource.adaptTo(Node.class) != null) {
                            session.move(resource.getPath(), targetPath);
                        } else {
                            this.logger.debug("resource is a property");
                            int lastLevel = targetPath.lastIndexOf("/");
                            String parentPath = targetPath.substring(0, lastLevel);
                            String name = targetPath.substring(lastLevel + 1, targetPath.length());
                            Property sourceProperty = (Property)resource.adaptTo(Property.class);
                            Node destNode = session.getNode(parentPath);
                            if (sourceProperty.isMultiple()) {
                                destNode.setProperty(name, sourceProperty.getValues(), sourceProperty.getType());
                            } else {
                                destNode.setProperty(name, sourceProperty.getValue(), sourceProperty.getType());
                            }
                            sourceProperty.remove();
                        }
                        Resource target = this.resolver.getResource(targetPath);
                        output = Collections.singleton(target).iterator();
                    }
                }
            }
            catch (RepositoryException e) {
                this.logger.error("unable to move the resource", (Throwable)e);
            }
        } else {
            this.logger.warn("bad configuration of the pipe, will do nothing");
        }
        return output;
    }
}

