/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.CustomOutputWriter;

public class JsonWriter
extends CustomOutputWriter {
    protected JsonGenerator jsonWriter;
    public static final String JSON_EXTENSION = "json";

    JsonWriter() {
        this.setWriter(new StringWriter());
    }

    JsonWriter(Writer writer) {
        this.setWriter(writer);
    }

    @Override
    public boolean handleRequest(SlingHttpServletRequest request) {
        return request.getRequestPathInfo().getExtension().equals(JSON_EXTENSION);
    }

    @Override
    protected void initResponse(SlingHttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
    }

    @Override
    public void starts() {
        this.jsonWriter = Json.createGenerator((Writer)this.writer);
        this.jsonWriter.writeStartObject();
        this.jsonWriter.writeStartArray("items");
    }

    @Override
    public void writeItem(Resource resource) {
        if (this.customOutputs == null) {
            this.jsonWriter.write(resource.getPath());
        } else {
            this.jsonWriter.writeStartObject();
            this.jsonWriter.write("path", resource.getPath());
            for (Map.Entry entry : this.customOutputs.entrySet()) {
                Object o = this.pipe.getBindings().instantiateObject((String)entry.getValue());
                if (o instanceof JsonValue) {
                    this.jsonWriter.write((String)entry.getKey(), (JsonValue)o);
                    continue;
                }
                this.jsonWriter.write((String)entry.getKey(), o.toString());
            }
            this.jsonWriter.writeEnd();
        }
    }

    @Override
    public void ends() {
        this.jsonWriter.writeEnd();
        this.jsonWriter.write("size", this.size);
        this.jsonWriter.writeEnd();
        this.jsonWriter.flush();
    }
}

