/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.AbstractInputStreamPipe;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPipe
extends AbstractInputStreamPipe {
    private static Logger logger = LoggerFactory.getLogger(JsonPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/json";
    protected static final String PN_VALUEPATH = "valuePath";
    protected static final String JSONPATH_ROOT = "$";
    protected static final String ARRAY_START = "[";
    protected static final String OBJ_START = ".";
    protected static final Pattern JSONPATH_FIRSTTOKEN = Pattern.compile("^\\$([\\.\\[])([^\\.\\]\\[]+)\\]?");
    JsonArray array;
    int index = -1;

    public JsonPipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
    }

    @Override
    public Iterator<Resource> getOutput(InputStream is) {
        Iterator<Resource> output;
        block9: {
            output = EMPTY_ITERATOR;
            Iterator<Resource> inputSingletonIterator = Collections.singleton(this.getInput()).iterator();
            String jsonString = null;
            try {
                JsonStructure json;
                jsonString = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (!StringUtils.isNotBlank((CharSequence)jsonString)) break block9;
                try {
                    json = JsonUtil.parse(jsonString);
                }
                catch (JsonException ex) {
                    json = null;
                }
                if (json == null) {
                    this.binding = jsonString.trim();
                    output = inputSingletonIterator;
                } else {
                    String valuePath = (String)this.properties.get(PN_VALUEPATH, String.class);
                    if (StringUtils.isNotBlank((CharSequence)valuePath)) {
                        json = this.getValue(json, valuePath);
                    }
                    if (json.getValueType() != JsonValue.ValueType.ARRAY) {
                        this.binding = JsonUtil.unbox((JsonValue)json);
                        output = inputSingletonIterator;
                    } else {
                        this.array = (JsonArray)json;
                        this.binding = this.array;
                        this.index = 0;
                        output = new Iterator<Resource>(){

                            @Override
                            public boolean hasNext() {
                                return JsonPipe.this.index < JsonPipe.this.array.size();
                            }

                            @Override
                            public Resource next() {
                                try {
                                    JsonPipe.this.binding = JsonUtil.unbox((JsonValue)JsonPipe.this.array.get(JsonPipe.this.index));
                                }
                                catch (Exception e) {
                                    logger.error("Unable to retrieve {}nth item of jsonarray", (Object)JsonPipe.this.index, (Object)e);
                                }
                                ++JsonPipe.this.index;
                                return JsonPipe.this.getInput();
                            }
                        };
                    }
                }
            }
            catch (Exception e) {
                logger.error("unable to parse JSON {} ", (Object)jsonString, (Object)e);
            }
        }
        return output;
    }

    protected JsonStructure getValue(JsonStructure json, String valuePath) {
        Matcher matcher = JSONPATH_FIRSTTOKEN.matcher(valuePath);
        if (matcher.find()) {
            String firstChar = matcher.group(1);
            String content = matcher.group(2);
            logger.trace("first char is {}, content is {}", (Object)firstChar, (Object)content);
            if (ARRAY_START.equals(firstChar)) {
                JsonArray array = (JsonArray)json;
                int index = Integer.parseInt(content);
                json = (JsonStructure)array.get(index);
            } else if (OBJ_START.equals(firstChar)) {
                JsonObject object = (JsonObject)json;
                json = (JsonStructure)object.get((Object)content);
            }
            valuePath = StringUtils.removeStart((String)valuePath, (String)matcher.group(0));
            if (StringUtils.isNotBlank((CharSequence)valuePath)) {
                valuePath = JSONPATH_ROOT + valuePath;
                return this.getValue(json, valuePath);
            }
        }
        return json;
    }
}

