/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(FilterPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/filter";
    public static final String PREFIX_FILTER = "slingPipesFilter_";
    public static final String PN_NOT = "slingPipesFilter_not";
    public static final String PN_NOCHILDREN = "slingPipesFilter_noChildren";
    public static final String PN_TEST = "slingPipesFilter_test";

    public FilterPipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
    }

    boolean propertiesPass(ValueMap current, ValueMap filter) {
        if (filter.containsKey((Object)PN_TEST)) {
            Object test = this.bindings.instantiateObject((String)filter.get(PN_TEST, (Object)"${false}"));
            if (!(test instanceof Boolean)) {
                logger.error("instatiated test {}\u00a0is not a boolean, filtering out", test);
                return false;
            }
            return (Boolean)test;
        }
        for (String key : filter.keySet()) {
            Pattern pattern;
            if (IGNORED_PROPERTIES.contains(key) || key.startsWith(PREFIX_FILTER) || (pattern = Pattern.compile((String)filter.get(key, String.class))).matcher((CharSequence)current.get(key, String.class)).find()) continue;
            return false;
        }
        return true;
    }

    boolean filterPasses(Resource currentResource, Resource filterResource) {
        try {
            ValueMap current = (ValueMap)currentResource.adaptTo(ValueMap.class);
            ValueMap filter = (ValueMap)filterResource.adaptTo(ValueMap.class);
            if (this.propertiesPass(current, filter)) {
                boolean returnValue;
                String childName;
                Node currentNode = (Node)currentResource.adaptTo(Node.class);
                boolean noChildren = (Boolean)this.bindings.instantiateObject((String)filter.get(PN_NOCHILDREN, (Object)"${false}"));
                if (noChildren) {
                    return !currentNode.hasNodes();
                }
                Node filterNode = (Node)filterResource.adaptTo(Node.class);
                NodeIterator children = filterNode.getNodes();
                for (returnValue = true; returnValue && children.hasNext(); returnValue &= this.filterPasses(currentResource.getChild(childName), filterResource.getChild(childName))) {
                    childName = children.nextNode().getName();
                    if (currentNode.hasNode(childName)) continue;
                    return false;
                }
                return returnValue;
            }
        }
        catch (Exception e) {
            logger.error("error when executing filter", (Throwable)e);
        }
        return false;
    }

    @Override
    public Iterator<Resource> getOutput() {
        Resource resource = this.getInput();
        if (resource != null) {
            boolean not = (Boolean)this.properties.get(PN_NOT, (Object)false);
            if (this.filterPasses(resource, this.getConfiguration()) ^ not) {
                logger.debug("filter passes for {}", (Object)resource.getPath());
                return super.getOutput();
            }
            logger.debug("{} got filtered out", (Object)resource.getPath());
        }
        return Collections.emptyIterator();
    }
}

