/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.CustomOutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvWriter
extends CustomOutputWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CsvWriter.class);
    private static final String CSV_EXTENSION = "csv";
    private static final String SEPARATOR = ",";
    private static final String NEW_LINE = "\n";
    List<String> headers;

    @Override
    public boolean handleRequest(SlingHttpServletRequest request) {
        return request.getRequestPathInfo().getExtension().equals(CSV_EXTENSION);
    }

    @Override
    protected void initResponse(SlingHttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("plain/text");
    }

    @Override
    public void starts() {
    }

    @Override
    protected void writeItem(Resource resource) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
            this.headers.add("path");
            if (this.customOutputs != null) {
                this.headers.addAll(this.customOutputs.keySet());
            }
            try {
                this.writer.write(this.headers.stream().collect(Collectors.joining(SEPARATOR)) + NEW_LINE);
            }
            catch (IOException e) {
                LOG.error("unable to write header");
            }
        }
        if (this.headers != null) {
            try {
                String line = this.headers.stream().map(key -> key.equals("path") ? resource.getPath() : (String)this.pipe.getBindings().instantiateObject((String)this.customOutputs.get(key))).collect(Collectors.joining(SEPARATOR));
                this.writer.write(line + NEW_LINE);
            }
            catch (IOException e) {
                LOG.error("unable to write header", (Throwable)e);
            }
        }
    }

    @Override
    public void ends() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            LOG.error("unable to flush", (Throwable)e);
        }
    }
}

