/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.ContainerPipe;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencePipe
extends BasePipe {
    private static final Logger log = LoggerFactory.getLogger(ReferencePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/reference";
    protected Pipe reference;

    public ReferencePipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
        Resource pipeResource = this.resolver.getResource(this.getExpr());
        if (pipeResource == null) {
            throw new Exception("Reference configuration error: There is no resource at " + this.getExpr());
        }
        this.reference = plumber.getPipe(pipeResource);
        if (this.reference == null) {
            throw new Exception("Unable to build out pipe out of " + this.getPath());
        }
        this.reference.setReferrer(this);
        log.info("set reference to {}", (Object)this.reference);
    }

    @Override
    public void setParent(ContainerPipe parent) {
        super.setParent(parent);
        this.reference.setParent(parent);
    }

    @Override
    public void setBindings(PipeBindings bindings) {
        this.reference.setBindings(bindings);
    }

    @Override
    public PipeBindings getBindings() {
        return this.reference.getBindings();
    }

    @Override
    public Iterator<Resource> getOutput() {
        log.debug("getting {}\u00a0output", (Object)this.reference);
        return this.reference.getOutput();
    }

    @Override
    public Object getOutputBinding() {
        return this.reference.getOutputBinding();
    }

    @Override
    public boolean modifiesContent() {
        return this.reference.modifiesContent();
    }
}

