/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerPipe
extends BasePipe {
    private static final Logger log = LoggerFactory.getLogger(ContainerPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/container";
    public static final String PN_SLEEP = "sleep";
    Map<String, Pipe> pipes = new HashMap<String, Pipe>();
    List<Pipe> pipeList = new ArrayList<Pipe>();
    long sleep = (Long)this.properties.get("sleep", (Object)0L);

    public ContainerPipe(Plumber plumber, Resource resource) throws Exception {
        super(plumber, resource);
        Iterator childPipeResources = this.getConfiguration().listChildren();
        while (childPipeResources.hasNext()) {
            Resource pipeResource = (Resource)childPipeResources.next();
            Pipe pipe = plumber.getPipe(pipeResource);
            if (pipe == null) {
                log.error("configured pipe {} is either not registered, or not computable by the plumber", (Object)pipeResource.getPath());
                continue;
            }
            pipe.setParent(this);
            pipe.setBindings(this.bindings);
            this.pipes.put(pipe.getName(), pipe);
            this.pipeList.add(pipe);
        }
    }

    @Override
    public boolean modifiesContent() {
        for (Pipe pipe : this.pipes.values()) {
            if (!pipe.modifiesContent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBindings(PipeBindings bindings) {
        this.bindings = bindings;
        for (Pipe pipe : this.pipeList) {
            pipe.setBindings(bindings);
        }
    }

    @Override
    public Iterator<Resource> getOutput() {
        return new ContainerResourceIterator(this, this.sleep);
    }

    public Pipe getPreviousPipe(Pipe pipe) {
        Pipe previousPipe = null;
        for (Pipe candidate : this.pipeList) {
            if (candidate.equals(pipe)) {
                return previousPipe;
            }
            previousPipe = candidate;
        }
        return null;
    }

    public Pipe getFirstPipe() {
        return this.pipeList.iterator().next();
    }

    public Pipe getLastPipe() {
        return this.pipeList.get(this.pipeList.size() - 1);
    }

    public Resource getOutputResource() {
        return this.bindings.getExecutedResource(this.getLastPipe().getName());
    }

    static class ContainerResourceIterator
    implements Iterator<Resource> {
        Map<Pipe, Iterator<Resource>> iterators;
        ContainerPipe container;
        PipeBindings bindings;
        boolean computedCursor = false;
        boolean hasNext = false;
        long sleep = 0L;
        int cursor = 0;

        ContainerResourceIterator(ContainerPipe containerPipe, long sleep) {
            this.container = containerPipe;
            this.bindings = this.container.bindings;
            this.iterators = new HashMap<Pipe, Iterator<Resource>>();
            Pipe firstPipe = this.container.getFirstPipe();
            this.sleep = sleep;
            this.iterators.put(firstPipe, firstPipe.getOutput());
        }

        private boolean updateCursor() {
            Pipe currentPipe = this.container.pipeList.get(this.cursor);
            Iterator<Resource> it = this.iterators.get(currentPipe);
            while (true) {
                if (it.hasNext() && this.cursor < this.container.pipeList.size() - 1) {
                    Resource resource = it.next();
                    this.bindings.updateBindings(currentPipe, resource);
                    Pipe nextPipe = this.container.pipeList.get(++this.cursor);
                    this.iterators.put(nextPipe, nextPipe.getOutput());
                    currentPipe = nextPipe;
                    log.debug("switching to {}", (Object)currentPipe);
                    it = this.iterators.get(currentPipe);
                    continue;
                }
                while (!it.hasNext() && this.cursor > 0) {
                    currentPipe = this.container.pipeList.get(--this.cursor);
                    log.debug("switching to {}", (Object)currentPipe);
                    it = this.iterators.get(currentPipe);
                }
                if (!it.hasNext() || this.cursor >= this.container.pipeList.size() - 1) break;
            }
            return this.cursor > 0 || this.iterators.size() == 1 && it.hasNext();
        }

        @Override
        public boolean hasNext() {
            if (!this.computedCursor) {
                this.hasNext = this.updateCursor();
            }
            return this.hasNext;
        }

        @Override
        public Resource next() {
            try {
                boolean bl = this.hasNext = this.computedCursor && this.hasNext || this.hasNext();
                if (this.hasNext) {
                    this.computedCursor = false;
                    this.hasNext = false;
                    Resource resource = this.iterators.get(this.container.getLastPipe()).next();
                    this.bindings.updateBindings(this.container.getLastPipe(), resource);
                    if (this.sleep > 0L) {
                        Thread.sleep(this.sleep);
                    }
                    return resource;
                }
            }
            catch (InterruptedException e) {
                log.error("interrupted while sleeping", (Throwable)e);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

