/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.ContainerPipe;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.ReferencePipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePipe
implements Pipe {
    private final Logger logger = LoggerFactory.getLogger(BasePipe.class);
    public static final String RT_PREFIX = "slingPipes/";
    public static final String RESOURCE_TYPE = "slingPipes/base";
    public static final String DRYRUN_KEY = "dryRun";
    public static final String READ_ONLY = "readOnly";
    public static final String PN_STATUS = "status";
    public static final String PN_STATUS_MODIFIED = "statusModified";
    public static final String STATUS_STARTED = "started";
    public static final String STATUS_FINISHED = "finished";
    protected static final String DRYRUN_EXPR = String.format("${%s}", "dryRun");
    protected ResourceResolver resolver;
    protected ValueMap properties;
    protected Resource resource;
    protected ContainerPipe parent;
    protected String distributionAgent;
    protected PipeBindings bindings;
    protected ReferencePipe referrer;
    public static final List<String> IGNORED_PROPERTIES = Arrays.asList("jcr:lastModified", "jcr:primaryType", "jcr:created", "jcr:createdBy");
    protected Boolean dryRunObject;
    protected Plumber plumber;
    private String name;
    public static final Iterator<Resource> EMPTY_ITERATOR = Collections.emptyIterator();

    @Override
    public ContainerPipe getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ContainerPipe parent) {
        this.parent = parent;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public BasePipe(Plumber plumber, Resource resource) throws Exception {
        this.resource = resource;
        this.properties = (ValueMap)resource.adaptTo(ValueMap.class);
        this.resolver = resource.getResourceResolver();
        this.plumber = plumber;
        this.name = (String)this.properties.get("name", (Object)resource.getName());
        this.distributionAgent = (String)this.properties.get("distribution.agent", String.class);
        this.bindings = new PipeBindings(resource);
    }

    @Override
    public boolean isDryRun() {
        if (this.dryRunObject == null) {
            Boolean run;
            this.dryRunObject = false;
            Boolean bl = run = this.bindings.isBindingDefined(DRYRUN_KEY) ? this.bindings.instantiateObject(DRYRUN_EXPR) : Boolean.valueOf(false);
            if (run != null) {
                this.dryRunObject = true;
                if (run instanceof Boolean) {
                    this.dryRunObject = run;
                } else if (run instanceof String && String.format("%s", Boolean.FALSE).equals(run)) {
                    this.dryRunObject = false;
                }
            }
        }
        return this.dryRunObject;
    }

    public String toString() {
        return this.name + " (path: " + this.resource.getPath() + ", dryRun: " + this.isDryRun() + ", modifiesContent: " + this.modifiesContent() + ")";
    }

    @Override
    public boolean modifiesContent() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getExpr() {
        String rawExpression = (String)this.properties.get("expr", (Object)"");
        return this.bindings.instantiateExpression(rawExpression);
    }

    public String getPath() {
        String rawPath = (String)this.properties.get("path", (Object)"");
        return this.bindings.instantiateExpression(rawPath);
    }

    @Override
    public Resource getConfiguredInput() {
        Resource configuredInput = null;
        String path = this.getPath();
        if (StringUtils.isNotBlank((CharSequence)path) && (configuredInput = this.resolver.getResource(path)) == null) {
            this.logger.warn("configured path {} is not found, expect some troubles...", (Object)path);
        }
        return configuredInput;
    }

    protected Pipe getPreviousPipe() {
        return this.referrer == null ? (this.parent != null ? this.parent.getPreviousPipe(this) : null) : this.referrer.getPreviousPipe();
    }

    @Override
    public Resource getInput() {
        Pipe previousPipe;
        Resource resource = this.getConfiguredInput();
        if (resource == null && this.parent != null && (previousPipe = this.getPreviousPipe()) != null) {
            return this.bindings.getExecutedResource(previousPipe.getName());
        }
        this.logger.debug("input for this pipe is {}", (Object)(resource != null ? resource.getPath() : null));
        return resource;
    }

    @Override
    public Object getOutputBinding() {
        Resource resource;
        if (this.parent != null && (resource = this.bindings.getExecutedResource(this.getName())) != null) {
            return resource.adaptTo(ValueMap.class);
        }
        return null;
    }

    @Override
    public PipeBindings getBindings() {
        return this.bindings;
    }

    @Override
    public void setBindings(PipeBindings bindings) {
        this.bindings = bindings;
    }

    @Override
    public Iterator<Resource> getOutput() {
        Resource resource = this.getInput();
        if (resource != null) {
            return Collections.singleton(resource).iterator();
        }
        return EMPTY_ITERATOR;
    }

    public Resource getConfiguration() {
        return this.resource.getChild("conf");
    }

    @Override
    public String getDistributionAgent() {
        return this.distributionAgent;
    }

    @Override
    public void setReferrer(ReferencePipe pipe) {
        this.referrer = pipe;
    }
}

