/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.jacksonexporter.ModuleProvider;
import org.apache.sling.models.jacksonexporter.impl.IgnoringResourceResolverMixin;
import org.apache.sling.models.jacksonexporter.impl.WarningResourceResolverMixin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ModuleProvider.class})
@Designate(ocd=Config.class)
public class ConfigurableSerializationModuleProvider
implements ModuleProvider {
    protected static final String RESOURCERESOLVER = "org.apache.sling.api.resource.ResourceResolver";
    SimpleModule moduleInstance;

    @Activate
    private void activate(Config config) {
        this.moduleInstance = new SimpleModule();
        List<String> disabled = Arrays.asList(config.disable_serialization());
        List<String> logging = Arrays.asList(config.enable_warn_logging());
        if (disabled.contains(RESOURCERESOLVER)) {
            this.moduleInstance.setMixInAnnotation(ResourceResolver.class, IgnoringResourceResolverMixin.class);
        } else if (logging.contains(RESOURCERESOLVER)) {
            this.moduleInstance.setMixInAnnotation(ResourceResolver.class, WarningResourceResolverMixin.class);
        }
    }

    @Override
    public Module getModule() {
        return this.moduleInstance;
    }

    @ObjectClassDefinition(name="Apache Sling Models Jackson Exporter - Serialization Blocker", description="Provider of a Jackson Module which can disable the serialization of classes")
    static @interface Config {
        @AttributeDefinition(name="disable serialization", description="provide a list of the full classnames which should not get serialized")
        public String[] disable_serialization() default {};

        @AttributeDefinition(name="warn on serialization", description="provide a list of the full classnames for which a warning should be written when serialized")
        public String[] enable_warn_logging() default {"org.apache.sling.api.resource.ResourceResolver"};
    }
}

