/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.apache.sling.models.export.spi.ModelExporter;
import org.apache.sling.models.factory.ExportException;
import org.apache.sling.models.jacksonexporter.ModuleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class JacksonExporter
implements ModelExporter {
    private static final Logger log = LoggerFactory.getLogger(JacksonExporter.class);
    private static final String SERIALIZATION_FEATURE_PREFIX = SerializationFeature.class.getSimpleName() + ".";
    private static final int SERIALIZATION_FEATURE_PREFIX_LENGTH = SERIALIZATION_FEATURE_PREFIX.length();
    private static final String MAPPER_FEATURE_PREFIX = MapperFeature.class.getSimpleName() + ".";
    private static final int MAPPER_FEATURE_PREFIX_LENGTH = MAPPER_FEATURE_PREFIX.length();
    @Reference(name="moduleProvider", referenceInterface=ModuleProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final RankedServices<ModuleProvider> moduleProviders = new RankedServices(Order.ASCENDING);

    public boolean isSupported(@Nonnull Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(Map.class);
    }

    public <T> T export(@Nonnull Object model, @Nonnull Class<T> clazz, @Nonnull Map<String, String> options) throws ExportException {
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry<String, String> optionEntry : options.entrySet()) {
            SerializationFeature feature;
            String enumName;
            String key = optionEntry.getKey();
            if (key.startsWith(SERIALIZATION_FEATURE_PREFIX)) {
                enumName = key.substring(SERIALIZATION_FEATURE_PREFIX_LENGTH);
                try {
                    feature = SerializationFeature.valueOf((String)enumName);
                    mapper.configure(feature, Boolean.valueOf(optionEntry.getValue()).booleanValue());
                }
                catch (IllegalArgumentException e) {
                    log.warn("Bad SerializationFeature option");
                }
                continue;
            }
            if (!key.startsWith(MAPPER_FEATURE_PREFIX)) continue;
            enumName = key.substring(MAPPER_FEATURE_PREFIX_LENGTH);
            try {
                feature = MapperFeature.valueOf((String)enumName);
                mapper.configure((MapperFeature)feature, Boolean.valueOf(optionEntry.getValue()).booleanValue());
            }
            catch (IllegalArgumentException e) {
                log.warn("Bad SerializationFeature option");
            }
        }
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            mapper.registerModule(moduleProvider.getModule());
        }
        if (clazz.equals(Map.class)) {
            return (T)mapper.convertValue(model, Map.class);
        }
        if (clazz.equals(String.class)) {
            JsonFactory f = new JsonFactory();
            f.setCharacterEscapes((CharacterEscapes)new EscapeCloseScriptBlocks());
            StringWriter writer = new StringWriter();
            boolean printTidy = options.containsKey("tidy") ? Boolean.valueOf(options.get("tidy")) : false;
            try {
                JsonGenerator jgen = f.createGenerator((Writer)writer);
                if (printTidy) {
                    mapper.writerWithDefaultPrettyPrinter().writeValue(jgen, model);
                } else {
                    mapper.writeValue(jgen, model);
                }
            }
            catch (IOException e) {
                throw new ExportException((Throwable)e);
            }
            return (T)writer.toString();
        }
        return null;
    }

    protected void bindModuleProvider(ModuleProvider moduleProvider, Map<String, Object> props) {
        this.moduleProviders.bind(moduleProvider, props);
    }

    protected void unbindModuleProvider(ModuleProvider moduleProvider, Map<String, Object> props) {
        this.moduleProviders.unbind(moduleProvider, props);
    }

    @Nonnull
    public String getName() {
        return "jackson";
    }

    private static class EscapeCloseScriptBlocks
    extends CharacterEscapes {
        private final int[] escapes;

        EscapeCloseScriptBlocks() {
            int[] baseEscapes = EscapeCloseScriptBlocks.standardAsciiEscapesForJSON();
            baseEscapes[60] = -1;
            baseEscapes[62] = -1;
            this.escapes = baseEscapes;
        }

        public int[] getEscapeCodesForAscii() {
            return this.escapes;
        }

        public SerializableString getEscapeSequence(int arg0) {
            return null;
        }
    }
}

