/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotation;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static List<Field> collectInjectableFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (type != null) {
            AnnotatedElement[] fields = type.getDeclaredFields();
            ReflectionUtil.addAnnotated((AnnotatedElement[])fields, result);
            type = type.getSuperclass();
        }
        return result;
    }

    public static List<Method> collectInjectableMethods(Class<?> type) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (type != null) {
            AnnotatedElement[] methods = type.getDeclaredMethods();
            ReflectionUtil.addAnnotated((AnnotatedElement[])methods, result);
            ReflectionUtil.addAnnotatedMethodsFromInterfaces(type, result);
            type = type.getSuperclass();
        }
        return result;
    }

    private static void addAnnotatedMethodsFromInterfaces(Class<?> type, List<Method> result) {
        for (Class<?> iface : type.getInterfaces()) {
            AnnotatedElement[] methods = iface.getDeclaredMethods();
            ReflectionUtil.addAnnotated((AnnotatedElement[])methods, result);
            ReflectionUtil.addAnnotatedMethodsFromInterfaces(iface, result);
        }
    }

    public static <T extends AnnotatedElement> void addAnnotated(T[] elements, List<T> set) {
        for (T element : elements) {
            Inject injection = ReflectionUtil.getAnnotation(element, Inject.class);
            if (injection != null) {
                set.add(element);
                continue;
            }
            InjectAnnotation modelInject = ReflectionUtil.getAnnotation(element, InjectAnnotation.class);
            if (modelInject == null) continue;
            set.add(element);
        }
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        T annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation ann : element.getAnnotations()) {
            annotation = ann.annotationType().getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static Type mapPrimitiveClasses(Type type) {
        if (type instanceof Class) {
            return ClassUtils.primitiveToWrapper((Class)((Class)type));
        }
        return type;
    }

    public static Type mapWrapperClasses(Type type) {
        if (type instanceof Class) {
            return ClassUtils.wrapperToPrimitive((Class)((Class)type));
        }
        return type;
    }

    public static boolean isRecord(Class<?> checkedType) {
        try {
            Class<?> recordType = Class.forName("java.lang.Record");
            return recordType.isAssignableFrom(checkedType);
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static boolean areBalancedCtorParamsAndFields(Constructor<?> constructor) {
        Class<?> declaringClass;
        Field[] fields;
        long numOfFields;
        int numOfCtorParams = constructor.getParameterCount();
        return (long)numOfCtorParams == (numOfFields = Arrays.stream(fields = (declaringClass = constructor.getDeclaringClass()).getDeclaredFields()).filter(field -> !field.isSynthetic()).count());
    }
}

