/*
 * Decompiled with CFR 0.152.
 */
package slingmodelsimpl.org.apache.sling.scripting.core.impl.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedBindings
implements Bindings {
    private final Bindings wrapped;
    private final Set<String> protectedKeys;

    public ProtectedBindings(Bindings wrapped, Set<String> protectedKeys) {
        this.wrapped = wrapped;
        this.protectedKeys = protectedKeys;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.protectedKeys.contains(key)) {
            throw new IllegalArgumentException(String.format("Key %s is protected.", key));
        }
        return this.wrapped.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (String string : toMerge.keySet()) {
            if (this.protectedKeys.contains(string)) continue;
            this.wrapped.put(string, toMerge.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        if (this.protectedKeys.contains(key)) {
            throw new IllegalArgumentException(String.format("Key %s is protected.", key));
        }
        return this.wrapped.remove(key);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ProtectedBindings does not support clear()");
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.wrapped.entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.wrapped.keySet());
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.wrapped.values());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.wrapped.get(key);
    }
}

