/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.annotations.via.BeanProperty;
import org.apache.sling.models.spi.ViaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class BeanPropertyViaProvider
implements ViaProvider {
    private static final Logger log = LoggerFactory.getLogger(BeanPropertyViaProvider.class);

    public Class<? extends ViaProviderType> getType() {
        return BeanProperty.class;
    }

    public Object getAdaptable(Object original, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return ORIGINAL;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(original.getClass());
            for (PropertyDescriptor desc : beanInfo.getPropertyDescriptors()) {
                if (!desc.getName().equals(value)) continue;
                return desc.getReadMethod().invoke(original, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Unable to execution projection " + value, (Throwable)e);
        }
        return null;
    }
}

