/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.ValuePreparer;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;

@Component
@Service
@Property(name="service.ranking", intValue={1000})
public class BindingsInjector
implements Injector,
StaticInjectAnnotationProcessorFactory,
ValuePreparer {
    @NotNull
    public String getName() {
        return "script-bindings";
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        if (adaptable == ObjectUtils.NULL) {
            return null;
        }
        SlingBindings bindings = this.getBindings(adaptable);
        if (bindings == null) {
            return null;
        }
        return bindings.get((Object)name);
    }

    private SlingBindings getBindings(Object adaptable) {
        if (adaptable instanceof SlingBindings) {
            return (SlingBindings)adaptable;
        }
        if (adaptable instanceof ServletRequest) {
            ServletRequest request = (ServletRequest)adaptable;
            return (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        }
        return null;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        ScriptVariable annotation = element.getAnnotation(ScriptVariable.class);
        if (annotation != null) {
            return new ScriptVariableAnnotationProcessor(annotation);
        }
        return null;
    }

    public Object prepareValue(Object adaptable) {
        SlingBindings prepared = this.getBindings(adaptable);
        return prepared != null ? prepared : ObjectUtils.NULL;
    }

    private static class ScriptVariableAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final ScriptVariable annotation;

        public ScriptVariableAnnotationProcessor(ScriptVariable annotation) {
            this.annotation = annotation;
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }

        public String getName() {
            if (this.annotation.name().isEmpty()) {
                return null;
            }
            return this.annotation.name();
        }
    }
}

