/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SlingRepositoryInitializer.class})
public class SystemUsersInitializer
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String REPOINIT_FILE = "/repoinit.txt";
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        Session s = repo.loginAdministrative(null);
        InputStream is = this.getClass().getResourceAsStream(REPOINIT_FILE);
        try {
            if (is == null) {
                throw new IOException("Class Resource not found:/repoinit.txt");
            }
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            List ops = this.parser.parse((Reader)r);
            this.log.info("Executing {} repoinit Operations", (Object)ops.size());
            this.processor.apply(s, ops);
            s.save();
        }
        finally {
            s.logout();
            is.close();
        }
    }

    protected void bindParser(RepoInitParser repoInitParser) {
        this.parser = repoInitParser;
    }

    protected void unbindParser(RepoInitParser repoInitParser) {
        if (this.parser == repoInitParser) {
            this.parser = null;
        }
    }

    protected void bindProcessor(JcrRepoInitOpsProcessor jcrRepoInitOpsProcessor) {
        this.processor = jcrRepoInitOpsProcessor;
    }

    protected void unbindProcessor(JcrRepoInitOpsProcessor jcrRepoInitOpsProcessor) {
        if (this.processor == jcrRepoInitOpsProcessor) {
            this.processor = null;
        }
    }
}

