/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.serversidetests;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.junit.annotations.SlingAnnotationsTestRunner;
import org.apache.sling.junit.annotations.TestReference;
import org.apache.sling.launchpad.testservices.events.EventsCounter;
import org.apache.sling.launchpad.testservices.exported.FakeSlingHttpServletRequest;
import org.apache.sling.launchpad.testservices.serversidetests.MappingsFacade;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=SlingAnnotationsTestRunner.class)
public class ResourceResolverWithVanityBloomFilterTest {
    public static final String PROP_REDIRECT_INTERNAL = "sling:internalRedirect";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String MAPPING_EVENT_TOPIC = "org/apache/sling/api/resource/ResourceResolverMapping/CHANGED";
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolverWithVanityBloomFilterTest.class);
    private static ResourceResolver resResolver;
    private static Session session;
    private String rootPath;
    private Node rootNode;
    private Node mapRoot;
    private String[] vanity;
    private static List<String> toDelete;
    private static ResourceResolverFactory cleanupResolverFactory;
    private MappingsFacade mappingsFacade;
    @TestReference
    private EventsCounter eventsCounter;
    @TestReference
    private ResourceResolverFactory resourceResolverFactory;

    private Node maybeCreateNode(Node parent, String name, String type) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, type);
    }

    private void saveMappings(Session s) throws Exception {
        String saveMappingsError = this.mappingsFacade.saveMappings(s);
        if (saveMappingsError != null) {
            Assert.fail((String)saveMappingsError);
        }
    }

    @Before
    public synchronized void setup() throws Exception {
        this.closeResolver();
        resResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        this.setMaxCachedVanityPathEntries(0L);
        cleanupResolverFactory = this.resourceResolverFactory;
        session = (Session)resResolver.adaptTo(Session.class);
        this.mappingsFacade = new MappingsFacade(this.eventsCounter);
        this.rootNode = this.maybeCreateNode(session.getRootNode(), "content", "nt:unstructured");
        this.rootPath = this.rootNode.getPath();
        session.save();
        if (toDelete.isEmpty()) {
            Node mapRoot = this.maybeCreateNode(session.getRootNode(), "etc", "nt:folder");
            Node map = this.maybeCreateNode(mapRoot, "map", "sling:Mapping");
            Node http = this.maybeCreateNode(map, "http", "sling:Mapping");
            this.maybeCreateNode(http, "localhost.80", "sling:Mapping");
            Node https = this.maybeCreateNode(map, "https", "sling:Mapping");
            this.maybeCreateNode(https, "localhost.443", "sling:Mapping");
            toDelete.add(map.getPath());
            toDelete.add(this.rootNode.getPath());
        }
        this.mapRoot = session.getNode("/etc");
        session.save();
        this.vanity = new String[]{"testVanity", "testV", "testVanityToUpdate"};
        this.rootNode.setProperty("sling:vanityPath", this.vanity);
        this.rootNode.addMixin("sling:VanityPath");
        this.saveMappings(session);
    }

    private void closeResolver() {
        if (session != null) {
            if (session.isLive()) {
                session.logout();
            }
            session = null;
        }
        if (resResolver != null) {
            resResolver.close();
            resResolver = null;
        }
    }

    private void setMaxCachedVanityPathEntries(long maxCachedVanityPathEntries) throws Exception {
        Field commonFactory = this.resourceResolverFactory.getClass().getDeclaredField("commonFactory");
        commonFactory.setAccessible(true);
        Object commonResourceResolverFactoryImpl = commonFactory.get(this.resourceResolverFactory);
        Field mapEntries = commonResourceResolverFactoryImpl.getClass().getDeclaredField("mapEntries");
        mapEntries.setAccessible(true);
        Object mapEntriesObject = mapEntries.get(commonResourceResolverFactoryImpl);
        Field maxCachedVanityPathEntriesField = mapEntriesObject.getClass().getDeclaredField("maxCachedVanityPathEntries");
        maxCachedVanityPathEntriesField.setAccessible(true);
        maxCachedVanityPathEntriesField.setLong(mapEntriesObject, maxCachedVanityPathEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void deleteTestNodes() throws Exception {
        logger.debug("{} test done, deleting test nodes", (Object)ResourceResolverWithVanityBloomFilterTest.class.getSimpleName());
        this.setMaxCachedVanityPathEntries(-1L);
        ResourceResolver resolver = cleanupResolverFactory.getAdministrativeResourceResolver(null);
        Session session = (Session)resolver.adaptTo(Session.class);
        try {
            for (String path : toDelete) {
                if (!session.itemExists(path)) continue;
                session.getItem(path).remove();
            }
            toDelete.clear();
            session.save();
        }
        finally {
            session.logout();
            resolver.close();
        }
    }

    @Test
    public void test_clone_based_on_anonymous() throws Exception {
        ResourceResolver anon0 = this.resourceResolverFactory.getResourceResolver((Map)null);
        Session anon0Session = (Session)anon0.adaptTo(Session.class);
        Assert.assertEquals((Object)"anonymous", (Object)anon0.getUserID());
        ResourceResolver anon1 = anon0.clone(null);
        Session anon1Session = (Session)anon1.adaptTo(Session.class);
        Assert.assertEquals((Object)anon0.getUserID(), (Object)anon1.getUserID());
        Assert.assertEquals((Object)anon0Session.getWorkspace().getName(), (Object)anon1Session.getWorkspace().getName());
        anon1.close();
        HashMap<String, Object> admin0Cred = new HashMap<String, Object>();
        admin0Cred.put("user.name", "admin");
        admin0Cred.put("user.password", "admin".toCharArray());
        ResourceResolver admin0 = anon0.clone(admin0Cred);
        Session admin0Session = (Session)admin0.adaptTo(Session.class);
        Assert.assertEquals((Object)"admin", (Object)admin0.getUserID());
        Assert.assertEquals((Object)anon0Session.getWorkspace().getName(), (Object)admin0Session.getWorkspace().getName());
        admin0.close();
        HashMap anon2Cred = new HashMap();
        ResourceResolver anon2 = anon0.clone(anon2Cred);
        Assert.assertEquals((Object)"anonymous", (Object)anon2.getUserID());
        anon2.close();
        HashMap<String, Object> admin1Cred = new HashMap<String, Object>();
        admin1Cred.put("user.name", "admin");
        admin1Cred.put("user.password", "admin".toCharArray());
        ResourceResolver admin1 = anon0.clone(admin1Cred);
        Assert.assertEquals((Object)"admin", (Object)admin1.getUserID());
        admin1.close();
        anon0.close();
    }

    @Test
    public void test_clone_based_on_admin() throws Exception {
        ResourceResolver admin0 = this.resourceResolverFactory.getAdministrativeResourceResolver((Map)null);
        Session admin0Session = (Session)admin0.adaptTo(Session.class);
        Assert.assertEquals((Object)"admin", (Object)admin0.getUserID());
        ResourceResolver admin1 = admin0.clone(null);
        Session admin1Session = (Session)admin1.adaptTo(Session.class);
        Assert.assertEquals((Object)admin0.getUserID(), (Object)admin1.getUserID());
        Assert.assertEquals((Object)admin0Session.getWorkspace().getName(), (Object)admin1Session.getWorkspace().getName());
        admin1.close();
        HashMap<String, String> anon0Cred = new HashMap<String, String>();
        anon0Cred.put("user.name", "anonymous");
        ResourceResolver anon0 = admin0.clone(anon0Cred);
        Session anon0Session = (Session)anon0.adaptTo(Session.class);
        Assert.assertEquals((Object)"anonymous", (Object)anon0.getUserID());
        Assert.assertEquals((Object)admin0Session.getWorkspace().getName(), (Object)anon0Session.getWorkspace().getName());
        anon0.close();
        HashMap admin2Cred = new HashMap();
        ResourceResolver admin2 = admin0.clone(admin2Cred);
        Assert.assertEquals((Object)"admin", (Object)admin2.getUserID());
        admin2.close();
        HashMap<String, String> anon1Cred = new HashMap<String, String>();
        anon1Cred.put("user.name", "anonymous");
        ResourceResolver anon1 = admin0.clone(anon1Cred);
        Assert.assertEquals((Object)"anonymous", (Object)anon1.getUserID());
        anon1.close();
        admin0.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_attributes_from_authInfo() throws Exception {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.name", "admin");
        authInfo.put("user.password", "admin".toCharArray());
        authInfo.put("testAttributeString", "AStringValue");
        authInfo.put("testAttributeNumber", 999);
        ResourceResolver rr = this.resourceResolverFactory.getResourceResolver(authInfo);
        Session s = (Session)rr.adaptTo(Session.class);
        try {
            Assert.assertEquals((String)"Expect 3 session attributes", (long)3L, (long)s.getAttributeNames().length);
            Assert.assertEquals((Object)"AStringValue", (Object)s.getAttribute("testAttributeString"));
            Assert.assertEquals((Object)999, (Object)s.getAttribute("testAttributeNumber"));
            Assert.assertEquals((Object)"admin", (Object)s.getAttribute("user.name"));
            Assert.assertNull((Object)session.getAttribute("user.password"));
            Assert.assertEquals((Object)"AStringValue", (Object)rr.getAttribute("testAttributeString"));
            Assert.assertEquals((Object)999, (Object)rr.getAttribute("testAttributeNumber"));
            Assert.assertEquals((Object)"admin", (Object)rr.getAttribute("user.name"));
            Assert.assertNull((Object)rr.getAttribute("user.password"));
            HashSet<String> validNames = new HashSet<String>();
            validNames.add("user.name");
            validNames.add("testAttributeString");
            validNames.add("testAttributeNumber");
            Iterator names = rr.getAttributeNames();
            Assert.assertTrue((boolean)validNames.remove(names.next()));
            Assert.assertTrue((boolean)validNames.remove(names.next()));
            Assert.assertTrue((boolean)validNames.remove(names.next()));
            Assert.assertFalse((String)"Expect no more names", (boolean)names.hasNext());
            Assert.assertTrue((String)"Expect validNames set to be empty now", (boolean)validNames.isEmpty());
        }
        finally {
            rr.close();
        }
    }

    @Test
    public void testGetResource() throws Exception {
        Resource res = resResolver.getResource(this.rootPath);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        String path = this.rootPath + "/missing";
        res = resResolver.getResource(path);
        Assert.assertNull((Object)res);
    }

    @Test
    public void testResolveResource() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(this.rootPath);
        Resource res = resResolver.resolve((HttpServletRequest)request, this.rootPath);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        String path = this.rootPath + "/missing";
        res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path), path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)path, (Object)res.getPath());
        Assert.assertEquals((Object)"sling:nonexisting", (Object)res.getResourceType());
        Assert.assertNull((Object)res.adaptTo(Node.class));
        path = this.rootPath + ".print.a4.html";
        res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path), path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = this.rootPath + System.currentTimeMillis();
        res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path), path);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)ResourceUtil.isNonExistingResource((Resource)res));
        Assert.assertEquals((Object)path, (Object)res.getPath());
        Assert.assertEquals((Object)"sling:nonexisting", (Object)res.getResourceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceExternalRedirect() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        localhost443.setProperty(PROP_REDIRECT_EXTERNAL, "http://localhost");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, this.rootPath);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)PROP_REDIRECT_EXTERNAL, (Object)res.getResourceType());
            Assert.assertNotNull((Object)res.adaptTo(ValueMap.class));
            Assert.assertEquals((Object)("http://localhost" + this.rootPath), (Object)((ValueMap)res.adaptTo(ValueMap.class)).get("sling:target", String.class));
        }
        finally {
            localhost443.getProperty(PROP_REDIRECT_EXTERNAL).remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceInternalRedirectUrl() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        localhost443.setProperty(PROP_REDIRECT_INTERNAL, "http://localhost");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, this.rootPath);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        }
        finally {
            localhost443.getProperty(PROP_REDIRECT_INTERNAL).remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceInternalRedirectPath() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        Node toContent = localhost443.addNode("_playground_designground_", "sling:Mapping");
        toContent.setProperty("sling:match", "(playground|designground)");
        toContent.setProperty(PROP_REDIRECT_INTERNAL, "/content/$1");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/playground.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/playground/en.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/libs/nt/folder.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/libs/nt/folder.html", (Object)res.getPath());
        }
        finally {
            toContent.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceInternalRedirectPathAndVanityPath() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        localhost443.setProperty(PROP_REDIRECT_INTERNAL, "/example");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, this.vanity[0]);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, this.vanity[1]);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)("/example/" + this.vanity[1]), (Object)res.getPath());
        }
        finally {
            localhost443.getProperty(PROP_REDIRECT_INTERNAL).remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceInternalRedirectPathUpdate() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        Node toContent = localhost443.addNode("_playground_designground_", "sling:Mapping");
        toContent.setProperty("sling:match", "(playground|designground)");
        toContent.setProperty(PROP_REDIRECT_INTERNAL, "/content/$1");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/playground.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/playground/en.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/libs/nt/folder.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/libs/nt/folder.html", (Object)res.getPath());
            toContent.setProperty("sling:match", "(homeground|foreignground)");
            this.saveMappings(session);
            res = resResolver.resolve((HttpServletRequest)request, "/homeground.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/homeground.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/foreignground/en.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/foreignground/en.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/libs/nt/folder.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/libs/nt/folder.html", (Object)res.getPath());
        }
        finally {
            toContent.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceInternalRedirectExact() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        Node toContent = localhost443.addNode("virtual", "sling:Mapping");
        toContent.setProperty("sling:match", "virtual$");
        toContent.setProperty(PROP_REDIRECT_INTERNAL, "/content/virtual.html");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, "/virtual");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content/virtual.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/virtual.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/virtual.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/virtual/child.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/virtual/child.html", (Object)res.getPath());
            String url = resResolver.map(null, "/content/virtual.html");
            Assert.assertNotNull((Object)url);
            Assert.assertEquals((Object)"https://localhost/virtual", (Object)url);
            url = resResolver.map((HttpServletRequest)request, "/content/virtual.html");
            Assert.assertNotNull((Object)url);
            Assert.assertEquals((Object)"/virtual", (Object)url);
        }
        finally {
            toContent.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceInternalRedirectDepthFirst() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", null, -1, this.rootPath);
        Node localhost443 = this.mapRoot.getNode("map/https/localhost.443");
        localhost443.setProperty(PROP_REDIRECT_INTERNAL, "/content2");
        Node toContent = localhost443.addNode("virtual", "sling:Mapping");
        toContent.setProperty("sling:match", "virtual$");
        toContent.setProperty(PROP_REDIRECT_INTERNAL, "/content2/virtual.html");
        try {
            this.saveMappings(session);
            Resource res = resResolver.resolve((HttpServletRequest)request, "/virtual");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content2/virtual.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/virtual.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content2/virtual.html", (Object)res.getPath());
            res = resResolver.resolve((HttpServletRequest)request, "/virtual/child.html");
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)"/content2/virtual/child.html", (Object)res.getPath());
        }
        finally {
            localhost443.getProperty(PROP_REDIRECT_INTERNAL).remove();
            toContent.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttp80() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(null, "virtual.host.com", -1, this.rootPath);
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("virtual.host.com.80", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/content/virtual");
        try {
            this.saveMappings(session);
            Resource res0 = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res0);
            Assert.assertEquals((Object)"/content/virtual/playground.html", (Object)res0.getPath());
            Resource res1 = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res1);
            Assert.assertEquals((Object)"/content/virtual/playground/en.html", (Object)res1.getPath());
            String mapped00 = resResolver.map(res0.getPath());
            Assert.assertEquals((Object)"http://virtual.host.com/playground.html", (Object)mapped00);
            String mapped01 = resResolver.map((HttpServletRequest)request, res0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mapped01);
            String mapped10 = resResolver.map(res1.getPath());
            Assert.assertEquals((Object)"http://virtual.host.com/playground/en.html", (Object)mapped10);
            String mapped11 = resResolver.map((HttpServletRequest)request, res1.getPath());
            Assert.assertEquals((Object)"/playground/en.html", (Object)mapped11);
        }
        finally {
            virtualhost80.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttp80Multiple() throws Exception {
        String de = "de";
        String en = "en";
        String hostDE = "de.host.com";
        String hostEN = "en.host.com";
        String contentDE = "/content/de";
        String contentEN = "/content/en";
        Node virtualhost80a = this.mapRoot.getNode("map/http").addNode("de.host.com.80", "sling:Mapping");
        virtualhost80a.setProperty(PROP_REDIRECT_INTERNAL, "/content/de");
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("en.host.com.80", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/content/en");
        try {
            this.saveMappings(session);
            FakeSlingHttpServletRequest requestDE = new FakeSlingHttpServletRequest(null, "de.host.com", -1, this.rootPath);
            Resource resDE0 = resResolver.resolve((HttpServletRequest)requestDE, "/playground.html");
            Assert.assertNotNull((Object)resDE0);
            Assert.assertEquals((Object)"/content/de/playground.html", (Object)resDE0.getPath());
            Resource resDE1 = resResolver.resolve((HttpServletRequest)requestDE, "/playground/index.html");
            Assert.assertNotNull((Object)resDE1);
            Assert.assertEquals((Object)"/content/de/playground/index.html", (Object)resDE1.getPath());
            String mappedDE00 = resResolver.map(resDE0.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground.html", (Object)mappedDE00);
            String mappedDE01 = resResolver.map((HttpServletRequest)requestDE, resDE0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mappedDE01);
            String mappedDE10 = resResolver.map(resDE1.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground/index.html", (Object)mappedDE10);
            String mappedDE11 = resResolver.map((HttpServletRequest)requestDE, resDE1.getPath());
            Assert.assertEquals((Object)"/playground/index.html", (Object)mappedDE11);
            FakeSlingHttpServletRequest requestEN = new FakeSlingHttpServletRequest(null, "en.host.com", -1, this.rootPath);
            Resource resEN0 = resResolver.resolve((HttpServletRequest)requestEN, "/playground.html");
            Assert.assertNotNull((Object)resEN0);
            Assert.assertEquals((Object)"/content/en/playground.html", (Object)resEN0.getPath());
            Resource resEN1 = resResolver.resolve((HttpServletRequest)requestEN, "/playground/index.html");
            Assert.assertNotNull((Object)resEN1);
            Assert.assertEquals((Object)"/content/en/playground/index.html", (Object)resEN1.getPath());
            String mappedEN00 = resResolver.map(resEN0.getPath());
            Assert.assertEquals((Object)"http://en.host.com/playground.html", (Object)mappedEN00);
            String mappedEN01 = resResolver.map((HttpServletRequest)requestEN, resEN0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mappedEN01);
            String mappedEN10 = resResolver.map(resEN1.getPath());
            Assert.assertEquals((Object)"http://en.host.com/playground/index.html", (Object)mappedEN10);
            String mappedEN11 = resResolver.map((HttpServletRequest)requestEN, resEN1.getPath());
            Assert.assertEquals((Object)"/playground/index.html", (Object)mappedEN11);
        }
        finally {
            virtualhost80a.remove();
            virtualhost80.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttp80MultipleRoot() throws Exception {
        String de = "de";
        String en = "en";
        String fr = "fr";
        String hostDE = "de.host.com";
        String hostEN = "en.host.com";
        String hostFR = "fr.host.com";
        Node virtualhost80a = this.mapRoot.getNode("map/http").addNode("de.host.com.80", "sling:Mapping");
        virtualhost80a.setProperty(PROP_REDIRECT_INTERNAL, "/");
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("en.host.com.80", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/");
        try {
            this.saveMappings(session);
            FakeSlingHttpServletRequest requestDE = new FakeSlingHttpServletRequest(null, "de.host.com", -1, this.rootPath);
            Resource resDE0 = resResolver.resolve((HttpServletRequest)requestDE, "/playground.html");
            Assert.assertNotNull((Object)resDE0);
            Assert.assertEquals((Object)"/playground.html", (Object)resDE0.getPath());
            Resource resDE1 = resResolver.resolve((HttpServletRequest)requestDE, "/playground/index.html");
            Assert.assertNotNull((Object)resDE1);
            Assert.assertEquals((Object)"/playground/index.html", (Object)resDE1.getPath());
            String mappedDE00 = resResolver.map(resDE0.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground.html", (Object)mappedDE00);
            String mappedDE01 = resResolver.map((HttpServletRequest)requestDE, resDE0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mappedDE01);
            String mappedDE10 = resResolver.map(resDE1.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground/index.html", (Object)mappedDE10);
            String mappedDE11 = resResolver.map((HttpServletRequest)requestDE, resDE1.getPath());
            Assert.assertEquals((Object)"/playground/index.html", (Object)mappedDE11);
            FakeSlingHttpServletRequest requestEN = new FakeSlingHttpServletRequest(null, "en.host.com", -1, this.rootPath);
            Resource resEN0 = resResolver.resolve((HttpServletRequest)requestEN, "/playground.html");
            Assert.assertNotNull((Object)resEN0);
            Assert.assertEquals((Object)"/playground.html", (Object)resEN0.getPath());
            Resource resEN1 = resResolver.resolve((HttpServletRequest)requestEN, "/playground/index.html");
            Assert.assertNotNull((Object)resEN1);
            Assert.assertEquals((Object)"/playground/index.html", (Object)resEN1.getPath());
            String mappedEN00 = resResolver.map(resEN0.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground.html", (Object)mappedEN00);
            String mappedEN01 = resResolver.map((HttpServletRequest)requestEN, resEN0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mappedEN01);
            String mappedEN10 = resResolver.map(resEN1.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground/index.html", (Object)mappedEN10);
            String mappedEN11 = resResolver.map((HttpServletRequest)requestEN, resEN1.getPath());
            Assert.assertEquals((Object)"/playground/index.html", (Object)mappedEN11);
            FakeSlingHttpServletRequest requestFR = new FakeSlingHttpServletRequest(null, "fr.host.com", -1, this.rootPath);
            Resource resFR1 = resResolver.resolve((HttpServletRequest)requestFR, "/playground/index.html");
            Assert.assertNotNull((Object)resFR1);
            Assert.assertEquals((Object)"/playground/index.html", (Object)resFR1.getPath());
            String mappedFR10 = resResolver.map(resFR1.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground/index.html", (Object)mappedFR10);
            String mappedFR11 = resResolver.map((HttpServletRequest)requestFR, resFR1.getPath());
            Assert.assertEquals((Object)"http://de.host.com/playground/index.html", (Object)mappedFR11);
        }
        finally {
            virtualhost80a.remove();
            virtualhost80.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttp8080() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(null, "virtual.host.com", 8080, this.rootPath);
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("virtual.host.com.8080", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/content/virtual");
        try {
            this.saveMappings(session);
            Resource res0 = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res0);
            Assert.assertEquals((Object)"/content/virtual/playground.html", (Object)res0.getPath());
            Resource res1 = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res1);
            Assert.assertEquals((Object)"/content/virtual/playground/en.html", (Object)res1.getPath());
            String mapped00 = resResolver.map(res0.getPath());
            Assert.assertEquals((Object)"http://virtual.host.com:8080/playground.html", (Object)mapped00);
            String mapped01 = resResolver.map((HttpServletRequest)request, res0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mapped01);
            String mapped10 = resResolver.map(res1.getPath());
            Assert.assertEquals((Object)"http://virtual.host.com:8080/playground/en.html", (Object)mapped10);
            String mapped11 = resResolver.map((HttpServletRequest)request, res1.getPath());
            Assert.assertEquals((Object)"/playground/en.html", (Object)mapped11);
        }
        finally {
            virtualhost80.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttp8080Root() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(null, "virtual.host.com", 8080, this.rootPath);
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("virtual.host.com.8080", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/");
        try {
            this.saveMappings(session);
            Resource res0 = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res0);
            Assert.assertEquals((Object)"/playground.html", (Object)res0.getPath());
            Resource res1 = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res1);
            Assert.assertEquals((Object)"/playground/en.html", (Object)res1.getPath());
            String mapped00 = resResolver.map(res0.getPath());
            Assert.assertEquals((Object)"http://virtual.host.com:8080/playground.html", (Object)mapped00);
            String mapped01 = resResolver.map((HttpServletRequest)request, res0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mapped01);
            String mapped10 = resResolver.map(res1.getPath());
            Assert.assertEquals((Object)"http://virtual.host.com:8080/playground/en.html", (Object)mapped10);
            String mapped11 = resResolver.map((HttpServletRequest)request, res1.getPath());
            Assert.assertEquals((Object)"/playground/en.html", (Object)mapped11);
        }
        finally {
            virtualhost80.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttps443() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", "virtual.host.com", -1, this.rootPath);
        Node virtualhost443 = this.mapRoot.getNode("map/https").addNode("virtual.host.com.443", "sling:Mapping");
        virtualhost443.setProperty(PROP_REDIRECT_INTERNAL, "/content/virtual");
        try {
            this.saveMappings(session);
            Resource res0 = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res0);
            Assert.assertEquals((Object)"/content/virtual/playground.html", (Object)res0.getPath());
            Resource res1 = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res1);
            Assert.assertEquals((Object)"/content/virtual/playground/en.html", (Object)res1.getPath());
            String mapped00 = resResolver.map(res0.getPath());
            Assert.assertEquals((Object)"https://virtual.host.com/playground.html", (Object)mapped00);
            String mapped01 = resResolver.map((HttpServletRequest)request, res0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mapped01);
            String mapped10 = resResolver.map(res1.getPath());
            Assert.assertEquals((Object)"https://virtual.host.com/playground/en.html", (Object)mapped10);
            String mapped11 = resResolver.map((HttpServletRequest)request, res1.getPath());
            Assert.assertEquals((Object)"/playground/en.html", (Object)mapped11);
        }
        finally {
            virtualhost443.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttps4443() throws Exception {
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest("https", "virtual.host.com", 4443, this.rootPath);
        Node virtualhost4443 = this.mapRoot.getNode("map/https").addNode("virtual.host.com.4443", "sling:Mapping");
        virtualhost4443.setProperty(PROP_REDIRECT_INTERNAL, "/content/virtual");
        try {
            this.saveMappings(session);
            Resource res0 = resResolver.resolve((HttpServletRequest)request, "/playground.html");
            Assert.assertNotNull((Object)res0);
            Assert.assertEquals((Object)"/content/virtual/playground.html", (Object)res0.getPath());
            Resource res1 = resResolver.resolve((HttpServletRequest)request, "/playground/en.html");
            Assert.assertNotNull((Object)res1);
            Assert.assertEquals((Object)"/content/virtual/playground/en.html", (Object)res1.getPath());
            String mapped00 = resResolver.map(res0.getPath());
            Assert.assertEquals((Object)"https://virtual.host.com:4443/playground.html", (Object)mapped00);
            String mapped01 = resResolver.map((HttpServletRequest)request, res0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mapped01);
            String mapped10 = resResolver.map(res1.getPath());
            Assert.assertEquals((Object)"https://virtual.host.com:4443/playground/en.html", (Object)mapped10);
            String mapped11 = resResolver.map((HttpServletRequest)request, res1.getPath());
            Assert.assertEquals((Object)"/playground/en.html", (Object)mapped11);
        }
        finally {
            virtualhost4443.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVirtualHostHttpVsHttps() throws Exception {
        String host0 = "www.host.com";
        String host1 = "secure.host.com";
        String content = "/content/page";
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("www.host.com.80", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/content/page");
        Node virtualhost443 = this.mapRoot.getNode("map/https").addNode("www.host.com.443", "sling:Mapping");
        virtualhost443.setProperty(PROP_REDIRECT_INTERNAL, "/content/page");
        try {
            this.saveMappings(session);
            FakeSlingHttpServletRequest requestHttp0 = new FakeSlingHttpServletRequest(null, "www.host.com", -1, this.rootPath);
            Resource resHttp0 = resResolver.resolve((HttpServletRequest)requestHttp0, "/playground.html");
            Assert.assertNotNull((Object)resHttp0);
            Assert.assertEquals((Object)"/content/page/playground.html", (Object)resHttp0.getPath());
            Resource resHttp1 = resResolver.resolve((HttpServletRequest)requestHttp0, "/playground/index.html");
            Assert.assertNotNull((Object)resHttp1);
            Assert.assertEquals((Object)"/content/page/playground/index.html", (Object)resHttp1.getPath());
            FakeSlingHttpServletRequest requestHttps0 = new FakeSlingHttpServletRequest("https", "www.host.com", -1, this.rootPath);
            Resource resHttps0 = resResolver.resolve((HttpServletRequest)requestHttps0, "/playground.html");
            Assert.assertNotNull((Object)resHttps0);
            Assert.assertEquals((Object)"/content/page/playground.html", (Object)resHttps0.getPath());
            Resource resHttps1 = resResolver.resolve((HttpServletRequest)requestHttps0, "/playground/index.html");
            Assert.assertNotNull((Object)resHttps1);
            Assert.assertEquals((Object)"/content/page/playground/index.html", (Object)resHttps1.getPath());
            String mappedHttp00 = resResolver.map(resHttp0.getPath());
            Assert.assertEquals((Object)"http://www.host.com/playground.html", (Object)mappedHttp00);
            String mappedHttp01 = resResolver.map((HttpServletRequest)requestHttp0, resHttp0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mappedHttp01);
            String mappedHttp10 = resResolver.map(resHttp1.getPath());
            Assert.assertEquals((Object)"http://www.host.com/playground/index.html", (Object)mappedHttp10);
            String mappedHttp11 = resResolver.map((HttpServletRequest)requestHttp0, resHttp1.getPath());
            Assert.assertEquals((Object)"/playground/index.html", (Object)mappedHttp11);
            FakeSlingHttpServletRequest requestHttp1 = new FakeSlingHttpServletRequest(null, "secure.host.com", -1, this.rootPath);
            FakeSlingHttpServletRequest requestHttps1 = new FakeSlingHttpServletRequest("https", "secure.host.com", -1, this.rootPath);
            String mappedHttps00 = resResolver.map(resHttps0.getPath());
            Assert.assertEquals((Object)"http://www.host.com/playground.html", (Object)mappedHttps00);
            String mappedHttps01 = resResolver.map((HttpServletRequest)requestHttps0, resHttps0.getPath());
            Assert.assertEquals((Object)"/playground.html", (Object)mappedHttps01);
            String mappedHttps02 = resResolver.map((HttpServletRequest)requestHttp1, resHttps0.getPath());
            Assert.assertEquals((Object)"http://www.host.com/playground.html", (Object)mappedHttps02);
            String mappedHttps03 = resResolver.map((HttpServletRequest)requestHttps1, resHttps0.getPath());
            Assert.assertEquals((Object)"https://www.host.com/playground.html", (Object)mappedHttps03);
            String mappedHttps10 = resResolver.map(resHttps1.getPath());
            Assert.assertEquals((Object)"http://www.host.com/playground/index.html", (Object)mappedHttps10);
            String mappedHttps11 = resResolver.map((HttpServletRequest)requestHttps0, resHttps1.getPath());
            Assert.assertEquals((Object)"/playground/index.html", (Object)mappedHttps11);
            String mappedHttps12 = resResolver.map((HttpServletRequest)requestHttp1, resHttps1.getPath());
            Assert.assertEquals((Object)"http://www.host.com/playground/index.html", (Object)mappedHttps12);
            String mappedHttps13 = resResolver.map((HttpServletRequest)requestHttps1, resHttps1.getPath());
            Assert.assertEquals((Object)"https://www.host.com/playground/index.html", (Object)mappedHttps13);
        }
        finally {
            virtualhost80.remove();
            virtualhost443.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceAlias() throws Exception {
        String alias = "testAlias";
        this.rootNode.setProperty("sling:alias", alias);
        try {
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        }
        finally {
            this.rootNode.getProperty("sling:alias").remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceAliasWithUpdate() throws Exception {
        String[] alias = new String[]{"testAlias", "testAliasToUpdate"};
        this.rootNode.setProperty("sling:alias", alias);
        try {
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias[1] + ".print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias[1] + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            String[] aliasUpdated = new String[]{"testAlias", "testAliasUpdated"};
            this.rootNode.setProperty("sling:alias", aliasUpdated);
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + aliasUpdated[1] + ".print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + aliasUpdated[1] + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        }
        finally {
            this.rootNode.getProperty("sling:alias").remove();
            session.save();
        }
    }

    @Test
    public void testResolveRemovedResourceAlias() throws Exception {
        String alias = "testAlias";
        this.rootNode.setProperty("sling:alias", alias);
        this.saveMappings(session);
        String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html"));
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
        Resource res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html/suffix.pdf"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        this.rootNode.getProperty("sling:alias").remove();
        this.saveMappings(session);
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)(res instanceof NonExistingResource));
        Assert.assertEquals((Object)("/" + alias + ".print.html"), (Object)res.getPath());
        String childNodeName = "rootChildAlias";
        Node childNode = this.maybeCreateNode(this.rootNode, childNodeName, "nt:unstructured");
        childNode.setProperty("sling:alias", "childAlias");
        this.saveMappings(session);
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.rootPath + "/childAlias.print.html"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)(this.rootPath + "/" + childNodeName), (Object)res.getPath());
        Assert.assertEquals((Object)childNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)childNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.rootPath + "/childAlias.print.html/suffix.pdf"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)(this.rootPath + "/" + childNodeName), (Object)res.getPath());
        Assert.assertEquals((Object)childNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)childNode.isSame((Item)res.adaptTo(Node.class)));
        childNode.remove();
        this.saveMappings(session);
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.rootPath + "/childAlias.print.html"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)(res instanceof NonExistingResource));
        Assert.assertEquals((Object)(this.rootPath + "/childAlias.print.html"), (Object)res.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceAliasJcrContent() throws Exception {
        String alias = "testAlias";
        Node content = this.rootNode.addNode("jcr:content", "nt:unstructured");
        content.setProperty("sling:alias", alias);
        try {
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + "/" + alias + ".print.html"));
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertEquals((String)"GET request resolution does not go up the path", (Object)"sling:nonexisting", (Object)res.getResourceType());
            Node child = this.rootNode.addNode("child", "nt:unstructured");
            child.setProperty("sling:alias", alias);
            try {
                this.saveMappings(session);
                res = resResolver.resolve((HttpServletRequest)request, path);
                Assert.assertEquals((Object)child.getPath(), (Object)res.getPath());
            }
            finally {
                child.remove();
                session.save();
            }
        }
        finally {
            content.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveResourceAliasJcrContentWithUpdate() throws Exception {
        String[] alias = new String[]{"testAlias", "testAliasToUpdate"};
        Node content = this.rootNode.addNode("jcr:content", "nt:unstructured");
        content.setProperty("sling:alias", alias);
        try {
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias[1] + ".print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias[1] + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            String[] aliasUpdated = new String[]{"testAlias", "testAliasUpdated"};
            content.setProperty("sling:alias", aliasUpdated);
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + aliasUpdated[1] + ".print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + aliasUpdated[1] + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        }
        finally {
            content.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveRemovedesourceAliasJcrContent() throws Exception {
        String alias = "testAlias";
        Node content = this.rootNode.addNode("jcr:content", "nt:unstructured");
        content.setProperty("sling:alias", alias);
        try {
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html/suffix.pdf"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
            Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + "/" + alias + ".print.html"));
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertEquals((String)"GET request resolution does not go up the path", (Object)"sling:nonexisting", (Object)res.getResourceType());
            content.getProperty("sling:alias").remove();
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + ".print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertTrue((boolean)(res instanceof NonExistingResource));
            Assert.assertEquals((Object)("/" + alias + ".print.html"), (Object)res.getPath());
        }
        finally {
            content.remove();
            session.save();
        }
    }

    @Test
    public void testResolveVanityPath() throws Exception {
        String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[0] + ".print.html"));
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
        Resource res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[0] + ".print.html/suffix.pdf"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[1] + ".print.html"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[1] + ".print.html/suffix.pdf"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
    }

    @Test
    public void testResolveVanityPathWithUpdate() throws Exception {
        String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[2] + ".print.html"));
        FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
        Resource res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[2] + ".print.html/suffix.pdf"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        String[] vanityPathUpdated = new String[]{"testVanity", "testV", "testVanityUpdated"};
        this.rootNode.setProperty("sling:vanityPath", vanityPathUpdated);
        this.saveMappings(session);
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + vanityPathUpdated[2] + ".print.html"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + vanityPathUpdated[2] + ".print.html/suffix.pdf"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
        Assert.assertEquals((Object)".print.html/suffix.pdf", (Object)res.getResourceMetadata().getResolutionPathInfo());
        Assert.assertNotNull((Object)res.adaptTo(Node.class));
        Assert.assertTrue((boolean)this.rootNode.isSame((Item)res.adaptTo(Node.class)));
        path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + this.vanity[2] + ".print.html"));
        request = new FakeSlingHttpServletRequest(path);
        res = resResolver.resolve((HttpServletRequest)request, path);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)(res instanceof NonExistingResource));
        Assert.assertEquals((Object)("/" + this.vanity[2] + ".print.html"), (Object)res.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testResolveRemovedMixinVanityPath() throws Exception {
        Node childNode = null;
        try {
            childNode = this.maybeCreateNode(this.rootNode, "rootChild", "nt:unstructured");
            childNode.setProperty("sling:vanityPath", "childVanity");
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/childVanity.print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertTrue((boolean)(res instanceof NonExistingResource));
            Assert.assertEquals((Object)"/childVanity.print.html", (Object)res.getPath());
            childNode.addMixin("sling:VanityPath");
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/childVanity.print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)childNode.getPath(), (Object)res.getPath());
            Assert.assertEquals((Object)childNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)childNode.isSame((Item)res.adaptTo(Node.class)));
            childNode.removeMixin("sling:VanityPath");
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/childVanity.print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertTrue((boolean)(res instanceof NonExistingResource));
            Assert.assertEquals((Object)"/childVanity.print.html", (Object)res.getPath());
        }
        finally {
            if (childNode != null) {
                childNode.remove();
                this.saveMappings(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveVanityPathWithVanityOrder() throws Exception {
        Node childNode = null;
        Node childNode2 = null;
        try {
            childNode = this.maybeCreateNode(this.rootNode, "rootChild", "nt:unstructured");
            childNode.setProperty("sling:vanityPath", "childVanity");
            childNode.addMixin("sling:VanityPath");
            this.saveMappings(session);
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/childVanity.print.html"));
            FakeSlingHttpServletRequest request = new FakeSlingHttpServletRequest(path);
            Resource res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)childNode.getPath(), (Object)res.getPath());
            Assert.assertEquals((Object)childNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)childNode.isSame((Item)res.adaptTo(Node.class)));
            childNode2 = this.maybeCreateNode(this.rootNode, "rootChild2", "nt:unstructured");
            childNode2.setProperty("sling:vanityPath", "childVanity");
            childNode2.addMixin("sling:VanityPath");
            this.saveMappings(session);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)childNode.getPath(), (Object)res.getPath());
            Assert.assertEquals((Object)childNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)childNode.isSame((Item)res.adaptTo(Node.class)));
            childNode2.setProperty("sling:vanityOrder", 100L);
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/childVanity.print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)childNode2.getPath(), (Object)res.getPath());
            Assert.assertEquals((Object)childNode2.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)childNode2.isSame((Item)res.adaptTo(Node.class)));
            childNode.setProperty("sling:vanityOrder", 1000L);
            this.saveMappings(session);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/childVanity.print.html"));
            request = new FakeSlingHttpServletRequest(path);
            res = resResolver.resolve((HttpServletRequest)request, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)childNode.getPath(), (Object)res.getPath());
            Assert.assertEquals((Object)childNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
            Assert.assertEquals((Object)".print.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Assert.assertNotNull((Object)res.adaptTo(Node.class));
            Assert.assertTrue((boolean)childNode.isSame((Item)res.adaptTo(Node.class)));
        }
        finally {
            if (childNode != null) {
                childNode.remove();
            }
            if (childNode2 != null) {
                childNode2.remove();
            }
            session.save();
        }
    }

    @Test
    public void testGetDoesNotGoUp() throws Exception {
        String path = this.rootPath + "/nothing";
        Resource res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path, "POST"), path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"POST request resolution does not go up the path", (Object)"sling:nonexisting", (Object)res.getResourceType());
        res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path, "GET"), path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"GET request resolution does not go up the path", (Object)"sling:nonexisting", (Object)res.getResourceType());
    }

    @Test
    public void testGetRemovesExtensionInResolution() throws Exception {
        String path = this.rootPath + ".whatever";
        Resource res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path, "GET"), path);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)this.rootPath, (Object)res.getPath());
        Assert.assertEquals((Object)this.rootNode.getPrimaryNodeType().getName(), (Object)res.getResourceType());
    }

    @Test
    public void testStarResourcePlain() throws Exception {
        String path = this.rootPath + "/" + System.currentTimeMillis() + "/*";
        this.testStarResourceHelper(path, "GET");
        this.testStarResourceHelper(path, "POST");
        this.testStarResourceHelper(path, "PUT");
        this.testStarResourceHelper(path, "DELETE");
    }

    @Test
    public void testStarResourceExtension() throws Exception {
        String path = this.rootPath + "/" + System.currentTimeMillis() + "/*.html";
        this.testStarResourceHelper(path, "GET");
        this.testStarResourceHelper(path, "POST");
        this.testStarResourceHelper(path, "PUT");
        this.testStarResourceHelper(path, "DELETE");
    }

    @Test
    public void testStarResourceSelectorExtension() throws Exception {
        String path = this.rootPath + "/" + System.currentTimeMillis() + "/*.print.a4.html";
        this.testStarResourceHelper(path, "GET");
        this.testStarResourceHelper(path, "POST");
        this.testStarResourceHelper(path, "PUT");
        this.testStarResourceHelper(path, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlingFolder() throws Exception {
        String folderPath = "folder";
        Node folder = this.rootNode.addNode(folderPath, "sling:Folder");
        this.rootNode.getSession().save();
        try {
            Node child = folder.addNode("child0");
            folder.getSession().save();
            Assert.assertEquals((Object)"sling:Folder", (Object)child.getPrimaryNodeType().getName());
            child = folder.addNode("child1", "sling:Folder");
            folder.getSession().save();
            Assert.assertEquals((Object)"sling:Folder", (Object)child.getPrimaryNodeType().getName());
            child = folder.addNode("child2", "nt:folder");
            folder.getSession().save();
            Assert.assertEquals((Object)"nt:folder", (Object)child.getPrimaryNodeType().getName());
            child = folder.addNode("child3", "nt:unstructured");
            folder.getSession().save();
            Assert.assertEquals((Object)"nt:unstructured", (Object)child.getPrimaryNodeType().getName());
        }
        finally {
            folder.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMap() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            path = "/child";
            mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapURLEscaping() throws Exception {
        String mapHostInternal = "internal.host.com";
        String mapRootInternal = "/content/internal";
        Node internalRedirect = this.mapRoot.getNode("map/http").addNode("internal.host.com.80", "sling:Mapping");
        internalRedirect.setProperty(PROP_REDIRECT_INTERNAL, "/content/internal");
        try {
            this.saveMappings(session);
            String path = "/sample with spaces";
            String escapedPath = "/sample%20with%20spaces";
            String mapped = resResolver.map("/content/internal/sample with spaces");
            Assert.assertEquals((Object)"http://internal.host.com/sample%20with%20spaces", (Object)mapped);
            mapped = resResolver.map((HttpServletRequest)new FakeSlingHttpServletRequest(this.rootPath), "/content/internal/sample with spaces");
            Assert.assertEquals((Object)"http://internal.host.com/sample%20with%20spaces", (Object)mapped);
            mapped = resResolver.map((HttpServletRequest)new FakeSlingHttpServletRequest(null, "internal.host.com", -1, this.rootPath), "/content/internal/sample with spaces");
            Assert.assertEquals((Object)"/sample%20with%20spaces", (Object)mapped);
            String unmappedRoot = "/unmappedRoot";
            mapped = resResolver.map("/unmappedRoot/sample with spaces");
            Assert.assertEquals((Object)"/unmappedRoot/sample%20with%20spaces", (Object)mapped);
            mapped = resResolver.map((HttpServletRequest)new FakeSlingHttpServletRequest(this.rootPath), "/unmappedRoot/sample with spaces");
            Assert.assertEquals((Object)"/unmappedRoot/sample%20with%20spaces", (Object)mapped);
        }
        finally {
            internalRedirect.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapNamespaceMangling() throws Exception {
        String mapHost = "virtual.host.com";
        String mapRootPath = "/content/virtual";
        String contextPath = "/context";
        Node virtualhost80 = this.mapRoot.getNode("map/http").addNode("virtual.host.com.80", "sling:Mapping");
        virtualhost80.setProperty(PROP_REDIRECT_INTERNAL, "/content/virtual");
        try {
            this.saveMappings(session);
            FakeSlingHttpServletRequest virtualRequest = new FakeSlingHttpServletRequest(null, "virtual.host.com", -1, this.rootPath);
            String pathv0 = "/sample";
            String mappedv0 = resResolver.map((HttpServletRequest)virtualRequest, "/content/virtual/sample");
            Assert.assertEquals((String)"Expect unmangled path", (Object)"/sample", (Object)mappedv0);
            String pathv1 = "/sample/jcr:content";
            String mangledv1 = "/sample/_jcr_content";
            String mappedv1 = resResolver.map((HttpServletRequest)virtualRequest, "/content/virtual/sample/jcr:content");
            Assert.assertEquals((String)"Expect mangled path", (Object)"/sample/_jcr_content", (Object)mappedv1);
            virtualRequest.setContextPath("/context");
            String pathvc0 = "/sample";
            String mappedvc0 = resResolver.map((HttpServletRequest)virtualRequest, "/content/virtual/sample");
            Assert.assertEquals((String)"Expect unmangled path", (Object)"/context/sample", (Object)mappedvc0);
            String pathvc1 = "/sample/jcr:content";
            String mangledvc1 = "/sample/_jcr_content";
            String mappedvc1 = resResolver.map((HttpServletRequest)virtualRequest, "/content/virtual/sample/jcr:content");
            Assert.assertEquals((String)"Expect mangled path", (Object)"/context/sample/_jcr_content", (Object)mappedvc1);
            FakeSlingHttpServletRequest foreignRequest = new FakeSlingHttpServletRequest(null, "foreign.host.com", -1, this.rootPath);
            String pathf0 = "/sample";
            String mappedf0 = resResolver.map((HttpServletRequest)foreignRequest, "/content/virtual/sample");
            Assert.assertEquals((String)"Expect unmangled absolute URI", (Object)"http://virtual.host.com/sample", (Object)mappedf0);
            String pathf1 = "/sample/jcr:content";
            String mangledf1 = "/sample/_jcr_content";
            String mappedf1 = resResolver.map((HttpServletRequest)foreignRequest, "/content/virtual/sample/jcr:content");
            Assert.assertEquals((String)"Expect mangled absolute URI", (Object)"http://virtual.host.com/sample/_jcr_content", (Object)mappedf1);
            foreignRequest.setContextPath("/context");
            String pathfc0 = "/sample";
            String mappedfc0 = resResolver.map((HttpServletRequest)foreignRequest, "/content/virtual/sample");
            Assert.assertEquals((String)"Expect unmangled absolute URI", (Object)"http://virtual.host.com/context/sample", (Object)mappedfc0);
            String pathfc1 = "/sample/jcr:content";
            String mangledfc1 = "/sample/_jcr_content";
            String mappedfc1 = resResolver.map((HttpServletRequest)foreignRequest, "/content/virtual/sample/jcr:content");
            Assert.assertEquals((String)"Expect mangled absolute URI", (Object)"http://virtual.host.com/context/sample/_jcr_content", (Object)mappedfc1);
        }
        finally {
            virtualhost80.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapContext() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            path = "/child";
            mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapExtension() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = ".html";
            path = "/child.html";
            mapped = resResolver.map(child.getPath() + ".html");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapSelectorsExtension() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = ".sel1.sel2.html";
            path = "/child.sel1.sel2.html";
            mapped = resResolver.map(child.getPath() + ".sel1.sel2.html");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapExtensionSuffix() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = ".html/some/suffx.pdf";
            path = "/child.html/some/suffx.pdf";
            mapped = resResolver.map(child.getPath() + ".html/some/suffx.pdf");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapFragment() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = "#sec:1";
            path = "/child#sec:1";
            mapped = resResolver.map(child.getPath() + "#sec:1");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapQuery() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = "?a:b=2";
            path = "/child?a:b=2";
            mapped = resResolver.map(child.getPath() + "?a:b=2");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapFragmentQuery() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = "#sec:1?a:b=1";
            path = "/child#sec:1?a:b=1";
            mapped = resResolver.map(child.getPath() + "#sec:1?a:b=1");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    @Test
    public void testMapEmptyPath() throws Exception {
        String mapped = resResolver.map("");
        Assert.assertEquals((Object)"/", (Object)mapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapExtensionFragmentQuery() throws Exception {
        String path = this.rootNode.getPath();
        String mapped = resResolver.map(path);
        Assert.assertEquals((Object)path, (Object)mapped);
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String selExt = ".html#sec:1?a:b=1";
            path = "/child.html#sec:1?a:b=1";
            mapped = resResolver.map(child.getPath() + ".html#sec:1?a:b=1");
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapResourceAlias() throws Exception {
        String alias = "testAlias";
        this.rootNode.setProperty("sling:alias", alias);
        this.saveMappings(session);
        try {
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias));
            String mapped = resResolver.map(this.rootNode.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
            Node child = this.rootNode.addNode("child");
            session.save();
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + "/child"));
            mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            this.rootNode.getProperty("sling:alias").remove();
            if (this.rootNode.hasNode("child")) {
                this.rootNode.getNode("child").remove();
            }
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapResourceAliasJcrContent() throws Exception {
        String alias = "testAlias";
        Node content = this.rootNode.addNode("jcr:content", "nt:unstructured");
        content.setProperty("sling:alias", alias);
        this.saveMappings(session);
        try {
            String path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias));
            String mapped = resResolver.map(this.rootNode.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + "/_jcr_content"));
            mapped = resResolver.map(content.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
            Node child = content.addNode("child");
            session.save();
            path = ResourceUtil.normalize((String)(ResourceUtil.getParent((String)this.rootPath) + "/" + alias + "/_jcr_content/child"));
            mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
        }
        finally {
            content.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve() throws Exception {
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String path = "/child";
            String mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/child"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            Node grandchild = child.addNode("grandchild");
            session.save();
            String pathEnkel = "/child/grandchild";
            String mappedEnkel = resResolver.map(grandchild.getPath());
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/child/grandchild"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_extension() throws Exception {
        String selExt = ".html";
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String path = "/child.html";
            String mapped = resResolver.map(child.getPath() + ".html");
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/child"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            Node grandchild = child.addNode("grandchild");
            session.save();
            String pathEnkel = "/child/grandchild.html";
            String mappedEnkel = resResolver.map(grandchild.getPath() + ".html");
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/child/grandchild"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".html", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_selectors_extension() throws Exception {
        String selExt = ".sel1.sel2.html";
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String path = "/child.sel1.sel2.html";
            String mapped = resResolver.map(child.getPath() + ".sel1.sel2.html");
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/child"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".sel1.sel2.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            Node grandchild = child.addNode("grandchild");
            session.save();
            String pathEnkel = "/child/grandchild.sel1.sel2.html";
            String mappedEnkel = resResolver.map(grandchild.getPath() + ".sel1.sel2.html");
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/child/grandchild"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".sel1.sel2.html", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_extension_suffix() throws Exception {
        String selExt = ".html/some/suffx.pdf";
        Node child = this.rootNode.addNode("child");
        session.save();
        try {
            String path = "/child.html/some/suffx.pdf";
            String mapped = resResolver.map(child.getPath() + ".html/some/suffx.pdf");
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_with_sling_alias() throws Exception {
        Node child = this.rootNode.addNode("child");
        child.setProperty("sling:alias", "kind");
        this.saveMappings(session);
        try {
            String path = "/kind";
            String mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            Node grandchild = child.addNode("grandchild");
            grandchild.setProperty("sling:alias", "enkel");
            this.saveMappings(session);
            String pathEnkel = "/kind/enkel";
            String mappedEnkel = resResolver.map(grandchild.getPath());
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind/enkel"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_with_sling_alias_multi_value() throws Exception {
        Node child = this.rootNode.addNode("child");
        child.setProperty("sling:alias", new String[]{"kind", "enfant"});
        try {
            this.saveMappings(session);
            String path = "/kind";
            String mapped = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            String pathEnfant = "/enfant";
            String mappedEnfant = resResolver.map(child.getPath());
            Assert.assertEquals((Object)path, (Object)mappedEnfant);
            Resource resEnfant = resResolver.resolve(null, pathEnfant);
            Assert.assertNotNull((Object)resEnfant);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/enfant"), (Object)resEnfant.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)resEnfant.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnfant = (Node)resEnfant.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnfant);
            Assert.assertEquals((Object)child.getPath(), (Object)resNodeEnfant.getPath());
            Node grandchild = child.addNode("grandchild");
            grandchild.setProperty("sling:alias", "enkel");
            this.saveMappings(session);
            String pathEnkel = "/kind/enkel";
            String mappedEnkel = resResolver.map(grandchild.getPath());
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind/enkel"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
            String pathEnfantEnkel = "/enfant/enkel";
            String mappedEnfantEnkel = resResolver.map(grandchild.getPath());
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnfantEnkel);
            Resource resEnfantEnkel = resResolver.resolve(null, pathEnfantEnkel);
            Assert.assertNotNull((Object)resEnfantEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/enfant/enkel"), (Object)resEnfantEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)"", (Object)resEnfantEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnfantEnkel = (Node)resEnfantEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnfantEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnfantEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_with_sling_alias_extension() throws Exception {
        String selExt = ".html";
        Node child = this.rootNode.addNode("child");
        child.setProperty("sling:alias", "kind");
        try {
            this.saveMappings(session);
            String path = "/kind.html";
            String mapped = resResolver.map(child.getPath() + ".html");
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            Node grandchild = child.addNode("grandchild");
            grandchild.setProperty("sling:alias", "enkel");
            this.saveMappings(session);
            String pathEnkel = "/kind/enkel.html";
            String mappedEnkel = resResolver.map(grandchild.getPath() + ".html");
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind/enkel"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".html", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_with_sling_alias_selectors_extension() throws Exception {
        String selExt = ".sel1.sel2.html";
        Node child = this.rootNode.addNode("child");
        child.setProperty("sling:alias", "kind");
        try {
            this.saveMappings(session);
            String path = "/kind.sel1.sel2.html";
            String mapped = resResolver.map(child.getPath() + ".sel1.sel2.html");
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind"), (Object)res.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".sel1.sel2.html", (Object)res.getResourceMetadata().getResolutionPathInfo());
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
            Node grandchild = child.addNode("grandchild");
            grandchild.setProperty("sling:alias", "enkel");
            this.saveMappings(session);
            String pathEnkel = "/kind/enkel.sel1.sel2.html";
            String mappedEnkel = resResolver.map(grandchild.getPath() + ".sel1.sel2.html");
            Assert.assertEquals((Object)pathEnkel, (Object)mappedEnkel);
            Resource resEnkel = resResolver.resolve(null, pathEnkel);
            Assert.assertNotNull((Object)resEnkel);
            Assert.assertEquals((Object)(this.rootNode.getPath() + "/kind/enkel"), (Object)resEnkel.getResourceMetadata().getResolutionPath());
            Assert.assertEquals((Object)".sel1.sel2.html", (Object)resEnkel.getResourceMetadata().getResolutionPathInfo());
            Node resNodeEnkel = (Node)resEnkel.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNodeEnkel);
            Assert.assertEquals((Object)grandchild.getPath(), (Object)resNodeEnkel.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_resolve_with_sling_alias_extension_suffix() throws Exception {
        String selExt = ".html/some/suffx.pdf";
        Node child = this.rootNode.addNode("child");
        child.setProperty("sling:alias", "kind");
        try {
            this.saveMappings(session);
            String path = "/kind.html/some/suffx.pdf";
            String mapped = resResolver.map(child.getPath() + ".html/some/suffx.pdf");
            Assert.assertEquals((Object)path, (Object)mapped);
            Resource res = resResolver.resolve(null, path);
            Node resNode = (Node)res.adaptTo(Node.class);
            Assert.assertNotNull((Object)resNode);
            Assert.assertEquals((Object)child.getPath(), (Object)resNode.getPath());
        }
        finally {
            child.remove();
            session.save();
        }
    }

    private void testStarResourceHelper(String path, String method) {
        Resource res = resResolver.resolve((HttpServletRequest)new FakeSlingHttpServletRequest(path, method), path);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((boolean)ResourceUtil.isStarResource((Resource)res));
        Assert.assertEquals((Object)"sling:syntheticStarResource", (Object)res.getResourceType());
    }

    static {
        toDelete = new ArrayList<String>();
    }
}

