/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.serversidetests;

import javax.jcr.Session;
import org.apache.sling.launchpad.testservices.events.EventsCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingsFacade {
    public static final String MAPPING_EVENT_TOPIC = "org/apache/sling/api/resource/ResourceResolverMapping/CHANGED";
    private static final Logger logger = LoggerFactory.getLogger(MappingsFacade.class);
    private final EventsCounter eventsCounter;
    private static boolean firstInstance = true;
    public static final String MAPPING_UPDATE_TIMEOUT_MSEC = "ResourceResolverTest.mapping.update.timeout.msec";
    private static final long updateTimeout = Long.valueOf(System.getProperty("ResourceResolverTest.mapping.update.timeout.msec", "10000"));

    public MappingsFacade(EventsCounter c) {
        if (firstInstance) {
            logger.info("updateTimeout = {}, use {} system property to change", (Object)updateTimeout, (Object)MAPPING_UPDATE_TIMEOUT_MSEC);
            firstInstance = false;
        }
        this.eventsCounter = c;
    }

    public String saveMappings(Session session) throws Exception {
        int oldEventsCount = this.eventsCounter.getEventsCount(MAPPING_EVENT_TOPIC);
        logger.debug("Saving Session and waiting for event counter {} to change from current value {}", (Object)MAPPING_EVENT_TOPIC, (Object)oldEventsCount);
        session.save();
        long timeout = System.currentTimeMillis() + updateTimeout;
        while (System.currentTimeMillis() < timeout) {
            int newCount = this.eventsCounter.getEventsCount(MAPPING_EVENT_TOPIC);
            if (newCount != oldEventsCount) {
                logger.debug("Event counter {} is now {}", (Object)MAPPING_EVENT_TOPIC, (Object)newCount);
                Thread.sleep(updateTimeout / 50L);
                return null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return "Timeout waiting for org/apache/sling/api/resource/ResourceResolverMapping/CHANGED event, after " + updateTimeout + " msec";
    }
}

