/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.teleporter.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.sling.testing.teleporter.client.ExponentialBackoffDelay;
import org.apache.sling.testing.teleporter.client.MultipartAdapter;
import org.junit.Assert;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runners.model.MultipleFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TeleporterHttpClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String CHARSET = "UTF-8";
    private final String baseUrl;
    private String credentials = null;
    private final String testServletPath;
    private final int httpTimeoutSeconds;

    TeleporterHttpClient(String baseUrl, String testServletPath) {
        this(baseUrl, testServletPath, 20);
    }

    TeleporterHttpClient(String baseUrl, String testServletPath, int httpTimeoutSeconds) {
        this.baseUrl = baseUrl;
        this.httpTimeoutSeconds = httpTimeoutSeconds;
        if (!testServletPath.endsWith("/")) {
            testServletPath = testServletPath + "/";
        }
        this.testServletPath = testServletPath;
    }

    void setCredentials(String cred) {
        this.credentials = cred;
    }

    int getHttpTimeoutSeconds() {
        return this.httpTimeoutSeconds;
    }

    public void setConnectionCredentials(URLConnection c) {
        if (this.credentials != null && !this.credentials.isEmpty()) {
            String basicAuth = "Basic " + Base64.getEncoder().encodeToString(this.credentials.getBytes());
            c.setRequestProperty("Authorization", basicAuth);
            this.log.debug("Credentials set");
        }
    }

    public String waitForStatus(String url, int expectedStatus, int timeoutMsec) throws IOException {
        this.log.debug("Waiting for status {} at {}, timeout {} msec", new Object[]{expectedStatus, url, timeoutMsec});
        long end = System.currentTimeMillis() + (long)timeoutMsec;
        HashSet<Integer> statusSet = new HashSet<Integer>();
        ExponentialBackoffDelay d = new ExponentialBackoffDelay(50, 250);
        while (System.currentTimeMillis() < end) {
            try {
                SimpleHttpResponse response = this.getHttpGetStatus(url);
                statusSet.add(response.getStatus());
                if (response.getStatus() == expectedStatus) {
                    return response.getBody();
                }
                d.waitNextDelay();
            }
            catch (Exception exception) {}
        }
        throw new IOException("Did not get status " + expectedStatus + " at " + url + " after " + timeoutMsec + " msec, got " + statusSet);
    }

    HttpURLConnection setHttpTimeouts(HttpURLConnection c) {
        int timeoutMsec = this.httpTimeoutSeconds * 1000;
        c.setConnectTimeout(timeoutMsec);
        c.setReadTimeout(timeoutMsec);
        this.log.debug("HTTP connect + read timeouts set to {} msec", (Object)timeoutMsec);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installBundle(InputStream bundle, String bundleSymbolicName, int webConsoleReadyTimeoutSeconds) throws MalformedURLException, IOException {
        String url = this.baseUrl + "/system/console/bundles";
        String contentType = "application/octet-stream";
        HttpURLConnection c = this.setHttpTimeouts((HttpURLConnection)new URL(url).openConnection());
        this.waitForStatus(url, 200, webConsoleReadyTimeoutSeconds * 1000);
        try {
            this.setConnectionCredentials(c);
            new MultipartAdapter(c, "UTF-8").parameter("action", "install").parameter("bundlestart", "1").file("bundlefile", bundleSymbolicName + ".jar", "application/octet-stream", bundle).close();
            int status = c.getResponseCode();
            if (status != 302) {
                throw new IOException("Got status code " + status + " for " + url);
            }
            this.log.debug("POST request to install bundle {} successful", (Object)bundleSymbolicName);
        }
        finally {
            this.cleanup(c);
        }
    }

    void verifyCorrectBundleState(String bundleSymbolicName, int timeoutInSeconds) throws IOException {
        this.log.debug("Verifying bundle {} state, timeout {} seconds", (Object)bundleSymbolicName, (Object)timeoutInSeconds);
        String url = this.baseUrl + "/system/console/bundles/" + bundleSymbolicName + ".json";
        long end = System.currentTimeMillis() + (long)(timeoutInSeconds * 1000);
        ExponentialBackoffDelay d = new ExponentialBackoffDelay(50, 250);
        while (System.currentTimeMillis() < end) {
            String jsonBody = this.waitForStatus(url, 200, timeoutInSeconds * 1000);
            try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonBody));){
                JsonArray jsonArray = jsonReader.readObject().getJsonArray("data");
                if (jsonArray == null) {
                    throw new JsonException("Could not find 'data' array");
                }
                JsonObject bundleObject = jsonArray.getJsonObject(0);
                String state = bundleObject.getString("state");
                if ("Active".equals(state)) {
                    this.log.debug("Bundle {} is active", (Object)bundleSymbolicName);
                    return;
                }
                JsonArray propsArray = bundleObject.getJsonArray("props");
                if (propsArray == null) {
                    throw new JsonException("Could not find 'props' object");
                }
                for (JsonValue propValue : propsArray) {
                    JsonObject propObject;
                    if (!propValue.getValueType().equals((Object)JsonValue.ValueType.OBJECT) || !"Imported Packages".equals((propObject = (JsonObject)propValue).getString("key"))) continue;
                    JsonArray importedPackagesArray = propObject.getJsonArray("value");
                    String reason = null;
                    for (JsonValue importedPackageValue : importedPackagesArray) {
                        String importedPackage;
                        if (!importedPackageValue.getValueType().equals((Object)JsonValue.ValueType.STRING) || !(importedPackage = ((JsonString)importedPackageValue).getString()).startsWith("ERROR:")) continue;
                        reason = importedPackage;
                    }
                    if (reason == null) continue;
                    throw new IllegalStateException("The test bundle '" + bundleSymbolicName + "' is in state '" + state + "'. This is due to unresolved import-packages: " + reason);
                }
            }
            catch (IndexOutOfBoundsException | JsonException e) {
                throw new IllegalArgumentException("Test bundle '" + bundleSymbolicName + "' not correctly installed. Could not parse JSON response though to expose further information: " + jsonBody, e);
            }
            d.waitNextDelay();
        }
        throw new IOException("Bundle '" + bundleSymbolicName + "' was not started after " + timeoutInSeconds + " seconds. The check at " + url + " was not successfull. Probably some dependent bundle was not started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninstallBundle(String bundleSymbolicName, int webConsoleReadyTimeoutSeconds) throws MalformedURLException, IOException {
        this.log.debug("Uninstalling bundle {}", (Object)bundleSymbolicName);
        String url = this.baseUrl + "/system/console/bundles/" + bundleSymbolicName;
        HttpURLConnection c = this.setHttpTimeouts((HttpURLConnection)new URL(url).openConnection());
        this.waitForStatus(url, 200, webConsoleReadyTimeoutSeconds * 1000);
        try {
            this.setConnectionCredentials(c);
            new MultipartAdapter(c, "UTF-8").parameter("action", "uninstall").close();
            int status = c.getResponseCode();
            if (status != 200) {
                throw new IOException("Got status code " + status + " for " + url);
            }
            this.log.debug("POST request to uninstall bundle {} successful", (Object)bundleSymbolicName);
        }
        finally {
            this.cleanup(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHttpResponse getHttpGetStatus(String url) throws MalformedURLException, IOException {
        this.log.debug("getHttpGetStatus: {}", (Object)url);
        HttpURLConnection c = this.setHttpTimeouts((HttpURLConnection)new URL(url).openConnection());
        this.setConnectionCredentials(c);
        c.setUseCaches(false);
        c.setDoOutput(true);
        c.setDoInput(true);
        c.setInstanceFollowRedirects(false);
        boolean gotStatus = false;
        int status = 0;
        try {
            status = c.getResponseCode();
            gotStatus = true;
            boolean isError = status >= 400;
            InputStream is = isError ? c.getErrorStream() : c.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)writer, (Charset)StandardCharsets.UTF_8);
            this.log.debug("Got response {} for {}", (Object)status, (Object)url);
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(status, writer.toString());
            return simpleHttpResponse;
        }
        finally {
            this.cleanup(c, gotStatus);
        }
    }

    void runTests(String testSelectionPath, int testReadyTimeoutSeconds) throws MalformedURLException, IOException, MultipleFailureException {
        String testUrl = this.baseUrl + "/" + this.testServletPath + testSelectionPath + ".junit_result";
        this.log.debug("Running tests: {}", (Object)testUrl);
        long timeout = System.currentTimeMillis() + (long)testReadyTimeoutSeconds * 1000L;
        ExponentialBackoffDelay delay = new ExponentialBackoffDelay(25, 1000);
        while (this.getHttpGetStatus(testUrl).getStatus() != 200) {
            if (System.currentTimeMillis() > timeout) {
                Assert.fail((String)("Timeout waiting for test at " + testUrl + " (" + testReadyTimeoutSeconds + " seconds)"));
                break;
            }
            delay.waitNextDelay();
        }
        HttpURLConnection c = this.setHttpTimeouts((HttpURLConnection)new URL(testUrl).openConnection());
        try {
            this.setConnectionCredentials(c);
            c.setRequestMethod("POST");
            c.setUseCaches(false);
            c.setDoOutput(true);
            c.setDoInput(true);
            c.setInstanceFollowRedirects(false);
            int status = c.getResponseCode();
            if (status != 200) {
                throw new IOException("Got status code " + status + " for " + testUrl);
            }
            Result result = (Result)new ObjectInputStream(c.getInputStream()).readObject();
            if (result.getFailureCount() > 0) {
                ArrayList<Throwable> failures = new ArrayList<Throwable>(result.getFailureCount());
                for (Failure f : result.getFailures()) {
                    failures.add(f.getException());
                }
                throw new MultipleFailureException(failures);
            }
            this.log.debug("POST request to run tests successful at {}", (Object)testUrl);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Exception reading test results:" + e, e);
        }
        finally {
            this.cleanup(c);
        }
    }

    private void consumeAndClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        byte[] buffer = new byte[16384];
        while (is.read(buffer) != -1) {
        }
        is.close();
    }

    private void cleanup(HttpURLConnection c) {
        this.cleanup(c, true);
    }

    private void cleanup(HttpURLConnection c, boolean includeInputStreams) {
        if (includeInputStreams) {
            try {
                this.consumeAndClose(c.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.consumeAndClose(c.getErrorStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        c.disconnect();
    }

    static final class SimpleHttpResponse {
        private final int status;
        private final String body;

        public SimpleHttpResponse(int status, String body) {
            this.status = status;
            this.body = body;
        }

        public int getStatus() {
            return this.status;
        }

        public String getBody() {
            return this.body;
        }
    }
}

