/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.teleporter.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassResourceVisitor {
    private final Class<?> clazz;
    private final String path;

    public ClassResourceVisitor(Class<?> clazz, String path) {
        this.clazz = clazz;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Processor p) throws IOException {
        URL resourceURL = this.clazz.getResource(this.path);
        if (resourceURL == null) {
            return;
        }
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String basePath = new File(this.clazz.getResource("/").getPath()).getAbsolutePath();
            this.processFile(basePath, new File(resourceURL.getPath()), p);
        } else if ("jar".equals(protocol)) {
            String rPath = this.path.startsWith("/") ? this.path.substring(1) : this.path;
            String jarFilePath = resourceURL.getPath().split("!")[0].substring("file:".length());
            try (JarFile jar = new JarFile(jarFilePath);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory() || !this.jarEntryMatches(rPath, e.getName())) continue;
                    try (InputStream is = jar.getInputStream(e);){
                        p.process("/" + e.getName(), is);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Unkown protocol " + protocol);
        }
    }

    private boolean jarEntryMatches(String givenPath, String entryPath) {
        if (givenPath.endsWith("/")) {
            return entryPath.startsWith(givenPath);
        }
        return entryPath.equals(givenPath);
    }

    static String sanitizeResourceName(String basePath, File resource) {
        return resource.getAbsolutePath().substring(basePath.length()).replace("\\", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(String basePath, File f, Processor p) throws IOException {
        block5: {
            block4: {
                if (!f.isDirectory()) break block4;
                String[] names = f.list();
                if (names == null) break block5;
                for (String name : names) {
                    this.processFile(basePath, new File(f, name), p);
                }
                break block5;
            }
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
                p.process(ClassResourceVisitor.sanitizeResourceName(basePath, f), is);
            }
        }
    }

    static interface Processor {
        public void process(String var1, InputStream var2) throws IOException;
    }
}

