/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.teleporter.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.testing.teleporter.client.ClassResourceVisitor;
import org.apache.sling.testing.teleporter.client.DependencyAnalyzer;
import org.apache.sling.testing.teleporter.client.TeleporterHttpClient;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class ClientSideTeleporter
extends TeleporterRule {
    public static final String DEFAULT_TEST_SERVLET_PATH = "system/sling/junit";
    private DependencyAnalyzer dependencyAnalyzer;
    private int testReadyTimeoutSeconds = 20;
    private int webConsoleReadyTimeoutSeconds = 30;
    private int waitForServiceTimout = 10;
    private boolean enableLogging = false;
    private boolean preventToUninstallBundle = false;
    private File directoryForPersistingTestBundles = null;
    private String baseUrl;
    private String serverCredentials;
    private String testServletPath = "system/sling/junit";
    private final Set<Class<?>> embeddedClasses = new HashSet();
    private final Map<String, String> additionalBundleHeaders = new HashMap<String, String>();
    private Logger log;

    public ClientSideTeleporter() {
        this.initLogger();
    }

    private InputStream buildTestBundle(Class<?> c, Collection<Class<?>> embeddedClasses, String bundleSymbolicName) throws IOException {
        final TinyBundle b = TinyBundles.bundle().set("Bundle-SymbolicName", bundleSymbolicName).set("Sling-Test-Regexp", c.getName() + ".*").set("Sling-Test-WaitForService-Timeout", Integer.toString(this.waitForServiceTimout)).add(c);
        for (Map.Entry<String, String> entry : this.additionalBundleHeaders.entrySet()) {
            this.log.info("Add bundle header '{}' with value '{}'", (Object)entry.getKey(), (Object)entry.getValue());
            b.set(entry.getKey(), entry.getValue());
        }
        for (Class clazz : this.dependencyAnalyzer.getDependencies(this.log)) {
            this.log.debug("Embed dependent class '{}' because it is referenced and in the allowed package prefixes", (Object)clazz);
            b.add(clazz);
        }
        for (Class clazz : embeddedClasses) {
            this.log.info("Embed class '{}'", (Object)clazz);
            b.add(clazz);
        }
        if (!this.embeddedResourcePaths.isEmpty()) {
            for (String string : this.embeddedResourcePaths) {
                ClassResourceVisitor.Processor p = new ClassResourceVisitor.Processor(){

                    @Override
                    public void process(String resourcePath, InputStream resourceStream) throws IOException {
                        b.add(resourcePath, resourceStream);
                        ClientSideTeleporter.this.log.info("Embed resource '{}'", (Object)resourcePath);
                    }
                };
                new ClassResourceVisitor(((Object)((Object)this)).getClass(), string).visit(p);
            }
        }
        return b.build(TinyBundles.withBnd());
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
    }

    protected void setClassUnderTest(Class<?> c) {
        super.setClassUnderTest(c);
        this.dependencyAnalyzer = DependencyAnalyzer.forClass(this.classUnderTest);
    }

    public void setTestReadyTimeoutSeconds(int tm) {
        this.testReadyTimeoutSeconds = tm;
    }

    public void setWebConsoleReadyTimeoutSeconds(int tm) {
        this.webConsoleReadyTimeoutSeconds = tm;
    }

    public void setWaitForServiceTimoutSeconds(int tm) {
        this.waitForServiceTimout = tm;
    }

    public void setServerCredentials(String username, String password) {
        this.serverCredentials = username + ":" + password;
    }

    public void setTestServletPath(String testServletPath) {
        this.testServletPath = testServletPath == null ? DEFAULT_TEST_SERVLET_PATH : testServletPath;
    }

    public ClientSideTeleporter includeDependencyPrefix(String prefix) {
        this.dependencyAnalyzer.include(prefix);
        return this;
    }

    public ClientSideTeleporter excludeDependencyPrefix(String prefix) {
        this.dependencyAnalyzer.exclude(prefix);
        return this;
    }

    public ClientSideTeleporter embedClass(Class<?> c) {
        this.embeddedClasses.add(c);
        return this;
    }

    public void addAdditionalBundleHeader(String name, String value) {
        this.additionalBundleHeaders.put(name, value);
    }

    public Map<String, String> getAdditionalBundleHeaders() {
        return this.additionalBundleHeaders;
    }

    public void setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
        this.initLogger();
    }

    public void setPreventToUninstallBundle(boolean preventToUninstallTestBundle) {
        this.preventToUninstallBundle = preventToUninstallTestBundle;
    }

    public void setDirectoryForPersistingTestBundles(File directoryForPersistingTestBundles) {
        this.directoryForPersistingTestBundles = directoryForPersistingTestBundles;
    }

    public void embedClassesDirectory(File classesDirectory) throws IOException, ClassNotFoundException {
        final Path start = classesDirectory.toPath();
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith(".class")) {
                    String className = start.relativize(file).toString().replace(file.getFileSystem().getSeparator(), ".");
                    className = className.substring(0, className.length() - 6);
                    try {
                        Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                        ClientSideTeleporter.this.embedClass(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Could not load class with name '" + className + "'", e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private String installTestBundle(TeleporterHttpClient httpClient) throws MalformedURLException, IOException {
        String bundleSymbolicName = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.classUnderTest.getSimpleName();
        this.log.info("Building bundle '{}'", (Object)bundleSymbolicName, (Object)this.baseUrl);
        try (InputStream bundle = this.buildTestBundle(this.classUnderTest, this.embeddedClasses, bundleSymbolicName);){
            if (this.directoryForPersistingTestBundles != null) {
                this.directoryForPersistingTestBundles.mkdirs();
                File bundleFile = new File(this.directoryForPersistingTestBundles, bundleSymbolicName + ".jar");
                this.log.info("Persisting test bundle in '{}'", (Object)bundleFile);
                try (FileOutputStream output = new FileOutputStream(bundleFile);){
                    IOUtils.copy((InputStream)bundle, (OutputStream)output);
                }
                var7_9 = null;
                try (BufferedInputStream bundleInput = new BufferedInputStream(new FileInputStream(bundleFile));){
                    this.log.info("Installing bundle '{}' to {}", (Object)bundleSymbolicName, (Object)this.baseUrl);
                    httpClient.installBundle(bundleInput, bundleSymbolicName, this.webConsoleReadyTimeoutSeconds);
                }
                catch (Throwable throwable) {
                    var7_9 = throwable;
                    throw throwable;
                }
            }
            this.log.info("Installing bundle '{}' to {}", (Object)bundleSymbolicName, (Object)this.baseUrl);
            httpClient.installBundle(bundle, bundleSymbolicName, this.webConsoleReadyTimeoutSeconds);
            httpClient.verifyCorrectBundleState(bundleSymbolicName, this.webConsoleReadyTimeoutSeconds);
        }
        return bundleSymbolicName;
    }

    private void initLogger() {
        this.log = this.enableLogging ? LoggerFactory.getLogger(ClientSideTeleporter.class) : NOPLogger.NOP_LOGGER;
    }

    public Statement apply(Statement base, final Description description) {
        this.customize();
        this.initLogger();
        if (this.baseUrl == null) {
            Assert.fail((String)"base URL is not set");
        }
        if (this.serverCredentials == null || this.serverCredentials.isEmpty()) {
            Assert.fail((String)"server credentials are not set");
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        final TeleporterHttpClient httpClient = new TeleporterHttpClient(this.baseUrl, this.testServletPath);
        httpClient.setCredentials(this.serverCredentials);
        return new Statement(){

            public void evaluate() throws Throwable {
                String bundleSymbolicName = ClientSideTeleporter.this.installTestBundle(httpClient);
                String testPath = description.getClassName() + "/" + description.getMethodName();
                try {
                    httpClient.runTests(testPath, ClientSideTeleporter.this.testReadyTimeoutSeconds);
                }
                finally {
                    if (!ClientSideTeleporter.this.preventToUninstallBundle) {
                        ClientSideTeleporter.this.log.info("Uninstalling bundle '{}' from {}", (Object)bundleSymbolicName, (Object)ClientSideTeleporter.this.baseUrl);
                        httpClient.uninstallBundle(bundleSymbolicName, ClientSideTeleporter.this.webConsoleReadyTimeoutSeconds);
                    } else {
                        ClientSideTeleporter.this.log.info("Not uninstalling bundle '{}' from {} due to according configuration", (Object)bundleSymbolicName, (Object)ClientSideTeleporter.this.baseUrl);
                    }
                }
            }
        };
    }
}

