/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.testrunner;

import java.io.IOException;
import javax.json.JsonException;
import javax.json.JsonObject;
import org.apache.sling.junit.remote.testrunner.RemoteExecutionException;
import org.junit.runner.Description;

class SlingRemoteTest {
    private final Class<?> testClass;
    private final String description;
    private final String failure;
    private final String trace;
    public static final String DESCRIPTION = "description";
    public static final String FAILURE = "failure";
    public static final String TRACE = "trace";

    SlingRemoteTest(Class<?> testClass, JsonObject json) throws JsonException {
        this.testClass = testClass;
        this.description = json.containsKey((Object)DESCRIPTION) ? json.getString(DESCRIPTION) : null;
        String string = this.failure = json.containsKey((Object)FAILURE) ? json.getString(FAILURE) : null;
        this.trace = this.failure != null ? (json.containsKey((Object)TRACE) ? json.getString(TRACE) : null) : null;
    }

    Description describe() {
        return Description.createTestDescription(this.testClass, (String)this.description);
    }

    void run() {
        if (this.failure != null && this.failure.trim().length() > 0) {
            try {
                throw new RemoteExecutionException(this.failure, this.trace);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

