/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.apache.sling.junit.impl.servlet.junit5.DescriptionGenerator;
import org.apache.sling.junit.impl.servlet.junit5.FailureHelper;
import org.apache.sling.junit.impl.servlet.junit5.ResultAdapter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class RunListenerAdapter
implements TestExecutionListener {
    private final RunListener runListener;
    private final SummaryGeneratingListener summarizer;

    public RunListenerAdapter(RunListener runListener) {
        this.runListener = runListener;
        this.summarizer = new SummaryGeneratingListener();
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.summarizer.testPlanExecutionStarted(testPlan);
        try {
            this.runListener.testRunStarted(Description.createSuiteDescription("classes", new Annotation[0]));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.summarizer.testPlanExecutionFinished(testPlan);
        TestExecutionSummary summary = this.summarizer.getSummary();
        ResultAdapter result = new ResultAdapter(summary);
        try {
            this.runListener.testRunFinished(result);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.summarizer.executionStarted(testIdentifier);
        if (testIdentifier.isTest()) {
            RunListenerAdapter.withDescription(testIdentifier, this.runListener::testStarted);
        } else {
            RunListenerAdapter.withDescription(testIdentifier, this.runListener::testSuiteStarted);
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.summarizer.executionSkipped(testIdentifier, reason);
        if (testIdentifier.isTest()) {
            RunListenerAdapter.withDescription(testIdentifier, this.runListener::testIgnored);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.summarizer.executionFinished(testIdentifier, testExecutionResult);
        if (testIdentifier.isTest()) {
            if (testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
                try {
                    this.runListener.testFailure(FailureHelper.convert(testIdentifier, testExecutionResult.getThrowable().orElse(null)));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            RunListenerAdapter.withDescription(testIdentifier, this.runListener::testFinished);
        } else {
            RunListenerAdapter.withDescription(testIdentifier, this.runListener::testSuiteFinished);
        }
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.summarizer.dynamicTestRegistered(testIdentifier);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.summarizer.reportingEntryPublished(testIdentifier, entry);
    }

    private static void withDescription(TestIdentifier testIdentifier, ExceptionHandlingConsumer<Description, Exception> action) {
        DescriptionGenerator.toDescription(testIdentifier).ifPresent(action);
    }

    private static interface ExceptionHandlingConsumer<S, E extends Exception>
    extends Consumer<S> {
        @Override
        default public void accept(S s) {
            try {
                this.acceptAndThrow(s);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public void acceptAndThrow(S var1) throws E;
    }
}

