/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.impl.TestExecutionStrategy;
import org.apache.sling.junit.impl.TestsManagerImpl;
import org.apache.sling.junit.impl.servlet.junit5.RunListenerAdapter;
import org.apache.sling.junit.impl.servlet.junit5.TestEngineTracker;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.runner.notification.RunListener;
import org.osgi.framework.BundleContext;

public class JUnit5TestExecutionStrategy
implements TestExecutionStrategy {
    private static final List<String> REQUIRED_CLASSES = Collections.unmodifiableList(Arrays.asList("org.junit.platform.engine.TestEngine", "org.junit.platform.launcher.Launcher"));
    private final TestsManagerImpl testsManager;
    private final TestEngineTracker testEngineTracker;

    public static boolean canLoadRequiredClasses() {
        ClassLoader classLoader = JUnit5TestExecutionStrategy.class.getClassLoader();
        return REQUIRED_CLASSES.stream().allMatch(name -> {
            String path = name.replace('.', '/').concat(".class");
            return classLoader.getResource(path) != null;
        });
    }

    public JUnit5TestExecutionStrategy(TestsManagerImpl testsManager, BundleContext ctx) {
        this.testsManager = testsManager;
        this.testEngineTracker = new TestEngineTracker(ctx);
    }

    @Override
    public void close() {
        this.testEngineTracker.close();
    }

    @Override
    public void execute(TestSelector selector, RunListener runListener) throws Exception {
        Launcher launcher = LauncherFactory.create((LauncherConfig)LauncherConfig.builder().addTestEngines(this.testEngineTracker.getAvailableTestEngines()).addTestExecutionListeners(new TestExecutionListener[]{new RunListenerAdapter(runListener)}).enableTestEngineAutoRegistration(false).enableTestExecutionListenerAutoRegistration(false).build());
        LauncherDiscoveryRequest request = this.testsManager.createTestRequest(selector, this::methodRequest, this::classesRequest);
        launcher.execute(request, new TestExecutionListener[0]);
    }

    private LauncherDiscoveryRequest methodRequest(Class<?> testClass, String testMethodName) {
        return LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod(testClass, (String)testMethodName)}).build();
    }

    private LauncherDiscoveryRequest classesRequest(Class<?>[] testClasses) {
        DiscoverySelector[] selectors = (DiscoverySelector[])Stream.of(testClasses).map(DiscoverySelectors::selectClass).toArray(DiscoverySelector[]::new);
        return LauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
    }
}

