/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RequestParser;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.apache.sling.junit.TestsProvider;
import org.apache.sling.junit.impl.JUnit4TestExecutionStrategy;
import org.apache.sling.junit.impl.TestContextRunListenerWrapper;
import org.apache.sling.junit.impl.TestExecutionStrategy;
import org.apache.sling.junit.impl.servlet.junit5.JUnit5TestExecutionStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TestsManagerImpl
implements TestsManager {
    private static final Logger log = LoggerFactory.getLogger(TestsManagerImpl.class);
    public static final String PROP_STARTUP_TIMEOUT_SECONDS = "sling.junit.core.SystemStartupTimeoutSeconds";
    private final int startupTimeoutSeconds = Integer.parseInt(System.getProperty("sling.junit.core.SystemStartupTimeoutSeconds", "40"));
    private volatile boolean waitForSystemStartup = true;
    private BundleContext bundleContext;
    private ServiceTracker<TestsProvider, TestsProvider> testsProviderTracker;
    private TestExecutionStrategy executionStrategy;

    boolean isReady() {
        return !this.waitForSystemStartup;
    }

    @Activate
    protected void activate(BundleContext ctx) {
        this.bundleContext = ctx;
        this.testsProviderTracker = new ServiceTracker(this.bundleContext, TestsProvider.class, null);
        this.testsProviderTracker.open();
        try {
            this.executionStrategy = new JUnit5TestExecutionStrategy(this, ctx);
        }
        catch (NoClassDefFoundError e) {
            this.executionStrategy = new JUnit4TestExecutionStrategy(this);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.testsProviderTracker != null) {
            this.testsProviderTracker.close();
            this.testsProviderTracker = null;
        }
        if (this.executionStrategy != null) {
            this.executionStrategy.close();
            this.executionStrategy = null;
        }
        this.bundleContext = null;
    }

    @Override
    @NotNull
    public Class<?> getTestClass(@NotNull String testName) throws ClassNotFoundException {
        TestsProvider provider = this.getTestProviders().filter(p -> p.getTestNames().contains(testName)).findFirst().orElseThrow(() -> new ClassNotFoundException("No TestsProvider found for test '" + testName + "'"));
        log.debug("Using provider {} to create test class {}", (Object)provider, (Object)testName);
        return provider.createTestClass(testName);
    }

    @Override
    public Collection<String> getTestNames(@Nullable TestSelector selector) {
        List<String> tests = this.getTestProviders().map(TestsProvider::getTestNames).flatMap(Collection::stream).sorted().collect(Collectors.toList());
        int allTestsCount = tests.size();
        if (selector == null) {
            log.debug("No TestSelector supplied, returning all {} tests", (Object)allTestsCount);
        } else {
            tests.removeIf(testName -> !selector.acceptTestName((String)testName));
            log.debug("{} selected {} tests out of {}", new Object[]{selector, tests.size(), allTestsCount});
        }
        return tests;
    }

    private Stream<TestsProvider> getTestProviders() {
        return this.testsProviderTracker.getTracked().values().stream();
    }

    @Override
    public void executeTests(final @Nullable Collection<String> testNames, @NotNull Renderer renderer, @Nullable TestSelector selector) throws Exception {
        if (selector != null) {
            this.executeTests(renderer, selector);
        } else if (testNames != null) {
            this.executeTests(renderer, new RequestParser(null){

                @Override
                public boolean acceptTestName(String testName) {
                    return testNames.contains(testName);
                }
            });
        } else {
            this.executeTests(renderer, null);
        }
    }

    @Override
    public void executeTests(@NotNull Renderer renderer, @Nullable TestSelector selector) throws Exception {
        renderer.title(2, "Running tests");
        this.waitForSystemStartup();
        this.executionStrategy.execute(selector, new TestContextRunListenerWrapper(renderer.getRunListener()));
    }

    public <T> T createTestRequest(TestSelector selector, BiFunction<Class<?>, String, T> methodRequestFactory, Function<Class<?>[], T> classesRequestFactory) throws ClassNotFoundException {
        T request;
        String testMethodName;
        Collection<String> testNames = this.getTestNames(selector);
        if (testNames.isEmpty()) {
            throw new TestsManager.NoTestCasesFoundException();
        }
        String string = testMethodName = selector == null ? null : selector.getSelectedTestMethodName();
        if (testNames.size() == 1 && TestsManagerImpl.isNotBlank(testMethodName)) {
            String className = testNames.iterator().next();
            log.debug("Running test method {} from test class {}", (Object)testMethodName, (Object)className);
            request = methodRequestFactory.apply(this.getTestClass(className), testMethodName);
        } else {
            if (TestsManagerImpl.isNotBlank(testMethodName)) {
                throw new IllegalStateException("A test method name is only supported for a single test class");
            }
            ArrayList testClasses = new ArrayList();
            for (String className : testNames) {
                log.debug("Running test class {}", (Object)className);
                testClasses.add(this.getTestClass(className));
            }
            request = classesRequestFactory.apply(testClasses.toArray(new Class[0]));
        }
        return request;
    }

    private static boolean isNotBlank(String str) {
        return str != null && str.length() > 0;
    }

    @Override
    public void listTests(@NotNull Collection<String> testNames, @NotNull Renderer renderer) {
        renderer.title(2, "Test classes");
        String note = "The test set can be restricted using partial test names as a suffix to this URL, followed by the appropriate extension, like 'com.example.foo.tests.html'";
        renderer.info("note", "The test set can be restricted using partial test names as a suffix to this URL, followed by the appropriate extension, like 'com.example.foo.tests.html'");
        renderer.list("testNames", testNames);
    }

    @Override
    public void clearCaches() {
    }

    long waitForSystemStartup() {
        long elapsedMsec = -1L;
        if (this.waitForSystemStartup) {
            this.waitForSystemStartup = false;
            Set<Bundle> bundlesToWaitFor = Stream.of(this.bundleContext.getBundles()).filter(TestsManagerImpl.not(TestsManagerImpl::isActive).and(TestsManagerImpl.not(TestsManagerImpl::isFragment))).collect(Collectors.toSet());
            long startTime = System.currentTimeMillis();
            long startupTimeout = startTime + TimeUnit.SECONDS.toMillis(this.startupTimeoutSeconds);
            while (TestsManagerImpl.needToWait(startupTimeout, bundlesToWaitFor)) {
                log.info("Waiting for bundles to start: {}", bundlesToWaitFor);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                bundlesToWaitFor.removeIf(TestsManagerImpl::isActive);
            }
            elapsedMsec = System.currentTimeMillis() - startTime;
            if (!bundlesToWaitFor.isEmpty()) {
                log.warn("Waited {} milliseconds but the following bundles are not yet started: {}", (Object)elapsedMsec, bundlesToWaitFor);
            } else {
                log.info("All bundles are active, starting to run tests.");
            }
        }
        return elapsedMsec;
    }

    static boolean needToWait(long startupTimeout, Collection<Bundle> bundlesToWaitFor) {
        return startupTimeout > System.currentTimeMillis() && !bundlesToWaitFor.isEmpty();
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    private static boolean isActive(Bundle bundle) {
        return bundle.getState() == 32;
    }
}

