/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.sling.junit.TestsProvider;
import org.apache.sling.junit.impl.AbstractTestsProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TestsProvider.class})
public class BundleTestsProvider
extends AbstractTestsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BundleTestsProvider.class);
    public static final String SLING_TEST_REGEXP = "Sling-Test-Regexp";
    private TestClassesTracker tracker;

    @Activate
    protected void activate(BundleContext ctx) {
        this.tracker = new TestClassesTracker(ctx);
        this.tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    @Override
    public Class<?> createTestClass(String testName) throws ClassNotFoundException {
        Bundle bundle = this.tracker.getTracked().entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(testName)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new ClassNotFoundException("No Bundle found that supplies test class " + testName));
        return bundle.loadClass(testName);
    }

    @Override
    public List<String> getTestNames() {
        return this.tracker.getTracked().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class TestClassesTracker
    extends BundleTracker<Set<String>> {
        public TestClassesTracker(BundleContext ctx) {
            super(ctx, 32, null);
        }

        public Set<String> addingBundle(Bundle bundle, BundleEvent event) {
            super.addingBundle(bundle, event);
            if (TestClassesTracker.isFragment(bundle)) {
                return null;
            }
            Set<String> testClasses = TestClassesTracker.getTestClasses(bundle);
            return testClasses.isEmpty() ? null : testClasses;
        }

        @NotNull
        private static Set<String> getTestClasses(Bundle bundle) {
            Predicate<String> isTestClass;
            String headerValue = TestClassesTracker.getSlingTestRegexp(bundle);
            if (headerValue == null) {
                LOG.debug("Bundle '{}' does not have {} header, not looking for test classes", (Object)bundle.getSymbolicName(), (Object)BundleTestsProvider.SLING_TEST_REGEXP);
                return Collections.emptySet();
            }
            try {
                isTestClass = Pattern.compile(headerValue).asPredicate();
            }
            catch (PatternSyntaxException pse) {
                LOG.warn("Bundle '{}' has an invalid pattern for {} header, ignored: '{}'", new Object[]{bundle.getSymbolicName(), BundleTestsProvider.SLING_TEST_REGEXP, headerValue});
                return Collections.emptySet();
            }
            Enumeration classUrls = bundle.findEntries("", "*.class", true);
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            while (classUrls.hasMoreElements()) {
                URL url = (URL)classUrls.nextElement();
                String name = TestClassesTracker.toClassName(url);
                if (isTestClass.test(name)) {
                    result.add(name);
                    continue;
                }
                LOG.debug("Class '{}' does not match {} pattern '{}' of bundle '{}', ignored", new Object[]{name, BundleTestsProvider.SLING_TEST_REGEXP, headerValue, bundle.getSymbolicName()});
            }
            LOG.info("{} test classes found in bundle '{}'", (Object)result.size(), (Object)bundle.getSymbolicName());
            return result;
        }

        private static String getSlingTestRegexp(Bundle bundle) {
            return (String)bundle.getHeaders().get(BundleTestsProvider.SLING_TEST_REGEXP);
        }

        private static String toClassName(URL url) {
            String f = url.getFile();
            String cn = f.substring(1, f.length() - ".class".length());
            return cn.replace('/', '.');
        }

        private static boolean isFragment(Bundle bundle) {
            return bundle.getHeaders().get("Fragment-Host") != null;
        }
    }
}

