/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.rules;

import java.io.Closeable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

class ServiceGetter<T>
implements Closeable {
    private final ServiceTracker tracker;
    private final BundleContext bundleContext;

    public static <T> ServiceGetter<T> create(BundleContext bundleContext, Class<T> serviceClass, String ldapFilter) {
        return new ServiceGetter<T>(bundleContext, serviceClass, ldapFilter);
    }

    private ServiceGetter(BundleContext bundleContext, Class<T> serviceClass, String ldapFilter) {
        if (serviceClass.equals(BundleContext.class)) {
            this.bundleContext = bundleContext;
            this.tracker = null;
        } else {
            this.bundleContext = null;
            String classFilter = String.format("(%s=%s)", "objectClass", serviceClass.getName());
            String combinedFilter = ldapFilter == null || ldapFilter.trim().length() == 0 ? classFilter : String.format("(&%s%s)", classFilter, ldapFilter);
            try {
                Filter filter = FrameworkUtil.createFilter((String)combinedFilter);
                this.tracker = new ServiceTracker(bundleContext, filter, null);
                this.tracker.open();
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Syntax of argument ldapFilter is invalid", e);
            }
        }
    }

    public T getService() {
        if (this.tracker == null) {
            return (T)this.bundleContext;
        }
        return (T)this.tracker.getService();
    }

    public T getService(long timeout) throws InterruptedException {
        if (this.tracker == null) {
            return (T)this.bundleContext;
        }
        return (T)this.tracker.waitForService(timeout);
    }

    @Override
    public void close() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }
}

