/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.sling.junit.Activator;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.SlingTestContextProvider;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.apache.sling.junit.TestsProvider;
import org.apache.sling.junit.impl.TestContextRunListenerWrapper;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TestsManagerImpl
implements TestsManager {
    private static final Logger log = LoggerFactory.getLogger(TestsManagerImpl.class);
    public static final String PROP_STARTUP_TIMEOUT_SECONDS = "sling.junit.core.SystemStartupTimeoutSeconds";
    private static volatile int startupTimeoutSeconds = Integer.parseInt(System.getProperty("sling.junit.core.SystemStartupTimeoutSeconds", "40"));
    private static volatile boolean waitForSystemStartup = true;
    private ServiceTracker tracker;
    private int lastTrackingCount = -1;
    private BundleContext bundleContext;
    private final List<TestsProvider> providers = new ArrayList<TestsProvider>();
    private Map<String, String> tests = new ConcurrentHashMap<String, String>();
    private Map<String, Long> lastModified = new HashMap<String, Long>();

    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.tracker = new ServiceTracker(this.bundleContext, TestsProvider.class.getName(), null);
        this.tracker.open();
    }

    protected void deactivate(ComponentContext ctx) {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.tracker = null;
        this.bundleContext = null;
    }

    @Override
    public void clearCaches() {
        log.debug("Clearing internal caches");
        this.lastModified.clear();
        this.lastTrackingCount = -1;
    }

    @Override
    public Class<?> getTestClass(String testName) throws ClassNotFoundException {
        this.maybeUpdateProviders();
        String providerPid = this.tests.get(testName);
        if (providerPid == null) {
            throw new IllegalStateException("Provider PID not found for test " + testName);
        }
        TestsProvider provider = null;
        for (TestsProvider p : this.providers) {
            if (!p.getServicePid().equals(providerPid)) continue;
            provider = p;
            break;
        }
        if (provider == null) {
            throw new IllegalStateException("No TestsProvider found for PID " + providerPid);
        }
        log.debug("Using provider {} to create test class {}", provider, (Object)testName);
        return provider.createTestClass(testName);
    }

    @Override
    public Collection<String> getTestNames(TestSelector selector) {
        this.maybeUpdateProviders();
        boolean reload = false;
        for (TestsProvider p : this.providers) {
            Long lastMod = this.lastModified.get(p.getServicePid());
            if (lastMod != null && lastMod.longValue() == p.lastModified()) continue;
            reload = true;
            log.debug("{} updated, will reload test names from all providers", (Object)p);
            break;
        }
        if (reload) {
            this.tests.clear();
            for (TestsProvider p : this.providers) {
                String pid = p.getServicePid();
                if (pid == null) {
                    log.warn("{} has null PID, ignored", (Object)p);
                    continue;
                }
                this.lastModified.put(pid, p.lastModified());
                List<String> names = p.getTestNames();
                for (String name : names) {
                    this.tests.put(name, pid);
                }
                log.debug("Added {} test names from provider {}", (Object)names.size(), (Object)p);
            }
            log.info("Test names reloaded, total {} names from {} providers", (Object)this.tests.size(), (Object)this.providers.size());
        }
        Set<String> allTests = this.tests.keySet();
        if (selector == null) {
            log.debug("No TestSelector supplied, returning all {} tests", (Object)allTests.size());
            return allTests;
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String test : allTests) {
            if (!selector.acceptTestName(test)) continue;
            result.add(test);
        }
        log.debug("{} selected {} tests out of {}", new Object[]{selector, result.size(), allTests.size()});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUpdateProviders() {
        if (this.tracker.getTrackingCount() != this.lastTrackingCount) {
            this.lastModified.clear();
            ArrayList<TestsProvider> newList = new ArrayList<TestsProvider>();
            for (ServiceReference ref : this.tracker.getServiceReferences()) {
                newList.add((TestsProvider)this.bundleContext.getService(ref));
            }
            List<TestsProvider> list = this.providers;
            synchronized (list) {
                this.providers.clear();
                this.providers.addAll(newList);
            }
            log.info("Updated list of TestsProvider: {}", this.providers);
        }
        this.lastTrackingCount = this.tracker.getTrackingCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTests(Collection<String> testNames, Renderer renderer, TestSelector selector) throws Exception {
        boolean createContext;
        renderer.title(2, "Running tests");
        TestsManagerImpl.waitForSystemStartup();
        JUnitCore junit = new JUnitCore();
        boolean bl = createContext = !SlingTestContextProvider.hasContext();
        if (createContext) {
            SlingTestContextProvider.createContext();
        }
        try {
            junit.addListener(new TestContextRunListenerWrapper(renderer.getRunListener()));
            for (String className : testNames) {
                String testMethodName;
                renderer.title(3, className);
                if (SlingTestContextProvider.hasContext()) {
                    SlingTestContextProvider.getContext().output().clear();
                }
                String string = testMethodName = selector == null ? null : selector.getSelectedTestMethodName();
                if (testMethodName != null && testMethodName.length() > 0) {
                    log.debug("Running test method {} from test class {}", (Object)testMethodName, (Object)className);
                    junit.run(Request.method(this.getTestClass(className), testMethodName));
                    continue;
                }
                log.debug("Running test class {}", (Object)className);
                junit.run(this.getTestClass(className));
            }
        }
        finally {
            if (createContext) {
                SlingTestContextProvider.deleteContext();
            }
        }
    }

    @Override
    public void listTests(Collection<String> testNames, Renderer renderer) {
        renderer.title(2, "Test classes");
        String note = "The test set can be restricted using partial test names as a suffix to this URL, followed by the appropriate extension, like 'com.example.foo.tests.html'";
        renderer.info("note", "The test set can be restricted using partial test names as a suffix to this URL, followed by the appropriate extension, like 'com.example.foo.tests.html'");
        renderer.list("testNames", testNames);
    }

    public static long waitForSystemStartup() {
        long elapsedMsec = -1L;
        if (waitForSystemStartup) {
            waitForSystemStartup = false;
            BundleContext bundleContext = Activator.getBundleContext();
            HashSet<Bundle> bundlesToWaitFor = new HashSet<Bundle>();
            for (Bundle bundle : bundleContext.getBundles()) {
                if (bundle.getState() == 32 || TestsManagerImpl.isFragment(bundle)) continue;
                bundlesToWaitFor.add(bundle);
            }
            long startTime = System.currentTimeMillis();
            long startupTimeout = startTime + TimeUnit.SECONDS.toMillis(startupTimeoutSeconds);
            while (TestsManagerImpl.needToWait(startupTimeout, bundlesToWaitFor)) {
                log.info("Waiting for bundles to start: {}", bundlesToWaitFor);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Iterator bundles = bundlesToWaitFor.iterator();
                while (bundles.hasNext()) {
                    Bundle bundle = (Bundle)bundles.next();
                    if (bundle.getState() != 32) continue;
                    bundles.remove();
                    log.debug("Bundle {} is now active", (Object)bundle.getSymbolicName());
                }
            }
            elapsedMsec = System.currentTimeMillis() - startTime;
            if (!bundlesToWaitFor.isEmpty()) {
                log.warn("Waited {} milliseconds but the following bundles are not yet started: {}", (Object)elapsedMsec, bundlesToWaitFor);
            } else {
                log.info("All bundles are active, starting to run tests.");
            }
        }
        return elapsedMsec;
    }

    private static boolean needToWait(long startupTimeout, Collection<Bundle> bundlesToWaitFor) {
        return startupTimeout > System.currentTimeMillis() && !bundlesToWaitFor.isEmpty();
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }
}

