/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.sling.junit.TestsProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class BundleTestsProvider
implements TestsProvider,
BundleListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String COMPONENT_NAME = "component.name";
    private long lastModified;
    private BundleContext bundleContext;
    private String componentName;
    public static final String SLING_TEST_REGEXP = "Sling-Test-Regexp";
    private final List<String> changedBundles = new ArrayList<String>();
    private final Map<String, List<String>> testClassesMap = new HashMap<String, List<String>>();

    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle b : this.bundleContext.getBundles()) {
            if (this.getSlingTestRegexp(b) == null) continue;
            this.changedBundles.add(b.getSymbolicName());
            this.log.debug("Will look for test classes inside bundle {}", (Object)b.getSymbolicName());
        }
        this.lastModified = System.currentTimeMillis();
        this.componentName = (String)ctx.getProperties().get(COMPONENT_NAME);
    }

    protected void deactivate(ComponentContext ctx) {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.bundleContext = null;
        this.changedBundles.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", componentName(pid)=" + this.componentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUpdateTestClasses() {
        if (this.changedBundles.isEmpty()) {
            return;
        }
        ArrayList<String> bundlesToUpdate = new ArrayList<String>();
        Bundle[] bundleArray = this.changedBundles;
        synchronized (bundleArray) {
            bundlesToUpdate.addAll(this.changedBundles);
            this.changedBundles.clear();
        }
        for (String symbolicName : bundlesToUpdate) {
            this.testClassesMap.remove(symbolicName);
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!bundlesToUpdate.contains(b.getSymbolicName())) continue;
            List<String> testClasses = this.getTestClasses(b);
            if (testClasses != null) {
                this.testClassesMap.put(b.getSymbolicName(), testClasses);
                this.log.debug("{} test classes found in bundle {}, added to our list", (Object)testClasses.size(), (Object)b.getSymbolicName());
                continue;
            }
            this.log.debug("No test classes found in bundle {}", (Object)b.getSymbolicName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Bundle b = event.getBundle();
        if (this.getSlingTestRegexp(b) == null) {
            this.log.debug("Bundle {} does not have {} header, ignored", (Object)b.getSymbolicName(), (Object)SLING_TEST_REGEXP);
            return;
        }
        List<String> list = this.changedBundles;
        synchronized (list) {
            this.log.debug("Got BundleEvent for Bundle {}, will rebuild its lists of tests");
            this.changedBundles.add(b.getSymbolicName());
        }
        this.lastModified = System.currentTimeMillis();
    }

    private String getSlingTestRegexp(Bundle b) {
        return (String)b.getHeaders().get(SLING_TEST_REGEXP);
    }

    private List<String> getTestClasses(Bundle b) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern testClassRegexp = null;
        String headerValue = this.getSlingTestRegexp(b);
        if (headerValue != null) {
            try {
                testClassRegexp = Pattern.compile(headerValue);
            }
            catch (PatternSyntaxException pse) {
                this.log.warn("Invalid pattern '" + headerValue + "' for bundle " + b.getSymbolicName() + ", ignored", (Throwable)pse);
            }
        }
        if (testClassRegexp == null) {
            this.log.info("Bundle {} does not have {} header, not looking for test classes", (Object)SLING_TEST_REGEXP);
        } else if (32 != b.getState()) {
            this.log.info("Bundle {} is not active, no test classes considered", (Object)b.getSymbolicName());
        } else {
            Enumeration classUrls = b.findEntries("", "*.class", true);
            while (classUrls.hasMoreElements()) {
                URL url = (URL)classUrls.nextElement();
                String name = this.toClassName(url);
                if (testClassRegexp.matcher(name).matches()) {
                    result.add(name);
                    continue;
                }
                this.log.debug("Class {} does not match {} pattern {} of bundle {}, ignored", new Object[]{name, SLING_TEST_REGEXP, testClassRegexp, b.getSymbolicName()});
            }
            this.log.info("{} test classes found in bundle {}", (Object)result.size(), (Object)b.getSymbolicName());
        }
        return result;
    }

    private String toClassName(URL url) {
        String f = url.getFile();
        String cn = f.substring(1, f.length() - ".class".length());
        return cn.replace('/', '.');
    }

    private Bundle findBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        return null;
    }

    @Override
    public Class<?> createTestClass(String testName) throws ClassNotFoundException {
        Bundle b = null;
        for (Map.Entry<String, List<String>> e : this.testClassesMap.entrySet()) {
            if (!e.getValue().contains(testName)) continue;
            b = this.findBundle(e.getKey());
            break;
        }
        if (b == null) {
            throw new IllegalArgumentException("No Bundle found that supplies test class " + testName);
        }
        return b.loadClass(testName);
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public String getServicePid() {
        return this.componentName;
    }

    @Override
    public List<String> getTestNames() {
        this.maybeUpdateTestClasses();
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> list : this.testClassesMap.values()) {
            result.addAll(list);
        }
        return result;
    }
}

