/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl;

import java.lang.reflect.Field;
import org.apache.sling.junit.TestObjectProcessor;
import org.apache.sling.junit.annotations.TestReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AnnotationsProcessor
implements TestObjectProcessor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;

    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        if (this.bundleContext == null) {
            throw new IllegalArgumentException("Null BundleContext in activate()");
        }
        this.log.debug("{} activated, BundleContext={}", (Object)this, (Object)this.bundleContext);
    }

    protected void deactivate(ComponentContext ctx) {
        this.bundleContext = null;
        this.log.debug("{} deactivated", (Object)this);
    }

    @Override
    public Object process(Object testObject) throws Exception {
        this.log.debug("processing {}", testObject);
        for (Field f : testObject.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(TestReference.class)) continue;
            this.processTestReference(testObject, f);
        }
        return testObject;
    }

    private void processTestReference(Object testObject, Field f) throws Exception {
        if (this.bundleContext == null) {
            String msg = "Null BundleContext in processTestReference(), not activated?";
            this.log.error("Null BundleContext in processTestReference(), not activated?");
            throw new IllegalArgumentException("Null BundleContext in processTestReference(), not activated?");
        }
        Class<?> serviceType = f.getType();
        Object service = this.getService(serviceType);
        if (service != null) {
            f.setAccessible(true);
            f.set(testObject, service);
            this.log.debug("Injected service {} into field {}", (Object)serviceType.getName(), (Object)f.getName());
        } else {
            this.log.warn("Service {} not found for field {}", (Object)serviceType.getName(), (Object)f.getName());
        }
    }

    private Object getService(Class<?> c) {
        Object result = null;
        if (c.equals(BundleContext.class)) {
            result = this.bundleContext;
        } else {
            ServiceReference ref = this.bundleContext.getServiceReference(c.getName());
            if (ref != null) {
                result = this.bundleContext.getService(ref);
            }
        }
        return result;
    }
}

