/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resourcesecurity.impl;

import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceaccesssecurity.AllowingResourceAccessGate;
import org.apache.sling.resourceaccesssecurity.ResourceAccessGate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Sling JCR Resource Access Gate", description="This access gate can be used to handle the access to resources not backed by a JCR repository by providing ACLs in the reposiory")
@Service(value={ResourceAccessGate.class})
@Properties(value={@Property(name="path", label="Path", description="The path is a regular expression for which resources the service should be called"), @Property(name="checkpath.prefix", label="Deep Check Prefix", description="If this value is configured with a prefix and the resource path starts with this prefix, the prefix is removed from the path and the remaining part is appended  to the JCR path to check. For example if /foo/a/b/c is required, this prefix is  configured with /foo and the JCR node to check is /check, the permissions at  /check/a/b/c are checked."), @Property(name="jcrPath", label="JCR Node", description="This node is checked for permissions to the resources."), @Property(name="operations", value={"read", "create", "update", "delete"}, propertyPrivate=true), @Property(name="access.context", value={"provider"}, propertyPrivate=true)})
public class ResourceAccessGateFactory
extends AllowingResourceAccessGate
implements ResourceAccessGate {
    static final String PROP_JCR_PATH = "jcrPath";
    static final String PROP_PREFIX = "checkpath.prefix";
    private String jcrPath;
    private String prefix;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.jcrPath = PropertiesUtil.toString((Object)props.get(PROP_JCR_PATH), null);
        this.prefix = PropertiesUtil.toString((Object)props.get(PROP_PREFIX), null);
        if (this.prefix != null && !this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
    }

    private ResourceAccessGate.GateResult checkPermission(ResourceResolver resolver, String path, String permission) {
        boolean granted = false;
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            String checkPath = this.jcrPath;
            if (this.prefix != null && path.startsWith(this.prefix)) {
                checkPath = this.jcrPath + path.substring(this.prefix.length() - 1);
            }
            try {
                granted = session.hasPermission(checkPath, permission);
            }
            catch (RepositoryException re) {
                // empty catch block
            }
        }
        return granted ? ResourceAccessGate.GateResult.GRANTED : ResourceAccessGate.GateResult.DENIED;
    }

    public boolean hasReadRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasCreateRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasUpdateRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public boolean hasDeleteRestrictions(ResourceResolver resourceResolver) {
        return true;
    }

    public ResourceAccessGate.GateResult canRead(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "read");
    }

    public ResourceAccessGate.GateResult canDelete(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "remove");
    }

    public ResourceAccessGate.GateResult canUpdate(Resource resource) {
        return this.checkPermission(resource.getResourceResolver(), resource.getPath(), "set_property");
    }

    public ResourceAccessGate.GateResult canCreate(String absPathName, ResourceResolver resourceResolver) {
        return this.checkPermission(resourceResolver, absPathName, "add_node");
    }
}

