/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.io.InputStream;
import java.net.URI;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.external.ExternalizableInputStream;
import org.apache.sling.api.resource.external.URIProvider;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.JcrModifiableValueMap;
import org.apache.sling.jcr.resource.internal.JcrValueMap;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.apache.sling.jcr.resource.internal.helper.AccessLogger;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrExternalizableInputStream;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceIterator;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResourceMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Node.class, Map.class, Item.class, ValueMap.class}), @Adapter(value={InputStream.class}, condition="If the resource is a JcrNodeResource and has a jcr:data property or is an nt:file node."), @Adapter(value={ExternalizableInputStream.class}, condition="If the resource is a JcrNodeResource and has a jcr:data property or is an nt:file node, and can be read using a secure URL.")})
class JcrNodeResource
extends JcrItemResource<Node> {
    private static final String UNSET_RESOURCE_SUPER_TYPE = "<unset>";
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResource.class);
    private String resourceType;
    private String resourceSuperType;
    private final HelperData helper;

    public JcrNodeResource(@NotNull ResourceResolver resourceResolver, @NotNull String path, @Nullable String version, @NotNull Node node, @NotNull HelperData helper) {
        super(resourceResolver, path, version, node, new JcrNodeResourceMetadata(node));
        this.helper = helper;
        this.resourceSuperType = UNSET_RESOURCE_SUPER_TYPE;
        AccessLogger.incrementUsage(resourceResolver, "newJcrNodeResource", path);
    }

    @NotNull
    public String getResourceType() {
        if (this.resourceType == null) {
            try {
                this.resourceType = (String)((Object)new JcrValueMap(this.getNode(), this.helper).get("sling:resourceType", String.class));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unable to get resource type for node " + this.getNode(), (Throwable)e);
                this.resourceType = "<unknown resource type>";
            }
        }
        return this.resourceType;
    }

    public String getResourceSuperType() {
        if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
            try {
                Property property = NodeUtil.getPropertyOrNull(this.getNode(), "sling:resourceSuperType");
                if (property != null) {
                    this.resourceSuperType = property.getValue().getString();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (this.resourceSuperType == UNSET_RESOURCE_SUPER_TYPE) {
                this.resourceSuperType = null;
            }
        }
        return this.resourceSuperType;
    }

    public <Type> Type adaptTo(Class<Type> type) {
        if (type == Node.class || type == Item.class) {
            return (Type)this.getNode();
        }
        if (type == InputStream.class) {
            return (Type)this.getInputStream();
        }
        if (type == Map.class || type == ValueMap.class) {
            AccessLogger.incrementUsage(this.getResourceResolver(), "adaptToValueMap", this.path);
            return (Type)new JcrValueMap(this.getNode(), this.helper);
        }
        if (type == ModifiableValueMap.class) {
            try {
                this.getNode().getSession().checkPermission(this.getPath(), "set_property");
                return (Type)new JcrModifiableValueMap(this.getNode(), this.helper);
            }
            catch (AccessControlException ace) {
                LOGGER.debug("adaptTo(ModifiableValueMap): Cannot set properties on {}", (Object)this);
            }
            catch (RepositoryException e) {
                LOGGER.debug("adaptTo(ModifiableValueMap): Unexpected problem for {}", (Object)this);
            }
        }
        return (Type)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", superType=" + this.getResourceSuperType() + ", path=" + this.getPath();
    }

    @NotNull
    private Node getNode() {
        return (Node)this.getItem();
    }

    @Nullable
    private InputStream getInputStream() {
        Node node = this.getNode();
        try {
            Property data;
            try {
                data = NodeUtil.getPrimaryProperty(node);
            }
            catch (ItemNotFoundException infe) {
                LOGGER.debug("getInputStream: No primary items for {}", (Object)this, (Object)infe);
                data = null;
            }
            URI uri = this.convertToPublicURI();
            if (uri != null) {
                return new JcrExternalizableInputStream(data, uri);
            }
            if (data != null) {
                return data.getBinary().getStream();
            }
        }
        catch (RepositoryException re) {
            LOGGER.error("getInputStream: Cannot get InputStream for " + this, (Throwable)re);
        }
        return null;
    }

    @Nullable
    private URI convertToPublicURI() {
        for (URIProvider up : this.helper.getURIProviders()) {
            try {
                return up.toURI((Resource)this, URIProvider.Scope.EXTERNAL, URIProvider.Operation.READ);
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("{} declined toURI for resource '{}'", new Object[]{up.getClass(), this.getPath(), e});
            }
        }
        return null;
    }

    @Override
    @Nullable
    Iterator<Resource> listJcrChildren() {
        try {
            NodeIterator iter = this.getNode().getNodes();
            if (iter.hasNext()) {
                return new JcrNodeResourceIterator(this.getResourceResolver(), this.path, this.version, iter, this.helper, null);
            }
        }
        catch (RepositoryException re) {
            LOGGER.error("listChildren: Cannot get children of " + this, (Throwable)re);
        }
        return null;
    }
}

