/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.LinkedList;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrPropertyResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrItemResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(JcrItemResourceFactory.class);
    private final Session session;
    private final HelperData helper;
    private final boolean isJackrabbit;

    public JcrItemResourceFactory(@NotNull Session session, @NotNull HelperData helper) {
        this.helper = helper;
        this.session = session;
        this.isJackrabbit = session instanceof JackrabbitSession;
    }

    @Nullable
    public JcrItemResource<?> createResource(@NotNull ResourceResolver resourceResolver, @NotNull String resourcePath, @Nullable Resource parent, @Nullable Map<String, String> parameters) throws RepositoryException {
        JcrItemResource resource;
        String version = parameters != null && parameters.containsKey("v") ? parameters.get("v") : null;
        Item item = this.getItem(resourcePath, parent, version);
        if (item == null) {
            log.debug("createResource: No JCR Item exists at path '{}'", (Object)resourcePath);
            return null;
        }
        if (item.isNode()) {
            log.debug("createResource: Found JCR Node Resource at path '{}'", (Object)resourcePath);
            resource = new JcrNodeResource(resourceResolver, resourcePath, version, (Node)item, this.helper);
        } else {
            log.debug("createResource: Found JCR Property Resource at path '{}'", (Object)resourcePath);
            resource = new JcrPropertyResource(resourceResolver, resourcePath, version, (Property)item);
        }
        resource.getResourceMetadata().setParameterMap(parameters);
        return resource;
    }

    @Nullable
    private Item getItem(@NotNull String resourcePath, @Nullable Resource parent, @Nullable String versionSpecifier) throws RepositoryException {
        Item item;
        Node parentNode = null;
        String parentResourcePath = null;
        if (parent != null) {
            parentNode = (Node)parent.adaptTo(Node.class);
            parentResourcePath = parent.getPath();
        }
        if (parentNode != null && resourcePath.startsWith(parentResourcePath)) {
            String subPath = resourcePath.substring(parentResourcePath.length());
            if (!subPath.isEmpty() && subPath.charAt(0) == '/') {
                subPath = subPath.substring(1);
            }
            item = JcrItemResourceFactory.getSubitem(parentNode, subPath);
        } else {
            item = this.getItemOrNull(resourcePath);
        }
        if (item != null && versionSpecifier != null) {
            item = this.getHistoricItem(item, versionSpecifier);
        }
        return item;
    }

    @Nullable
    private Item getHistoricItem(Item item, String versionSpecifier) throws RepositoryException {
        Item currentItem = item;
        LinkedList<String> relPath = new LinkedList<String>();
        Node version = null;
        while (!"/".equals(currentItem.getPath())) {
            if (JcrItemResourceFactory.isVersionable(currentItem)) {
                version = this.getFrozenNode((Node)currentItem, versionSpecifier);
                break;
            }
            relPath.addFirst(currentItem.getName());
            currentItem = currentItem.getParent();
        }
        if (version != null) {
            return JcrItemResourceFactory.getSubitem(version, StringUtils.join(relPath.iterator(), (char)'/'));
        }
        return null;
    }

    @Nullable
    private static Item getSubitem(@NotNull Node node, @NotNull String relPath) {
        try {
            if (relPath.isEmpty()) {
                return node;
            }
            Node childNode = NodeUtil.getNodeOrNull(node, relPath);
            if (childNode != null) {
                return childNode;
            }
            return NodeUtil.getPropertyOrNull(node, relPath);
        }
        catch (RepositoryException e) {
            log.debug("getSubitem: Can't get subitem {} of {}: {}", new Object[]{relPath, node, e.toString()});
            return null;
        }
    }

    @Nullable
    private Node getFrozenNode(@NotNull Node node, @NotNull String versionSpecifier) throws RepositoryException {
        VersionManager versionManager = this.session.getWorkspace().getVersionManager();
        VersionHistory history = versionManager.getVersionHistory(node.getPath());
        if (history.hasVersionLabel(versionSpecifier)) {
            return history.getVersionByLabel(versionSpecifier).getFrozenNode();
        }
        if (history.hasNode(versionSpecifier)) {
            return history.getVersion(versionSpecifier).getFrozenNode();
        }
        return null;
    }

    private static boolean isVersionable(@NotNull Item item) throws RepositoryException {
        return item.isNode() && ((Node)item).isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable");
    }

    @Nullable
    Item getItemOrNull(@NotNull String path) {
        if (path.isEmpty() || path.charAt(0) != '/') {
            return null;
        }
        Item item = null;
        try {
            if (this.isJackrabbit) {
                item = ((JackrabbitSession)this.session).getItemOrNull(path);
            } else if (this.session.itemExists(path)) {
                item = this.session.getItem(path);
            }
        }
        catch (RepositoryException e) {
            log.debug("Unable to access item at " + path + ", possibly invalid path", (Throwable)e);
        }
        return item;
    }

    @Nullable
    Node getParentOrNull(@NotNull Item child, @NotNull String parentPath) {
        Node parent = null;
        try {
            if (this.isJackrabbit) {
                parent = ((JackrabbitSession)this.session).getParentOrNull(child);
            } else if (this.session.nodeExists(parentPath)) {
                parent = this.session.getNode(parentPath);
            }
        }
        catch (RepositoryException e) {
            log.debug("Unable to access node at {}", (Object)parentPath, (Object)e);
        }
        return parent;
    }
}

