/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.jcr.resource.internal.helper.BooleanConverter;
import org.apache.sling.jcr.resource.internal.helper.CalendarConverter;
import org.apache.sling.jcr.resource.internal.helper.Converter;
import org.apache.sling.jcr.resource.internal.helper.DateConverter;
import org.apache.sling.jcr.resource.internal.helper.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.helper.NumberConverter;
import org.apache.sling.jcr.resource.internal.helper.StringConverter;
import org.apache.sling.jcr.resource.internal.helper.ZonedDateTimeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPropertyMapCacheEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertyMapCacheEntry.class);
    private final Property property;
    private final boolean isArray;
    private final Object propertyValue;

    public JcrPropertyMapCacheEntry(@NotNull Property prop) throws RepositoryException {
        this.property = prop;
        this.isArray = prop.isMultiple();
        this.propertyValue = this.property.getType() != 2 ? JcrResourceUtil.toJavaObject(prop) : null;
    }

    public JcrPropertyMapCacheEntry(@NotNull Object value, @NotNull Node node) throws RepositoryException {
        this.property = null;
        this.propertyValue = value;
        this.isArray = value.getClass().isArray();
        if (this.isArray) {
            Object[] values;
            for (Object o : values = JcrPropertyMapCacheEntry.convertToObjectArray(value)) {
                JcrPropertyMapCacheEntry.failIfCannotStore(o, node);
            }
        } else {
            JcrPropertyMapCacheEntry.failIfCannotStore(value, node);
        }
    }

    private static void failIfCannotStore(@NotNull Object value, @NotNull Node node) throws RepositoryException {
        if (value instanceof InputStream) {
            return;
        }
        Value val = JcrPropertyMapCacheEntry.createValue(value, node);
        if (val == null) {
            throw new IllegalArgumentException("Value can't be stored in the repository: " + value);
        }
    }

    @Nullable
    private static Value createValue(@NotNull Object obj, @NotNull Node node) throws RepositoryException {
        Session session = node.getSession();
        Value value = JcrResourceUtil.createValue(obj, session);
        if (value == null && obj instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                value = session.getValueFactory().createValue(session.getValueFactory().createBinary((InputStream)bais));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    @NotNull
    private static Object[] convertToObjectArray(@NotNull Object value) {
        Object[] values = value instanceof long[] ? ArrayUtils.toObject((long[])((long[])value)) : (value instanceof int[] ? ArrayUtils.toObject((int[])((int[])value)) : (value instanceof double[] ? ArrayUtils.toObject((double[])((double[])value)) : (value instanceof byte[] ? ArrayUtils.toObject((byte[])((byte[])value)) : (value instanceof float[] ? ArrayUtils.toObject((float[])((float[])value)) : (value instanceof short[] ? ArrayUtils.toObject((short[])((short[])value)) : (value instanceof boolean[] ? ArrayUtils.toObject((boolean[])((boolean[])value)) : (value instanceof char[] ? ArrayUtils.toObject((char[])((char[])value)) : (Object[])value)))))));
        return values;
    }

    public boolean isArray() {
        return this.isArray;
    }

    @NotNull
    public Object getPropertyValue() throws RepositoryException {
        return this.propertyValue != null ? this.propertyValue : JcrResourceUtil.toJavaObject(this.property);
    }

    @Nullable
    public Object getPropertyValueOrNull() {
        try {
            return this.getPropertyValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Nullable
    public <T> T convertToType(@NotNull Class<T> type, @NotNull Node node, @Nullable ClassLoader dynamicClassLoader) {
        Object result = null;
        try {
            boolean targetIsArray = type.isArray();
            if (this.isArray) {
                Object[] sourceArray = JcrPropertyMapCacheEntry.convertToObjectArray(this.getPropertyValue());
                if (targetIsArray) {
                    result = this.convertToArray(sourceArray, type.getComponentType(), node, dynamicClassLoader);
                } else if (sourceArray.length > 0) {
                    result = this.convertToType(-1, sourceArray[0], type, node, dynamicClassLoader);
                }
            } else {
                Object sourceObject = this.getPropertyValue();
                result = targetIsArray ? this.convertToArray(sourceObject, type.getComponentType(), node, dynamicClassLoader) : this.convertToType(-1, sourceObject, type, node, dynamicClassLoader);
            }
        }
        catch (IllegalArgumentException | ValueFormatException vfe) {
            LOGGER.info("convertToType: Cannot convert value of {} to {}.", new Object[]{this.getPropertyValueOrNull(), type, vfe});
        }
        catch (RepositoryException re) {
            LOGGER.info("convertToType: Cannot get value of {}", this.getPropertyValueOrNull(), (Object)re);
        }
        return (T)result;
    }

    @NotNull
    private <T> T[] convertToArray(@NotNull Object source, @NotNull Class<T> type, @NotNull Node node, @Nullable ClassLoader dynamicClassLoader) throws RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        T value = this.convertToType(-1, source, type, node, dynamicClassLoader);
        if (value != null) {
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    @NotNull
    private <T> T[] convertToArray(@NotNull Object[] sourceArray, @NotNull Class<T> type, @NotNull Node node, @Nullable ClassLoader dynamicClassLoader) throws RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < sourceArray.length; ++i) {
            T value = this.convertToType(i, sourceArray[i], type, node, dynamicClassLoader);
            if (value == null) continue;
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    @Nullable
    private <T> T convertToType(int index, @NotNull Object initialValue, @NotNull Class<T> type, @NotNull Node node, @Nullable ClassLoader dynamicClassLoader) throws RepositoryException {
        if (type.isInstance(initialValue)) {
            return (T)initialValue;
        }
        if (initialValue instanceof InputStream) {
            return this.convertInputStream(index, (InputStream)initialValue, type, node, dynamicClassLoader);
        }
        return this.convert(initialValue, type, node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T convertInputStream(int index, @NotNull InputStream value, @NotNull Class<T> type, @NotNull Node node, @Nullable ClassLoader dynamicClassLoader) throws RepositoryException {
        if (ObjectInputStream.class.isAssignableFrom(type)) {
            try {
                return (T)new PropertyObjectInputStream(value, dynamicClassLoader);
            }
            catch (IOException iOException) {
                return this.convert(value, type, node);
            }
        }
        if (Number.class.isAssignableFrom(type)) {
            if (this.property != null) return this.convert(JcrPropertyMapCacheEntry.propertyToLength(this.property, index), type, node);
            return null;
        }
        if (String.class == type) {
            return (T)JcrPropertyMapCacheEntry.inputStreamToString(value);
        }
        if (!Serializable.class.isAssignableFrom(type)) return this.convert(value, type, node);
        try (PropertyObjectInputStream ois = new PropertyObjectInputStream(value, dynamicClassLoader);){
            Object obj = ois.readObject();
            if (type.isInstance(obj)) {
                Object object = obj;
                return (T)object;
            }
            T t = this.convert(obj, type, node);
            return t;
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return this.convert(value, type, node);
    }

    @NotNull
    private static Long propertyToLength(@NotNull Property property, int index) throws RepositoryException {
        if (index == -1) {
            return property.getLength();
        }
        return property.getLengths()[index];
    }

    @NotNull
    private static String inputStreamToString(@NotNull InputStream value) {
        String string;
        block9: {
            InputStream in = value;
            try {
                int l;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                while ((l = in.read(buffer)) >= 0) {
                    if (l <= 0) continue;
                    baos.write(buffer, 0, l);
                }
                string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            in.close();
        }
        return string;
    }

    @Nullable
    private <T> T convert(@NotNull Object value, @NotNull Class<T> type, @NotNull Node node) throws RepositoryException {
        if (String.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toString();
        }
        if (Byte.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toByte();
        }
        if (Short.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toShort();
        }
        if (Integer.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toInteger();
        }
        if (Long.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toLong();
        }
        if (Float.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toFloat();
        }
        if (Double.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toDouble();
        }
        if (BigDecimal.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toBigDecimal();
        }
        if (Boolean.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toBoolean();
        }
        if (Date.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toDate();
        }
        if (Calendar.class == type) {
            return (T)JcrPropertyMapCacheEntry.getConverter(value).toCalendar();
        }
        if (ZonedDateTime.class == type) {
            Calendar calendar = JcrPropertyMapCacheEntry.getConverter(value).toCalendar();
            return (T)ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId().normalized());
        }
        if (Value.class == type) {
            return (T)JcrPropertyMapCacheEntry.createValue(value, node);
        }
        if (Property.class == type) {
            return (T)this.property;
        }
        return null;
    }

    @NotNull
    private static Converter getConverter(@NotNull Object value) {
        if (value instanceof Number) {
            return new NumberConverter((Number)value);
        }
        if (value instanceof Boolean) {
            return new BooleanConverter((Boolean)value);
        }
        if (value instanceof Date) {
            return new DateConverter((Date)value);
        }
        if (value instanceof Calendar) {
            return new CalendarConverter((Calendar)value);
        }
        if (value instanceof ZonedDateTime) {
            return new ZonedDateTimeConverter((ZonedDateTime)value);
        }
        return new StringConverter(value);
    }

    private static class PropertyObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classloader;

        public PropertyObjectInputStream(@NotNull InputStream in, @Nullable ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return this.classloader.loadClass(classDesc.getName());
            }
            return super.resolveClass(classDesc);
        }
    }
}

