/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.jcr.resource.internal.helper.BooleanConverter;
import org.apache.sling.jcr.resource.internal.helper.CalendarConverter;
import org.apache.sling.jcr.resource.internal.helper.Converter;
import org.apache.sling.jcr.resource.internal.helper.DateConverter;
import org.apache.sling.jcr.resource.internal.helper.JcrResourceUtil;
import org.apache.sling.jcr.resource.internal.helper.NumberConverter;
import org.apache.sling.jcr.resource.internal.helper.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPropertyMapCacheEntry {
    private static Logger LOGGER = LoggerFactory.getLogger(JcrPropertyMapCacheEntry.class);
    private final Property property;
    private final boolean isArray;
    private final Object propertyValue;

    public JcrPropertyMapCacheEntry(Property prop) throws RepositoryException {
        this.property = prop;
        this.isArray = prop.isMultiple();
        this.propertyValue = this.property.getType() != 2 ? JcrResourceUtil.toJavaObject(prop) : null;
    }

    public JcrPropertyMapCacheEntry(Object value, Node node) throws RepositoryException {
        this.property = null;
        this.propertyValue = value;
        this.isArray = value.getClass().isArray();
        if (this.isArray) {
            Object[] values = this.convertToObjectArray(value);
            for (int i = 0; i < values.length; ++i) {
                this.failIfCannotStore(values[i], node);
            }
        } else {
            this.failIfCannotStore(value, node);
        }
    }

    private void failIfCannotStore(Object value, Node node) throws RepositoryException {
        if (value instanceof InputStream) {
            return;
        }
        Value val = this.createValue(value, node);
        if (val == null) {
            throw new IllegalArgumentException("Value can't be stored in the repository: " + value);
        }
    }

    private Value createValue(Object obj, Node node) throws RepositoryException {
        Session session = node.getSession();
        Value value = JcrResourceUtil.createValue(obj, session);
        if (value == null && obj instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                value = session.getValueFactory().createValue(session.getValueFactory().createBinary((InputStream)bais));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    private Object[] convertToObjectArray(Object value) {
        Object[] values = value instanceof long[] ? ArrayUtils.toObject((long[])((long[])value)) : (value instanceof int[] ? ArrayUtils.toObject((int[])((int[])value)) : (value instanceof double[] ? ArrayUtils.toObject((double[])((double[])value)) : (value instanceof byte[] ? ArrayUtils.toObject((byte[])((byte[])value)) : (value instanceof float[] ? ArrayUtils.toObject((float[])((float[])value)) : (value instanceof short[] ? ArrayUtils.toObject((short[])((short[])value)) : (value instanceof boolean[] ? ArrayUtils.toObject((boolean[])((boolean[])value)) : (value instanceof char[] ? ArrayUtils.toObject((char[])((char[])value)) : (Object[])value)))))));
        return values;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Object getPropertyValue() throws RepositoryException {
        return this.propertyValue != null ? this.propertyValue : JcrResourceUtil.toJavaObject(this.property);
    }

    public Object getPropertyValueOrNull() {
        try {
            return this.getPropertyValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public <T> T convertToType(Class<T> type, Node node, ClassLoader dynamicClassLoader) {
        Object result = null;
        try {
            boolean targetIsArray = type.isArray();
            if (this.isArray) {
                Object[] sourceArray = this.convertToObjectArray(this.getPropertyValue());
                if (targetIsArray) {
                    result = this.convertToArray(sourceArray, type.getComponentType(), node, dynamicClassLoader);
                } else if (sourceArray.length > 0) {
                    result = this.convertToType(-1, sourceArray[0], type, node, dynamicClassLoader);
                }
            } else {
                Object sourceObject = this.getPropertyValue();
                result = targetIsArray ? this.convertToArray(new Object[]{sourceObject}, type.getComponentType(), node, dynamicClassLoader) : (Object)this.convertToType(-1, sourceObject, type, node, dynamicClassLoader);
            }
        }
        catch (NumberFormatException vfe) {
            LOGGER.info("converToType: Cannot convert value of " + this.getPropertyValueOrNull() + " to " + type, (Throwable)vfe);
        }
        catch (IllegalArgumentException vfe) {
            LOGGER.info("converToType: Cannot convert value of " + this.getPropertyValueOrNull() + " to " + type, (Throwable)vfe);
        }
        catch (ValueFormatException vfe) {
            LOGGER.info("converToType: Cannot convert value of " + this.getPropertyValueOrNull() + " to " + type, (Throwable)vfe);
        }
        catch (RepositoryException re) {
            LOGGER.info("converToType: Cannot get value of " + this.getPropertyValueOrNull(), (Throwable)re);
        }
        return (T)result;
    }

    private <T> T[] convertToArray(Object[] sourceArray, Class<T> type, Node node, ClassLoader dynamicClassLoader) throws RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < sourceArray.length; ++i) {
            T value = this.convertToType(i, sourceArray[i], type, node, dynamicClassLoader);
            if (value == null) continue;
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T convertToType(int index, Object initialValue, Class<T> type, Node node, ClassLoader dynamicClassLoader) throws RepositoryException {
        Object value;
        block51: {
            if (type.isInstance(initialValue)) {
                return (T)initialValue;
            }
            value = initialValue;
            if (value instanceof InputStream) {
                if (ObjectInputStream.class.isAssignableFrom(type)) {
                    try {
                        return (T)new PropertyObjectInputStream((InputStream)value, dynamicClassLoader);
                    }
                    catch (IOException iOException) {
                        break block51;
                    }
                }
                if (Number.class.isAssignableFrom(type)) {
                    value = index == -1 ? Long.valueOf(this.property.getLength()) : Long.valueOf(this.property.getLengths()[index]);
                } else {
                    if (String.class == type) {
                        InputStream in = (InputStream)value;
                        try {
                            int l;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buffer = new byte[2048];
                            while ((l = in.read(buffer)) >= 0) {
                                if (l <= 0) continue;
                                baos.write(buffer, 0, l);
                            }
                            value = new String(baos.toByteArray(), "UTF-8");
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (Serializable.class.isAssignableFrom(type)) {
                        PropertyObjectInputStream ois = null;
                        try {
                            ois = new PropertyObjectInputStream((InputStream)value, dynamicClassLoader);
                            Object obj = ois.readObject();
                            if (type.isInstance(obj)) {
                                Object object = obj;
                                return (T)object;
                            }
                            value = obj;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                }
            }
        }
        if (String.class == type) {
            return (T)this.getConverter(value).toString();
        }
        if (Byte.class == type) {
            return (T)this.getConverter(value).toByte();
        }
        if (Short.class == type) {
            return (T)this.getConverter(value).toShort();
        }
        if (Integer.class == type) {
            return (T)this.getConverter(value).toInteger();
        }
        if (Long.class == type) {
            return (T)this.getConverter(value).toLong();
        }
        if (Float.class == type) {
            return (T)this.getConverter(value).toFloat();
        }
        if (Double.class == type) {
            return (T)this.getConverter(value).toDouble();
        }
        if (BigDecimal.class == type) {
            return (T)this.getConverter(value).toBigDecimal();
        }
        if (Boolean.class == type) {
            return (T)this.getConverter(value).toBoolean();
        }
        if (Date.class == type) {
            return (T)this.getConverter(value).toDate();
        }
        if (Calendar.class == type) {
            return (T)this.getConverter(value).toCalendar();
        }
        if (Value.class == type) {
            return (T)this.createValue(value, node);
        }
        if (Property.class != type) return null;
        return (T)this.property;
    }

    private Converter getConverter(Object value) {
        if (value instanceof Number) {
            return new NumberConverter((Number)value);
        }
        if (value instanceof Boolean) {
            return new BooleanConverter((Boolean)value);
        }
        if (value instanceof Date) {
            return new DateConverter((Date)value);
        }
        if (value instanceof Calendar) {
            return new CalendarConverter((Calendar)value);
        }
        return new StringConverter(value);
    }

    private static class PropertyObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classloader;

        public PropertyObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classloader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.classloader != null) {
                return this.classloader.loadClass(classDesc.getName());
            }
            return super.resolveClass(classDesc);
        }
    }
}

