/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.helper.JcrPropertyMapCacheEntry;

public class JcrValueMap
implements ValueMap {
    private final HelperData helper;
    private final Node node;
    final Map<String, JcrPropertyMapCacheEntry> cache;
    final Map<String, Object> valueCache;
    boolean fullyRead;

    public JcrValueMap(Node node, HelperData helper) {
        this.node = node;
        this.cache = new LinkedHashMap<String, JcrPropertyMapCacheEntry>();
        this.valueCache = new LinkedHashMap<String, Object>();
        this.fullyRead = false;
        this.helper = helper;
    }

    protected Node getNode() {
        return this.node;
    }

    String checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (key.startsWith("./")) {
            return key.substring(2);
        }
        return key;
    }

    public <T> T get(String aKey, Class<T> type) {
        String key = this.checkKey(aKey);
        if (type == null) {
            return (T)this.get(key);
        }
        JcrPropertyMapCacheEntry entry = this.read(key);
        if (entry == null) {
            return null;
        }
        return entry.convertToType(type, this.node, this.getDynamicClassLoader());
    }

    public <T> T get(String aKey, T defaultValue) {
        String key = this.checkKey(aKey);
        if (defaultValue == null) {
            return (T)this.get(key);
        }
        Class<?> type = this.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(key, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public Object get(Object aKey) {
        String key = this.checkKey(aKey.toString());
        JcrPropertyMapCacheEntry entry = this.read(key);
        Object value = entry == null ? null : entry.getPropertyValueOrNull();
        return value;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        this.readFully();
        return this.valueCache.containsValue(value);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        this.readFully();
        return this.cache.size();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        Map<String, Object> sourceMap = this.cache.size() == this.valueCache.size() ? this.valueCache : this.transformEntries(this.cache);
        return Collections.unmodifiableSet(sourceMap.entrySet());
    }

    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    public Collection<Object> values() {
        this.readFully();
        Map<String, Object> sourceMap = this.cache.size() == this.valueCache.size() ? this.valueCache : this.transformEntries(this.cache);
        return Collections.unmodifiableCollection(sourceMap.values());
    }

    @Deprecated
    public String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    private JcrPropertyMapCacheEntry cacheProperty(Property prop) {
        try {
            JcrPropertyMapCacheEntry entry;
            String name = prop.getName();
            String key = null;
            if (name.indexOf("_x") != -1 && (key = ISO9075.decode(name)).equals(name)) {
                key = null;
            }
            if (key == null) {
                key = Text.unescapeIllegalJcrChars(name);
            }
            if ((entry = this.cache.get(key)) == null) {
                entry = new JcrPropertyMapCacheEntry(prop);
                this.cache.put(key, entry);
                Object defaultValue = entry.getPropertyValue();
                if (defaultValue != null) {
                    this.valueCache.put(key, entry.getPropertyValue());
                }
            }
            return entry;
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
    }

    JcrPropertyMapCacheEntry read(String name) {
        String key;
        if (name.length() == 0) {
            return null;
        }
        if (name.indexOf(47) != -1) {
            int pos;
            String path = ISO9075.encodePath(name);
            try {
                if (this.node.hasProperty(path)) {
                    return new JcrPropertyMapCacheEntry(this.node.getProperty(path));
                }
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
            StringBuilder sb = new StringBuilder();
            int lastPos = -1;
            for (pos = 0; pos < name.length(); ++pos) {
                if (name.charAt(pos) != '/') continue;
                if (lastPos + 1 < pos) {
                    sb.append(Text.escapeIllegalJcrChars(name.substring(lastPos + 1, pos)));
                }
                sb.append('/');
                lastPos = pos;
            }
            if (lastPos + 1 < pos) {
                sb.append(Text.escapeIllegalJcrChars(name.substring(lastPos + 1)));
            }
            String newPath = sb.toString();
            try {
                if (this.node.hasProperty(newPath)) {
                    return new JcrPropertyMapCacheEntry(this.node.getProperty(newPath));
                }
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
            return null;
        }
        JcrPropertyMapCacheEntry cachedValued = this.cache.get(name);
        if (this.fullyRead || cachedValued != null) {
            return cachedValued;
        }
        try {
            key = this.escapeKeyName(name);
            if (this.node.hasProperty(key)) {
                Property prop = this.node.getProperty(key);
                return this.cacheProperty(prop);
            }
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException(re);
        }
        try {
            String oldKey = ISO9075.encodePath(name);
            if (!oldKey.equals(key) && this.node.hasProperty(oldKey)) {
                Property prop = this.node.getProperty(oldKey);
                return this.cacheProperty(prop);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    protected String escapeKeyName(String key) throws RepositoryException {
        int indexOfPrefix = key.indexOf(58);
        if (indexOfPrefix > 0 && key.length() > indexOfPrefix + 1) {
            String prefix = key.substring(0, indexOfPrefix);
            for (String existingPrefix : this.getNamespacePrefixes()) {
                if (!existingPrefix.equals(prefix)) continue;
                return prefix + ":" + Text.escapeIllegalJcrChars(key.substring(indexOfPrefix + 1));
            }
        }
        return Text.escapeIllegalJcrChars(key);
    }

    void readFully() {
        if (!this.fullyRead) {
            try {
                PropertyIterator pi = this.node.getProperties();
                while (pi.hasNext()) {
                    Property prop = pi.nextProperty();
                    this.cacheProperty(prop);
                }
                this.fullyRead = true;
            }
            catch (RepositoryException re) {
                throw new IllegalArgumentException(re);
            }
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    private Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (Property.class.isAssignableFrom(type)) {
            type = Property.class;
        }
        return type;
    }

    private Map<String, Object> transformEntries(Map<String, JcrPropertyMapCacheEntry> map) {
        LinkedHashMap<String, Object> transformedEntries = new LinkedHashMap<String, Object>(map.size());
        for (Map.Entry<String, JcrPropertyMapCacheEntry> entry : map.entrySet()) {
            transformedEntries.put(entry.getKey(), entry.getValue().getPropertyValueOrNull());
        }
        return transformedEntries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JcrPropertyMap [node=");
        sb.append(this.node);
        sb.append(", values={");
        Iterator<Map.Entry<String, Object>> iter = this.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Map.Entry<String, Object> e = iter.next();
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
        }
        sb.append("}]");
        return sb.toString();
    }

    private String[] getNamespacePrefixes() throws RepositoryException {
        return this.helper.getNamespacePrefixes(this.getNode().getSession());
    }

    private ClassLoader getDynamicClassLoader() {
        return this.helper.getDynamicClassLoader();
    }
}

