/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.packageinit.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlan;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRepositoryInitializer.class}, property={"service.ranking:Integer=200"})
@Designate(ocd=Config.class)
public class ExecutionPlanRepoInitializer
implements SlingRepositoryInitializer {
    private static final String EXECUTEDPLANS_FILE = "executedplans.file";
    private List<String> executionPlans = new ArrayList<String>();
    private File statusFile;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BundleContext context;

    @Activate
    private void activate(BundleContext context, Config config) throws FileNotFoundException, IOException {
        List<String> epCandidates = Arrays.asList(config.executionplans());
        if (!epCandidates.isEmpty()) {
            if (StringUtils.isEmpty((CharSequence)config.statusfilepath())) {
                this.statusFile = context.getDataFile(EXECUTEDPLANS_FILE);
            } else {
                Path statusFilePath = Paths.get(config.statusfilepath(), new String[0]);
                if (statusFilePath.isAbsolute()) {
                    this.statusFile = statusFilePath.toFile();
                } else {
                    throw new IllegalStateException("Only absolute paths supported");
                }
            }
            if (this.statusFile.exists()) {
                ArrayList<Integer> executedHashes = new ArrayList<Integer>();
                try (BufferedReader br = new BufferedReader(new FileReader(this.statusFile));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        executedHashes.add(Integer.parseInt(line));
                    }
                }
                this.processCandidates(epCandidates, executedHashes);
            } else {
                this.executionPlans.addAll(epCandidates);
            }
        }
        this.context = context;
    }

    private void processCandidates(List<String> epCandidates, List<Integer> executedHashes) {
        Iterator<String> candidateIt = epCandidates.iterator();
        Iterator<Integer> executedHashesIt = executedHashes.iterator();
        while (candidateIt.hasNext()) {
            String candidate = candidateIt.next();
            boolean foundDifference = false;
            if (!executedHashesIt.hasNext() || foundDifference) {
                this.executionPlans.add(candidate);
                continue;
            }
            Integer executedHash = executedHashesIt.next();
            if (this.isCandidateProcessed(candidate, executedHash)) continue;
            this.executionPlans.add(candidate);
            String msg = "Found difference in hashed executionplans - queueing executionplan for processing.";
            this.logger.info(msg);
            foundDifference = true;
        }
    }

    private boolean isCandidateProcessed(String candidate, Integer executedHash) {
        return executedHash.equals(candidate.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository slingRepository) throws Exception {
        block13: {
            if (!this.executionPlans.isEmpty()) {
                try (ServiceTracker st = new ServiceTracker(this.context, PackageRegistry.class, null);){
                    st.open();
                    this.logger.info("Waiting for PackageRegistry.");
                    PackageRegistry registry = (PackageRegistry)st.waitForService(0L);
                    this.logger.info("PackageRegistry found - starting execution of executionplan");
                    Session session = slingRepository.loginAdministrative(null);
                    ExecutionPlanBuilder builder = registry.createExecutionPlan();
                    try (BufferedWriter writer = null;){
                        writer = new BufferedWriter(new FileWriter(this.statusFile));
                        for (String plan : this.executionPlans) {
                            builder.load((InputStream)new ByteArrayInputStream(plan.getBytes("UTF-8")));
                            builder.with(session);
                            ExecutionPlan xplan = builder.execute();
                            if (xplan.getTasks().size() > 0) {
                                if (xplan.hasErrors()) {
                                    IllegalStateException ex = new IllegalStateException("Excecutionplan execution contained errors - cannot complete repository initialization.");
                                    for (PackageTask task : xplan.getTasks()) {
                                        if (!PackageTask.State.ERROR.equals((Object)task.getState())) continue;
                                        ex.addSuppressed(task.getError());
                                    }
                                    throw ex;
                                }
                                this.logger.info("executionplan executed with {} entries", (Object)xplan.getTasks().size());
                            } else {
                                this.logger.info("No tasks found in executionplan - no additional packages installed.");
                            }
                            writer.write(String.valueOf(plan.hashCode()));
                            writer.newLine();
                        }
                        break block13;
                    }
                }
            }
            this.logger.info("No executionplans configured skipping init.");
        }
    }

    @ObjectClassDefinition(name="Executionplan based Repository Initializer")
    static @interface Config {
        @AttributeDefinition
        public String statusfilepath() default "";

        @AttributeDefinition
        public String[] executionplans() default {};
    }
}

