/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.oak.server.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Set;
import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.InitialContent;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.commit.JcrConflictHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.WhiteboardIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.aggregate.SimpleNodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.plugins.version.VersionHook;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.WhiteboardEditorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.WhiteboardIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.sling.jcr.base.AbstractSlingRepository2;
import org.apache.sling.jcr.base.AbstractSlingRepositoryManager;
import org.apache.sling.jcr.oak.server.internal.OakSlingRepository;
import org.apache.sling.jcr.oak.server.internal.OakSlingRepositoryManagerConfiguration;
import org.apache.sling.jcr.oak.server.internal.TcclWrappingJackrabbitRepository;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;

@Component(property={"service.description=Apache Sling JCR Oak Repository Manager", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=OakSlingRepositoryManagerConfiguration.class)
public class OakSlingRepositoryManager
extends AbstractSlingRepositoryManager {
    @Reference
    private ServiceUserMapper serviceUserMapper;
    @Reference
    private NodeStore nodeStore;
    private ComponentContext componentContext;
    private final WhiteboardEditorProvider editorProvider = new WhiteboardEditorProvider();
    private final WhiteboardIndexProvider indexProvider = new WhiteboardIndexProvider();
    private final WhiteboardIndexEditorProvider indexEditorProvider = new WhiteboardIndexEditorProvider();
    private Tracker<RepositoryInitializer> initializers;
    private CommitRateLimiter commitRateLimiter;
    private OakSlingRepositoryManagerConfiguration configuration;
    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private SecurityProvider securityProvider;
    private ServiceRegistration<QueryIndex.NodeAggregator> nodeAggregatorRegistration;

    protected ServiceUserMapper getServiceUserMapper() {
        return this.serviceUserMapper;
    }

    protected Repository acquireRepository() {
        BundleContext bundleContext = this.componentContext.getBundleContext();
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
        this.initializers = whiteboard.track(RepositoryInitializer.class);
        this.editorProvider.start((Whiteboard)whiteboard);
        this.indexProvider.start((Whiteboard)whiteboard);
        this.indexEditorProvider.start((Whiteboard)whiteboard);
        Oak oak = new Oak(this.nodeStore).withAsyncIndexing("async", 5L);
        Jcr jcr = new Jcr(oak, false).with((RepositoryInitializer)new InitialContent()).with((RepositoryInitializer)new ExtraSlingContent()).with((ThreeWayConflictHandler)JcrConflictHandler.createJcrConflictHandler()).with((CommitHook)new VersionHook()).with((Whiteboard)whiteboard).with(this.securityProvider).with((EditorProvider)this.editorProvider).with((QueryIndexProvider)this.indexProvider).with((IndexEditorProvider)this.indexEditorProvider).with(this.getDefaultWorkspace()).withFastQueryResultSize(this.configuration.oak_query_fastResultSize()).withObservationQueueLength(this.configuration.oak_observation_queue_length());
        for (RepositoryInitializer initializer : this.initializers.getServices()) {
            jcr.with(initializer);
        }
        if (this.commitRateLimiter != null) {
            jcr.with(this.commitRateLimiter);
        }
        jcr.createContentRepository();
        return new TcclWrappingJackrabbitRepository((JackrabbitRepository)jcr.createRepository());
    }

    protected Dictionary<String, Object> getServiceRegistrationProperties() {
        return this.componentContext.getProperties();
    }

    protected AbstractSlingRepository2 create(Bundle usingBundle) {
        String adminId = this.getAdminId();
        return new OakSlingRepository(this, usingBundle, adminId);
    }

    protected void destroy(AbstractSlingRepository2 repositoryServiceInstance) {
    }

    protected void disposeRepository(Repository repository) {
        this.initializers.stop();
        this.indexProvider.stop();
        this.indexEditorProvider.stop();
        this.editorProvider.stop();
        ((JackrabbitRepository)repository).shutdown();
    }

    @Activate
    private void activate(OakSlingRepositoryManagerConfiguration configuration, ComponentContext componentContext) {
        boolean disableLoginAdministrative;
        this.configuration = configuration;
        this.componentContext = componentContext;
        BundleContext bundleContext = componentContext.getBundleContext();
        String defaultWorkspace = configuration.defaultWorkspace();
        boolean bl = disableLoginAdministrative = !configuration.admin_login_enabled();
        if (configuration.oak_observation_limitCommitRate()) {
            this.commitRateLimiter = new CommitRateLimiter();
        }
        this.nodeAggregatorRegistration = bundleContext.registerService(QueryIndex.NodeAggregator.class, (Object)OakSlingRepositoryManager.getNodeAggregator(), null);
        super.start(bundleContext, new AbstractSlingRepositoryManager.Config(defaultWorkspace, disableLoginAdministrative));
    }

    @Deactivate
    private void deactivate() {
        super.stop();
        this.componentContext = null;
        this.nodeAggregatorRegistration.unregister();
    }

    private String getAdminId() {
        return (String)((UserConfiguration)this.securityProvider.getConfiguration(UserConfiguration.class)).getParameters().getConfigValue("adminId", (Object)"admin");
    }

    private static QueryIndex.NodeAggregator getNodeAggregator() {
        return new SimpleNodeAggregator().newRuleWithName("nt:file", Collections.singletonList("jcr:content"));
    }

    private static final class ExtraSlingContent
    implements RepositoryInitializer {
        private ExtraSlingContent() {
        }

        public void initialize(NodeBuilder root) {
            if (root.hasChildNode("oak:index")) {
                NodeBuilder index = root.child("oak:index");
                ExtraSlingContent.property(index, "jcrLanguage", "jcr:language");
                ExtraSlingContent.property(index, "jcrLockOwner", "jcr:lockOwner");
                ExtraSlingContent.property(index, "slingAlias", "sling:alias");
                ExtraSlingContent.property(index, "slingResource", "sling:resource");
                ExtraSlingContent.property(index, "slingResourceType", "sling:resourceType");
                ExtraSlingContent.property(index, "slingVanityPath", "sling:vanityPath");
                ExtraSlingContent.property(index, "event.job.topic", "event.job.topic");
                ExtraSlingContent.property(index, "slingeventEventId", "slingevent:eventId");
                ExtraSlingContent.property(index, "extensionType", "extensionType");
                ExtraSlingContent.property(index, "lockCreated", "lock.created");
                ExtraSlingContent.property(index, "status", "status");
                ExtraSlingContent.property(index, "type", "type");
                if (!index.hasChildNode("lucene")) {
                    LuceneIndexHelper.newLuceneIndexDefinition(index, "lucene", LuceneIndexHelper.JR_PROPERTY_INCLUDES, (Set<String>)ImmutableSet.of((Object)"jcr:createdBy", (Object)"jcr:lastModifiedBy", (Object)"sling:alias", (Object)"sling:resourceType", (Object)"sling:vanityPath"), "async");
                }
            }
        }

        private static void property(NodeBuilder index, String indexName, String propertyName) {
            if (!index.hasChildNode(indexName)) {
                IndexUtils.createIndexDefinition((NodeBuilder)index, (String)indexName, (boolean)true, (boolean)false, Collections.singleton(propertyName), null);
            }
        }
    }
}

