/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jackrabbit.usermanager.DeleteAuthorizables;
import org.apache.sling.jackrabbit.usermanager.DeleteGroup;
import org.apache.sling.jackrabbit.usermanager.DeleteUser;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractPostServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={Servlet.class, DeleteUser.class, DeleteGroup.class, DeleteAuthorizables.class}, property={"sling.servlet.resourceTypes=sling/user", "sling.servlet.resourceTypes=sling/group", "sling.servlet.resourceTypes=sling/userManager", "sling.servlet.methods=POST", "sling.servlet.selectors=delete"})
public class DeleteAuthorizableServlet
extends AbstractPostServlet
implements DeleteUser,
DeleteGroup,
DeleteAuthorizables {
    private static final long serialVersionUID = 5874621724096106496L;

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        Resource resource = request.getResource();
        String[] applyTo = request.getParameterValues(":applyTo");
        if (applyTo != null) {
            this.deleteAuthorizables(session, resource, applyTo, changes);
        } else {
            Authorizable item = (Authorizable)resource.adaptTo(Authorizable.class);
            if (item == null) {
                String msg = "Missing source " + resource.getPath() + " for delete";
                response.setStatus(404, msg);
                throw new ResourceNotFoundException(msg);
            }
            if (item instanceof User) {
                this.deleteUser(session, item.getID(), changes);
            } else if (item instanceof Group) {
                this.deleteGroup(session, item.getID(), changes);
            }
        }
    }

    @Override
    public void deleteUser(Session jcrSession, String name, List<Modification> changes) throws RepositoryException {
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof User)) {
            throw new ResourceNotFoundException("User to delete could not be determined");
        }
        User user = (User)authorizable;
        String userPath = "/system/userManager/user/" + user.getID();
        user.remove();
        changes.add(Modification.onDeleted((String)userPath));
    }

    @Override
    public void deleteGroup(Session jcrSession, String name, List<Modification> changes) throws RepositoryException {
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof Group)) {
            throw new ResourceNotFoundException("Group to delete could not be determined");
        }
        Group group = (Group)authorizable;
        String groupPath = "/system/userManager/group/" + group.getID();
        group.remove();
        changes.add(Modification.onDeleted((String)groupPath));
    }

    @Override
    public void deleteAuthorizables(Session jcrSession, Resource baseResource, String[] paths, List<Modification> changes) throws RepositoryException {
        ApplyToIterator iterator = new ApplyToIterator(baseResource, paths);
        while (iterator.hasNext()) {
            Resource resource = iterator.next();
            Authorizable item = (Authorizable)resource.adaptTo(Authorizable.class);
            if (item == null) continue;
            item.remove();
            changes.add(Modification.onDeleted((String)resource.getPath()));
        }
    }

    private static class ApplyToIterator
    implements Iterator<Resource> {
        private final ResourceResolver resolver;
        private final Resource baseResource;
        private final String[] paths;
        private int pathIndex;
        private Resource nextResource;

        ApplyToIterator(Resource baseResource, String[] paths) {
            this.resolver = baseResource.getResourceResolver();
            this.baseResource = baseResource;
            this.paths = paths;
            this.pathIndex = 0;
            this.nextResource = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.nextResource != null;
        }

        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Resource result = this.nextResource;
            this.nextResource = this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Resource seek() {
            while (this.pathIndex < this.paths.length) {
                String path = this.paths[this.pathIndex];
                ++this.pathIndex;
                Resource res = this.resolver.getResource(this.baseResource, path);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    }
}

