/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AdapterFactory.class}, property={"adapters=org.apache.jackrabbit.api.security.user.User", "adapters=org.apache.jackrabbit.api.security.user.Authorizable", "adaptables=org.apache.sling.api.resource.ResourceResolver"})
public class AuthorizableAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Session session = (Session)((ResourceResolver)adaptable).adaptTo(Session.class);
        if (session instanceof JackrabbitSession) {
            JackrabbitSession jackrabbitSession = (JackrabbitSession)session;
            try {
                UserManager um = jackrabbitSession.getUserManager();
                Authorizable authorizable = um.getAuthorizable(jackrabbitSession.getUserID());
                return type.cast(authorizable);
            }
            catch (RepositoryException e) {
                this.log.warn("User cannot read own authorizable.", (Throwable)e);
            }
        }
        return null;
    }
}

