/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jackrabbit.usermanager.UpdateUser;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractAuthorizablePostServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={Servlet.class, UpdateUser.class}, property={"sling.servlet.resourceTypes=sling/user", "sling.servlet.methods=POST", "sling.servlet.selectors=update", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
public class UpdateUserServlet
extends AbstractAuthorizablePostServlet
implements UpdateUser {
    private static final long serialVersionUID = 5874621724096106496L;

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        Resource resource = request.getResource();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.updateUser(session, resource.getName(), (Map<String, ?>)request.getRequestParameterMap(), changes);
    }

    @Override
    public User updateUser(Session jcrSession, String name, Map<String, ?> properties, List<Modification> changes) throws RepositoryException {
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof User)) {
            throw new ResourceNotFoundException("User to update could not be determined");
        }
        User user = (User)authorizable;
        Collection<RequestProperty> reqProperties = this.collectContent(properties);
        try {
            this.processDeletes((Authorizable)user, reqProperties, changes);
            this.writeContent(jcrSession, (Authorizable)user, reqProperties, changes);
            String disabledParam = this.convertToString(properties.get(":disabled"));
            if ("true".equalsIgnoreCase(disabledParam)) {
                String disabledReason = this.convertToString(properties.get(":disabledReason"));
                if (disabledReason == null) {
                    disabledReason = "";
                }
                user.disable(disabledReason);
            } else if ("false".equalsIgnoreCase(disabledParam)) {
                user.disable(null);
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to update user.", (Throwable)re);
        }
        return user;
    }
}

