/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jackrabbit.usermanager.UpdateGroup;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractGroupPostServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class, UpdateGroup.class}, property={"sling.servlet.resourceTypes=sling/group", "sling.servlet.methods=POST", "sling.servlet.selectors=update", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
public class UpdateGroupServlet
extends AbstractGroupPostServlet
implements UpdateGroup {
    private static final long serialVersionUID = -8292054361992488797L;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        Resource resource = request.getResource();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.updateGroup(session, resource.getName(), (Map<String, ?>)request.getRequestParameterMap(), changes);
    }

    @Override
    public Group updateGroup(Session jcrSession, String name, Map<String, ?> properties, List<Modification> changes) throws RepositoryException {
        Group group = null;
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof Group)) {
            throw new ResourceNotFoundException("Group to update could not be determined");
        }
        group = (Group)authorizable;
        String groupPath = "/system/userManager/group/" + group.getID();
        Collection<RequestProperty> reqProperties = this.collectContent(properties);
        try {
            this.processDeletes((Authorizable)group, reqProperties, changes);
            this.writeContent(jcrSession, (Authorizable)group, reqProperties, changes);
            try (ResourceResolver resourceResolver = null;){
                HashMap<String, Session> authInfo = new HashMap<String, Session>();
                authInfo.put("user.jcr.session", jcrSession);
                resourceResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
                Resource baseResource = resourceResolver.getResource(groupPath);
                this.updateGroupMembership(baseResource, properties, (Authorizable)group, changes);
            }
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to update group.", (Throwable)re);
        }
        return group;
    }
}

