/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jackrabbit.usermanager.CreateGroup;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractGroupPostServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class, CreateGroup.class}, property={"sling.servlet.resourceTypes=sling/groups", "sling.servlet.methods=POST", "sling.servlet.selectors=create", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
public class CreateGroupServlet
extends AbstractGroupPostServlet
implements CreateGroup {
    private static final long serialVersionUID = -1084915263933901466L;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String principalName = request.getParameter(":name");
        Group group = this.createGroup(session, principalName, (Map<String, ?>)request.getRequestParameterMap(), changes);
        String groupPath = "/system/userManager/group/" + group.getID();
        response.setPath(groupPath);
        response.setLocation(this.externalizePath(request, groupPath));
        response.setParentLocation(this.externalizePath(request, "/system/userManager/group"));
    }

    @Override
    public Group createGroup(Session jcrSession, final String name, Map<String, ?> properties, List<Modification> changes) throws RepositoryException {
        if (jcrSession == null) {
            throw new IllegalArgumentException("JCR Session not found");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Group name was not supplied");
        }
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        Group group = null;
        if (authorizable != null) {
            throw new RepositoryException("A group already exists with the requested name: " + name);
        }
        group = userManager.createGroup(new Principal(){

            @Override
            public String getName() {
                return name;
            }
        });
        String groupPath = "/system/userManager/group/" + group.getID();
        Collection<RequestProperty> reqProperties = this.collectContent(properties);
        changes.add(Modification.onCreated((String)groupPath));
        this.writeContent(jcrSession, (Authorizable)group, reqProperties, changes);
        try (ResourceResolver resourceResolver = null;){
            HashMap<String, Session> authInfo = new HashMap<String, Session>();
            authInfo.put("user.jcr.session", jcrSession);
            resourceResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
            Resource baseResource = resourceResolver.getResource("/system/userManager/group");
            this.updateGroupMembership(baseResource, properties, (Authorizable)group, changes);
        }
        return group;
    }
}

