/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.ChangeUserPassword;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractAuthorizablePostServlet;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, ChangeUserPassword.class}, property={"sling.servlet.resourceTypes=sling/user", "sling.servlet.methods=POST", "sling.servlet.selectors=changePassword", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy", "user.admin.group.name=UserAdmin"})
public class ChangeUserPasswordServlet
extends AbstractAuthorizablePostServlet
implements ChangeUserPassword {
    private static final long serialVersionUID = 1923614318474654502L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String DEFAULT_USER_ADMIN_GROUP_NAME = "UserAdmin";
    static final String PAR_USER_ADMIN_GROUP_NAME = "user.admin.group.name";
    private String userAdminGroupName = "UserAdmin";

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
        this.userAdminGroupName = OsgiUtil.toString((Object)props.get(PAR_USER_ADMIN_GROUP_NAME), (String)DEFAULT_USER_ADMIN_GROUP_NAME);
        this.log.debug("User Admin Group Name {}", (Object)this.userAdminGroupName);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, AbstractPostResponse response, List<Modification> changes) throws RepositoryException {
        Resource resource = request.getResource();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.changePassword(session, resource.getName(), request.getParameter("oldPwd"), request.getParameter("newPwd"), request.getParameter("newPwdConfirm"), changes);
    }

    @Override
    public User changePassword(Session jcrSession, String name, String oldPassword, String newPassword, String newPasswordConfirm, List<Modification> changes) throws RepositoryException {
        if ("anonymous".equals(name)) {
            throw new RepositoryException("Can not change the password of the anonymous user.");
        }
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof User)) {
            throw new ResourceNotFoundException("User to update could not be determined");
        }
        User user = (User)authorizable;
        boolean administrator = false;
        if (oldPassword == null || oldPassword.length() == 0) {
            try {
                boolean isMember;
                Authorizable userAdmin;
                UserManager um = AccessControlUtil.getUserManager((Session)jcrSession);
                User currentUser = (User)um.getAuthorizable(jcrSession.getUserID());
                administrator = currentUser.isAdmin();
                if (!administrator && (userAdmin = um.getAuthorizable(this.userAdminGroupName)) instanceof Group && (isMember = ((Group)userAdmin).isMember((Authorizable)currentUser))) {
                    administrator = true;
                }
            }
            catch (Exception ex) {
                this.log.warn("Failed to determine if the user is an admin, assuming not. Cause: " + ex.getMessage());
                administrator = false;
            }
            if (!administrator) {
                throw new RepositoryException("Old Password was not submitted");
            }
        }
        if (newPassword == null || newPassword.length() == 0) {
            throw new RepositoryException("New Password was not submitted");
        }
        if (!newPassword.equals(newPasswordConfirm)) {
            throw new RepositoryException("New Password does not match the confirmation password");
        }
        try {
            if (oldPassword != null && oldPassword.length() > 0) {
                user.changePassword(newPassword, oldPassword);
            } else {
                user.changePassword(newPassword);
            }
            String passwordPath = "/system/userManager/user/" + user.getID() + "/rep:password";
            changes.add(Modification.onModified((String)passwordPath));
        }
        catch (RepositoryException re) {
            throw new RepositoryException("Failed to change user password.", (Throwable)re);
        }
        return user;
    }
}

