/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.AuthorizablePrivilegesInfo;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthorizablePrivilegesInfo.class}, property={"user.admin.group.name=UserAdmin", "group.admin.group.name=GroupAdmin"})
public class AuthorizablePrivilegesInfoImpl
implements AuthorizablePrivilegesInfo {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String DEFAULT_USER_ADMIN_GROUP_NAME = "UserAdmin";
    static final String PAR_USER_ADMIN_GROUP_NAME = "user.admin.group.name";
    static final String DEFAULT_GROUP_ADMIN_GROUP_NAME = "GroupAdmin";
    static final String PAR_GROUP_ADMIN_GROUP_NAME = "group.admin.group.name";
    private BundleContext bundleContext;

    @Override
    public boolean canAddGroup(Session jcrSession) {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser != null && ((User)currentUser).isAdmin()) {
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can add a new group", (Object)jcrSession.getUserID());
        }
        return false;
    }

    @Override
    public boolean canAddUser(Session jcrSession) {
        try {
            UserManager userManager;
            Authorizable currentUser;
            String filter;
            Collection serviceReferences;
            if (this.bundleContext != null && (serviceReferences = this.bundleContext.getServiceReferences(Servlet.class, filter = "(&(sling.servlet.resourceTypes=sling/users)(|(sling.servlet.methods=POST)(sling.servlet.selectors=create)))")) != null) {
                String propName = "self.registration.enabled";
                for (ServiceReference serviceReference : serviceReferences) {
                    Object propValue = serviceReference.getProperty(propName);
                    if (propValue == null) continue;
                    boolean selfRegEnabled = Boolean.TRUE.equals(propValue);
                    if (!selfRegEnabled) break;
                    return true;
                }
            }
            if ((currentUser = (userManager = AccessControlUtil.getUserManager((Session)jcrSession)).getAuthorizable(jcrSession.getUserID())) != null && ((User)currentUser).isAdmin()) {
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can add a new user", (Object)jcrSession.getUserID());
        }
        catch (InvalidSyntaxException e) {
            this.log.warn("Failed to determine if {} can add a new user", (Object)jcrSession.getUserID());
        }
        return false;
    }

    @Override
    public boolean canRemove(Session jcrSession, String principalId) {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (((User)currentUser).isAdmin()) {
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)principalId);
        }
        return false;
    }

    @Override
    public boolean canUpdateGroupMembers(Session jcrSession, String groupId) {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (((User)currentUser).isAdmin()) {
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)groupId);
        }
        return false;
    }

    @Override
    public boolean canUpdateProperties(Session jcrSession, String principalId) {
        try {
            if (jcrSession.getUserID().equals(principalId)) {
                return true;
            }
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (((User)currentUser).isAdmin()) {
                return true;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)principalId);
        }
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        String groupAdminGroupName;
        this.bundleContext = bundleContext;
        String userAdminGroupName = OsgiUtil.toString((Object)properties.get(PAR_USER_ADMIN_GROUP_NAME), null);
        if (userAdminGroupName != null && !DEFAULT_USER_ADMIN_GROUP_NAME.equals(userAdminGroupName)) {
            this.log.warn("Configuration setting for {} is deprecated and will not have any effect", (Object)PAR_USER_ADMIN_GROUP_NAME);
        }
        if ((groupAdminGroupName = OsgiUtil.toString((Object)properties.get(PAR_GROUP_ADMIN_GROUP_NAME), null)) != null && !DEFAULT_GROUP_ADMIN_GROUP_NAME.equals(userAdminGroupName)) {
            this.log.warn("Configuration setting for {} is deprecated and will not have any effect", (Object)PAR_GROUP_ADMIN_GROUP_NAME);
        }
    }
}

