/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableResource;
import org.apache.sling.jackrabbit.usermanager.impl.resource.NestedAuthorizableResource;
import org.apache.sling.jackrabbit.usermanager.impl.resource.PrincipalResource;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceProvider.class, SystemUserManagerPaths.class}, property={"service.description=Resource provider implementation for UserManager resources", "service.vendor=The Apache Software Foundation", "provider.root=/system/userManager"})
@Designate(ocd=Config.class)
public class AuthorizableResourceProvider
extends ResourceProvider<Object>
implements SystemUserManagerPaths {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String systemUserManagerPath;
    private String systemUserManagerUserPath;
    private String systemUserManagerUserPrefix;
    private String systemUserManagerGroupPath;
    private String systemUserManagerGroupPrefix;
    public static final String DEFAULT_SYSTEM_USER_MANAGER_PATH = "/system/userManager";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_PATH = "/system/userManager";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_USER_PATH = "/system/userManager/user";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_GROUP_PATH = "/system/userManager/group";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_USER_PREFIX = "/system/userManager/user/";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_GROUP_PREFIX = "/system/userManager/group/";
    private boolean resourcesForNestedProperties = true;

    @Activate
    protected void activate(Config config) {
        this.systemUserManagerPath = OsgiUtil.toString((Object)config.provider_root(), (String)"/system/userManager");
        this.systemUserManagerUserPath = String.format("%s/user", this.systemUserManagerPath);
        this.systemUserManagerUserPrefix = String.format("%s/", this.systemUserManagerUserPath);
        this.systemUserManagerGroupPath = String.format("%s/group", this.systemUserManagerPath);
        this.systemUserManagerGroupPrefix = String.format("%s/", this.systemUserManagerGroupPath);
        this.resourcesForNestedProperties = config.resources_for_nested_properties();
    }

    @Override
    public String getRootPath() {
        return this.systemUserManagerPath;
    }

    @Override
    public String getUsersPath() {
        return this.systemUserManagerUserPath;
    }

    @Override
    public String getUserPrefix() {
        return this.systemUserManagerUserPrefix;
    }

    @Override
    public String getGroupsPath() {
        return this.systemUserManagerGroupPath;
    }

    @Override
    public String getGroupPrefix() {
        return this.systemUserManagerGroupPrefix;
    }

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        if (path.equals(this.systemUserManagerPath)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/userManager");
        }
        if (path.equals(this.systemUserManagerUserPath)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/users");
        }
        if (path.equals(this.systemUserManagerGroupPath)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/groups");
        }
        AuthorizableWorker<Resource> authorizableWorker = (authorizable, relPath) -> {
            Iterator<String> propertyNames;
            AuthorizableResource result = null;
            if (relPath == null) {
                result = new AuthorizableResource(authorizable, ctx.getResourceResolver(), path, this);
            } else if (this.resourcesForNestedProperties && (propertyNames = AuthorizableResourceProvider.getPropertyNames(relPath, authorizable)).hasNext()) {
                result = new NestedAuthorizableResource(authorizable, ctx.getResourceResolver(), path, this, relPath);
            }
            return result;
        };
        PrincipalWorker<Resource> principalWorker = principal -> new PrincipalResource(principal, ctx.getResourceResolver(), path);
        return this.maybeDoAuthorizableWork(ctx, path, authorizableWorker, principalWorker);
    }

    protected <T> T maybeDoAuthorizableWork(@NotNull ResolveContext<Object> ctx, @NotNull String path, @NotNull AuthorizableWorker<T> authorizableWorker, @Nullable PrincipalWorker<T> principalWorker) {
        T result = null;
        String suffix = null;
        if (path.startsWith(this.systemUserManagerUserPrefix)) {
            suffix = path.substring(this.systemUserManagerUserPrefix.length());
        } else if (path.startsWith(this.systemUserManagerGroupPrefix)) {
            suffix = path.substring(this.systemUserManagerGroupPrefix.length());
        }
        if (suffix != null) {
            String relPath;
            String pid;
            int firstSlash = suffix.indexOf(47);
            if (firstSlash == -1) {
                pid = suffix;
                relPath = null;
            } else {
                pid = suffix.substring(0, firstSlash);
                relPath = suffix.substring(firstSlash + 1);
            }
            Session session = (Session)ctx.getResourceResolver().adaptTo(Session.class);
            if (session != null) {
                try {
                    UserManager userManager = AccessControlUtil.getUserManager((Session)session);
                    if (userManager != null) {
                        Principal principal;
                        PrincipalManager principalManager;
                        Authorizable authorizable = userManager.getAuthorizable(pid);
                        if (authorizable != null) {
                            result = authorizableWorker.doWork(authorizable, relPath);
                        } else if (principalWorker != null && relPath == null && (principalManager = AccessControlUtil.getPrincipalManager((Session)session)) != null && (principal = principalManager.getPrincipal(pid)) != null) {
                            result = principalWorker.doWork(principal);
                        }
                    }
                }
                catch (RepositoryException re) {
                    throw new SlingException("Error looking up Authorizable for principal: " + pid, (Throwable)re);
                }
            }
        }
        return result;
    }

    protected static Iterator<String> getPropertyNames(String relPath, Authorizable authorizable) {
        Iterator propertyNames;
        try {
            propertyNames = authorizable.getPropertyNames(relPath);
        }
        catch (RepositoryException re) {
            Logger logger = LoggerFactory.getLogger(AuthorizableResourceProvider.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to get property names", (Throwable)re);
            }
            propertyNames = Collections.emptyIterator();
        }
        return propertyNames;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        try {
            String path = parent.getPath();
            if (this.systemUserManagerPath.equals(path)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                resources.add(this.getResource(ctx, this.systemUserManagerUserPath, null, null));
                resources.add(this.getResource(ctx, this.systemUserManagerGroupPath, null, null));
                return resources.iterator();
            }
            int searchType = -1;
            if (this.systemUserManagerUserPath.equals(path)) {
                searchType = 1;
            } else if (this.systemUserManagerGroupPath.equals(path)) {
                searchType = 2;
            }
            if (searchType != -1) {
                PrincipalIterator principals = null;
                ResourceResolver resourceResolver = parent.getResourceResolver();
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (session != null) {
                    PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
                    principals = principalManager.getPrincipals(searchType);
                }
                if (principals != null) {
                    return new ChildrenIterator(parent, principals);
                }
            } else if (this.resourcesForNestedProperties) {
                AuthorizableWorker<Iterator> authorizableWorker = (authorizable, relPath) -> {
                    List<Resource> propContainers;
                    NestedChildrenIterator result = null;
                    Resource r = ctx.getResourceResolver().resolve(authorizable.getPath());
                    if (relPath != null) {
                        r = r.getChild(relPath);
                    }
                    if (r != null && !(propContainers = this.filterPropertyContainers(relPath, authorizable, r)).isEmpty()) {
                        result = new NestedChildrenIterator(parent, authorizable.getID(), r.getChildren().iterator());
                    }
                    return result;
                };
                return this.maybeDoAuthorizableWork(ctx, path, authorizableWorker, null);
            }
        }
        catch (RepositoryException re) {
            throw new SlingException("Error listing children of resource: " + parent.getPath(), (Throwable)re);
        }
        return null;
    }

    protected List<Resource> filterPropertyContainers(String relPath, Authorizable authorizable, Resource r) {
        ArrayList<Resource> propContainers = new ArrayList<Resource>();
        for (Resource cr : r.getChildren()) {
            String childRelPath = relPath == null ? cr.getName() : String.format("%s/%s", relPath, cr.getName());
            if (AuthorizableResourceProvider.getPropertyNames(childRelPath, authorizable).hasNext()) {
                propContainers.add(cr);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("skipping child that is not appear to be a nested property container: {}", (Object)cr.getName());
        }
        return propContainers;
    }

    @ObjectClassDefinition(name="Apache Sling UserManager Resource Provider")
    public static @interface Config {
        @AttributeDefinition(name="Provider Root", description="Specifies the root path for the UserManager resources.")
        public String provider_root() default "/system/userManager";

        @AttributeDefinition(name="Provide Resources For Nested Properties", description="Specifies whether container resources are provided for any nested authorizable properties. The resourceType for these ancestor resources would be 'sling/[user|group]/properties'")
        public boolean resources_for_nested_properties() default false;
    }

    protected static interface AuthorizableWorker<T> {
        public T doWork(@NotNull Authorizable var1, @Nullable String var2) throws RepositoryException;
    }

    protected static interface PrincipalWorker<T> {
        public T doWork(@NotNull Principal var1) throws RepositoryException;
    }

    private final class ChildrenIterator
    extends BaseChildrenIterator {
        public ChildrenIterator(Resource parent, PrincipalIterator principals) {
            super(parent, (Iterator<?>)principals);
        }

        @Override
        protected String toPrincipalName(Object child) {
            String principalName = null;
            if (child instanceof Principal) {
                principalName = ((Principal)child).getName();
            }
            return principalName;
        }

        @Override
        @Nullable
        protected Resource createNext(Object child, String principalName, ResourceResolver resourceResolver, Session session) throws RepositoryException {
            Principal principal;
            PrincipalManager principalManager;
            @Nullable Resource next = super.createNext(child, principalName, resourceResolver, session);
            if (next == null && (principalManager = AccessControlUtil.getPrincipalManager((Session)session)) != null && (principal = principalManager.getPrincipal(principalName)) != null) {
                String path = principal instanceof GroupPrincipal ? AuthorizableResourceProvider.this.systemUserManagerGroupPrefix + principalName : AuthorizableResourceProvider.this.systemUserManagerUserPrefix + principalName;
                return new PrincipalResource(principal, resourceResolver, path);
            }
            return next;
        }

        @Override
        protected Resource createNext(Object child, ResourceResolver resourceResolver, Authorizable authorizable, String path) throws RepositoryException {
            return new AuthorizableResource(authorizable, resourceResolver, path, AuthorizableResourceProvider.this);
        }
    }

    private final class NestedChildrenIterator
    extends BaseChildrenIterator {
        private String principalName;

        private NestedChildrenIterator(Resource parent, String principalName, Iterator<Resource> children) {
            super(parent, children);
            this.principalName = principalName;
        }

        @Override
        protected String toPrincipalName(Object child) {
            return this.principalName;
        }

        @Override
        protected Resource createNext(Object child, ResourceResolver resourceResolver, Authorizable authorizable, String path) throws RepositoryException {
            Resource childResource;
            String relPath;
            Iterator<String> propertyNames;
            NestedAuthorizableResource next = null;
            if (child instanceof Resource && (propertyNames = AuthorizableResourceProvider.getPropertyNames(relPath = (childResource = (Resource)child).getPath().substring(authorizable.getPath().length() + 1), authorizable)).hasNext()) {
                next = new NestedAuthorizableResource(authorizable, resourceResolver, String.format("%s/%s", path, relPath), AuthorizableResourceProvider.this, relPath);
            }
            return next;
        }
    }

    private abstract class BaseChildrenIterator
    implements Iterator<Resource> {
        private Resource parent;
        private Iterator<?> children;

        private BaseChildrenIterator(Resource parent, Iterator<?> children) {
            this.parent = parent;
            this.children = children;
        }

        @Override
        public boolean hasNext() {
            return this.children.hasNext();
        }

        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Resource next = null;
            Object child = this.children.next();
            String principalName = this.toPrincipalName(child);
            try {
                ResourceResolver resourceResolver = this.parent.getResourceResolver();
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (session != null) {
                    next = this.createNext(child, principalName, resourceResolver, session);
                }
            }
            catch (RepositoryException re) {
                AuthorizableResourceProvider.this.log.error("Exception while looking up authorizable resource.", (Throwable)re);
            }
            return next;
        }

        @Nullable
        protected Resource createNext(Object child, String principalName, ResourceResolver resourceResolver, Session session) throws RepositoryException {
            Authorizable authorizable;
            Resource next = null;
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            if (userManager != null && (authorizable = userManager.getAuthorizable(principalName)) != null) {
                String path = authorizable.isGroup() ? AuthorizableResourceProvider.this.systemUserManagerGroupPrefix + principalName : AuthorizableResourceProvider.this.systemUserManagerUserPrefix + principalName;
                next = this.createNext(child, resourceResolver, authorizable, path);
            }
            return next;
        }

        protected abstract String toPrincipalName(Object var1);

        protected abstract Resource createNext(Object var1, ResourceResolver var2, Authorizable var3, String var4) throws RepositoryException;
    }
}

