/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.jackrabbit.usermanager.CreateUser;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameFilter;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameGenerator;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractAuthorizablePostServlet;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, CreateUser.class}, property={"sling.servlet.resourceTypes=sling/users", "sling.servlet.methods=POST", "sling.servlet.selectors=create", "sling.servlet.prefix:Integer=-1", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
@Designate(ocd=Config.class)
public class CreateUserServlet
extends AbstractAuthorizablePostServlet
implements CreateUser {
    private static final long serialVersionUID = 6871481922737658675L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean selfRegistrationEnabled;
    @Reference
    private transient SlingRepository repository;
    @Reference
    private transient ServiceUserMapped serviceUserMapped;
    private String usersPath;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private void bindUserConfiguration(UserConfiguration userConfig, Map<String, Object> properties) {
        this.usersPath = (String)properties.get("usersPath");
    }

    private void unbindUserConfiguration(UserConfiguration userConfig, Map<String, Object> properties) {
        this.usersPath = null;
    }

    private Session getSession() throws RepositoryException {
        return this.repository.loginService(null, null);
    }

    private void ungetSession(Session session) {
        if (session != null) {
            try {
                session.logout();
            }
            catch (Exception t) {
                this.log.error(String.format("Unable to log out of session: %s", t.getMessage()), (Throwable)t);
            }
        }
    }

    @Activate
    protected void activate(Config config, Map<String, Object> props) {
        super.activate(props);
        this.selfRegistrationEnabled = config.self_registration_enabled();
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this.selfRegistrationEnabled = false;
        super.deactivate();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPrincipalNameGenerator(PrincipalNameGenerator generator, Map<String, Object> properties) {
        super.bindPrincipalNameGenerator(generator, properties);
    }

    @Override
    protected void unbindPrincipalNameGenerator(PrincipalNameGenerator generator) {
        super.unbindPrincipalNameGenerator(generator);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindPrincipalNameFilter(PrincipalNameFilter filter) {
        super.bindPrincipalNameFilter(filter);
    }

    @Override
    protected void unbindPrincipalNameFilter(PrincipalNameFilter filter) {
        super.unbindPrincipalNameFilter(filter);
    }

    @Override
    @Reference
    protected void bindSystemUserManagerPaths(SystemUserManagerPaths sump) {
        super.bindSystemUserManagerPaths(sump);
    }

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String principalName = request.getParameter(":name");
        User user = this.createUser(session, principalName, request.getParameter("pwd"), request.getParameter("pwdConfirm"), (Map<String, ?>)request.getRequestParameterMap(), changes);
        Object userPath = null;
        if (user == null) {
            Modification modification;
            if (!changes.isEmpty() && (modification = changes.get(0)).getType() == ModificationType.CREATE) {
                userPath = modification.getSource();
            }
        } else {
            userPath = this.systemUserManagerPaths.getUserPrefix() + user.getID();
        }
        if (userPath != null) {
            response.setPath((String)userPath);
            response.setLocation(this.externalizePath(request, (String)userPath));
        }
        response.setParentLocation(this.externalizePath(request, this.systemUserManagerPaths.getUsersPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(Session jcrSession, String name, String password, String passwordConfirm, Map<String, ?> properties, List<Modification> changes) throws RepositoryException {
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        String principalName = name == null || name.isEmpty() ? this.getOrGeneratePrincipalName(jcrSession, properties, AuthorizableType.USER) : name;
        boolean administrator = false;
        try {
            UserManager um = AccessControlUtil.getUserManager((Session)jcrSession);
            User currentUser = (User)um.getAuthorizable(jcrSession.getUserID());
            administrator = currentUser.isAdmin();
            if (!administrator && this.usersPath != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                administrator = acm.hasPrivileges(this.usersPath, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
            }
        }
        catch (Exception ex) {
            this.log.warn("Failed to determine if the user is an admin, assuming not. Cause: {}", (Object)ex.getMessage());
            administrator = false;
        }
        if (!administrator && !this.selfRegistrationEnabled) {
            throw new RepositoryException("Sorry, registration of new users is not currently enabled.  Please try again later.");
        }
        if (principalName == null || principalName.length() == 0) {
            throw new RepositoryException("User name was not submitted");
        }
        if (password == null) {
            throw new RepositoryException("Password was not submitted");
        }
        if (!password.equals(passwordConfirm)) {
            throw new RepositoryException("Password value does not match the confirmation password");
        }
        Object user = null;
        Session selfRegSession = jcrSession;
        boolean useAdminSession = !administrator && this.selfRegistrationEnabled;
        try {
            UserManager userManager;
            Authorizable authorizable;
            if (useAdminSession) {
                selfRegSession = this.getSession();
            }
            if ((authorizable = (userManager = AccessControlUtil.getUserManager((Session)selfRegSession)).getAuthorizable(principalName)) != null) {
                throw new RepositoryException("A principal already exists with the requested name: " + principalName);
            }
            user = userManager.createUser(principalName, password);
            String userPath = this.systemUserManagerPaths.getUserPrefix() + user.getID();
            Map<String, RequestProperty> reqPropertiesMap = this.collectContentMap(properties);
            Collection<RequestProperty> reqPropertyValues = reqPropertiesMap.values();
            changes.add(Modification.onCreated((String)userPath));
            this.processCreate(selfRegSession, (Authorizable)user, reqPropertiesMap, changes);
            this.writeContent(selfRegSession, (Authorizable)user, reqPropertyValues, changes);
            if (selfRegSession.hasPendingChanges()) {
                selfRegSession.save();
            }
            if (useAdminSession) {
                UserManager userManager2 = AccessControlUtil.getUserManager((Session)jcrSession);
                Authorizable authorizable2 = userManager2.getAuthorizable(user.getID());
                user = authorizable2 instanceof User ? (User)authorizable2 : null;
            }
        }
        finally {
            if (useAdminSession) {
                this.ungetSession(selfRegSession);
            }
        }
        return user;
    }

    @ObjectClassDefinition(name="Apache Sling Create User", description="The Sling operation to handle create user requests in Sling.")
    public static @interface Config {
        @AttributeDefinition(name="Self-Registration Enabled", description="When selected, the anonymous user is allowed to register a new user with the system.")
        public boolean self_registration_enabled() default false;
    }
}

