/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jackrabbit.usermanager.CreateGroup;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameFilter;
import org.apache.sling.jackrabbit.usermanager.PrincipalNameGenerator;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractGroupPostServlet;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Servlet.class, CreateGroup.class}, property={"sling.servlet.resourceTypes=sling/groups", "sling.servlet.methods=POST", "sling.servlet.selectors=create", "sling.servlet.prefix:Integer=-1", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
public class CreateGroupServlet
extends AbstractGroupPostServlet
implements CreateGroup {
    private static final long serialVersionUID = -1084915263933901466L;
    @Reference
    private transient ResourceResolverFactory resourceResolverFactory;

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPrincipalNameGenerator(PrincipalNameGenerator generator, Map<String, Object> properties) {
        super.bindPrincipalNameGenerator(generator, properties);
    }

    @Override
    protected void unbindPrincipalNameGenerator(PrincipalNameGenerator generator) {
        super.unbindPrincipalNameGenerator(generator);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindPrincipalNameFilter(PrincipalNameFilter filter) {
        super.bindPrincipalNameFilter(filter);
    }

    @Override
    protected void unbindPrincipalNameFilter(PrincipalNameFilter filter) {
        super.unbindPrincipalNameFilter(filter);
    }

    @Override
    @Reference
    protected void bindSystemUserManagerPaths(SystemUserManagerPaths sump) {
        super.bindSystemUserManagerPaths(sump);
    }

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String principalName = request.getParameter(":name");
        Group group = this.createGroup(session, principalName, (Map<String, ?>)request.getRequestParameterMap(), changes);
        String groupPath = this.systemUserManagerPaths.getGroupPrefix() + group.getID();
        response.setPath(groupPath);
        response.setLocation(this.externalizePath(request, groupPath));
        response.setParentLocation(this.externalizePath(request, this.systemUserManagerPaths.getGroupsPath()));
    }

    @Override
    public Group createGroup(Session jcrSession, String name, Map<String, ?> properties, List<Modification> changes) throws RepositoryException {
        if (jcrSession == null) {
            throw new IllegalArgumentException("JCR Session not found");
        }
        String principalName = name == null || name.isEmpty() ? this.getOrGeneratePrincipalName(jcrSession, properties, AuthorizableType.GROUP) : name;
        if (principalName == null || principalName.length() == 0) {
            throw new IllegalArgumentException("Group name was not supplied");
        }
        UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        Authorizable authorizable = userManager.getAuthorizable(principalName);
        Group group = null;
        if (authorizable != null) {
            throw new RepositoryException("A group already exists with the requested name: " + principalName);
        }
        group = userManager.createGroup(() -> principalName);
        String groupPath = this.systemUserManagerPaths.getGroupPrefix() + group.getID();
        Map<String, RequestProperty> reqPropertiesMap = this.collectContentMap(properties);
        Collection<RequestProperty> reqPropertyValues = reqPropertiesMap.values();
        changes.add(Modification.onCreated((String)groupPath));
        this.processCreate(jcrSession, (Authorizable)group, reqPropertiesMap, changes);
        this.writeContent(jcrSession, (Authorizable)group, reqPropertyValues, changes);
        try (ResourceResolver resourceResolver = null;){
            HashMap<String, Session> authInfo = new HashMap<String, Session>();
            authInfo.put("user.jcr.session", jcrSession);
            resourceResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
            Resource baseResource = resourceResolver.getResource(this.systemUserManagerPaths.getGroupsPath());
            this.updateGroupMembership(baseResource, properties, (Authorizable)group, changes);
        }
        return group;
    }
}

