/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableResource;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceProvider.class, SystemUserManagerPaths.class}, property={"service.description=Resource provider implementation for UserManager resources", "service.vendor=The Apache Software Foundation", "provider.root=/system/userManager"})
@Designate(ocd=Config.class)
public class AuthorizableResourceProvider
extends ResourceProvider<Object>
implements SystemUserManagerPaths {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String systemUserManagerPath;
    private String systemUserManagerUserPath;
    private String systemUserManagerUserPrefix;
    private String systemUserManagerGroupPath;
    private String systemUserManagerGroupPrefix;
    public static final String DEFAULT_SYSTEM_USER_MANAGER_PATH = "/system/userManager";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_PATH = "/system/userManager";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_USER_PATH = "/system/userManager/user";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_GROUP_PATH = "/system/userManager/group";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_USER_PREFIX = "/system/userManager/user/";
    @Deprecated
    public static final String SYSTEM_USER_MANAGER_GROUP_PREFIX = "/system/userManager/group/";

    @Activate
    protected void activate(Map<String, Object> props) {
        this.systemUserManagerPath = OsgiUtil.toString((Object)props.get("provider.root"), (String)"/system/userManager");
        this.systemUserManagerUserPath = String.format("%s/user", this.systemUserManagerPath);
        this.systemUserManagerUserPrefix = String.format("%s/", this.systemUserManagerUserPath);
        this.systemUserManagerGroupPath = String.format("%s/group", this.systemUserManagerPath);
        this.systemUserManagerGroupPrefix = String.format("%s/", this.systemUserManagerGroupPath);
    }

    @Override
    public String getRootPath() {
        return this.systemUserManagerPath;
    }

    @Override
    public String getUsersPath() {
        return this.systemUserManagerUserPath;
    }

    @Override
    public String getUserPrefix() {
        return this.systemUserManagerUserPrefix;
    }

    @Override
    public String getGroupsPath() {
        return this.systemUserManagerGroupPath;
    }

    @Override
    public String getGroupPrefix() {
        return this.systemUserManagerGroupPrefix;
    }

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        if (path.equals(this.systemUserManagerPath)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/userManager");
        }
        if (path.equals(this.systemUserManagerUserPath)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/users");
        }
        if (path.equals(this.systemUserManagerGroupPath)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/groups");
        }
        String pid = null;
        if (path.startsWith(this.systemUserManagerUserPrefix)) {
            pid = path.substring(this.systemUserManagerUserPrefix.length());
        } else if (path.startsWith(this.systemUserManagerGroupPrefix)) {
            pid = path.substring(this.systemUserManagerGroupPrefix.length());
        }
        if (pid != null) {
            if (pid.indexOf(47) != -1) {
                return null;
            }
            try {
                Authorizable authorizable;
                UserManager userManager;
                Session session = (Session)ctx.getResourceResolver().adaptTo(Session.class);
                if (session != null && (userManager = AccessControlUtil.getUserManager((Session)session)) != null && (authorizable = userManager.getAuthorizable(pid)) != null) {
                    return new AuthorizableResource(authorizable, ctx.getResourceResolver(), path, this);
                }
            }
            catch (RepositoryException re) {
                throw new SlingException("Error looking up Authorizable for principal: " + pid, (Throwable)re);
            }
        }
        return null;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        try {
            String path = parent.getPath();
            if (this.systemUserManagerPath.equals(path)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                resources.add(this.getResource(ctx, this.systemUserManagerUserPath, null, null));
                resources.add(this.getResource(ctx, this.systemUserManagerGroupPath, null, null));
                return resources.iterator();
            }
            int searchType = -1;
            if (this.systemUserManagerUserPath.equals(path)) {
                searchType = 1;
            } else if (this.systemUserManagerGroupPath.equals(path)) {
                searchType = 2;
            }
            if (searchType != -1) {
                PrincipalIterator principals = null;
                ResourceResolver resourceResolver = parent.getResourceResolver();
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (session != null) {
                    PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
                    principals = principalManager.getPrincipals(searchType);
                }
                if (principals != null) {
                    return new ChildrenIterator(parent, principals);
                }
            }
        }
        catch (RepositoryException re) {
            throw new SlingException("Error listing children of resource: " + parent.getPath(), (Throwable)re);
        }
        return null;
    }

    private final class ChildrenIterator
    implements Iterator<Resource> {
        private PrincipalIterator principals;
        private Resource parent;

        public ChildrenIterator(Resource parent, PrincipalIterator principals) {
            this.parent = parent;
            this.principals = principals;
        }

        @Override
        public boolean hasNext() {
            return this.principals.hasNext();
        }

        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Principal nextPrincipal = this.principals.nextPrincipal();
            try {
                Authorizable authorizable;
                UserManager userManager;
                ResourceResolver resourceResolver = this.parent.getResourceResolver();
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (session != null && (userManager = AccessControlUtil.getUserManager((Session)session)) != null && (authorizable = userManager.getAuthorizable(nextPrincipal.getName())) != null) {
                    String path = authorizable.isGroup() ? AuthorizableResourceProvider.this.systemUserManagerGroupPrefix + nextPrincipal.getName() : AuthorizableResourceProvider.this.systemUserManagerUserPrefix + nextPrincipal.getName();
                    return new AuthorizableResource(authorizable, resourceResolver, path, AuthorizableResourceProvider.this);
                }
            }
            catch (RepositoryException re) {
                AuthorizableResourceProvider.this.log.error("Exception while looking up authorizable resource.", (Throwable)re);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @ObjectClassDefinition(name="Apache Sling UserManager Resource Provider")
    public static @interface Config {
        @AttributeDefinition(name="Provider Root", description="Specifies the root path for the UserManager resources.")
        public String provider_root() default "/system/userManager";
    }
}

