/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractPostServlet;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizablePostServlet
extends AbstractPostServlet {
    private static final long serialVersionUID = -5918670409789895333L;
    public static final String PROP_DATE_FORMAT = "servlet.post.dateFormats";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAuthorizablePostServlet.class);
    private transient DateParser dateParser;
    protected transient SystemUserManagerPaths systemUserManagerPaths;

    protected void bindSystemUserManagerPaths(SystemUserManagerPaths sump) {
        this.systemUserManagerPaths = sump;
    }

    protected void activate(Map<String, Object> props) {
        String[] dateFormats;
        this.dateParser = new DateParser();
        for (String dateFormat : dateFormats = OsgiUtil.toStringArray((Object)props.get(PROP_DATE_FORMAT))) {
            this.dateParser.register(dateFormat);
        }
    }

    protected void deactivate() {
        this.dateParser = null;
    }

    protected Collection<RequestProperty> collectContent(Map<String, ?> properties) {
        boolean requireItemPrefix = this.requireItemPathPrefix(properties);
        HashMap<String, RequestProperty> reqProperties = new HashMap<String, RequestProperty>();
        for (Map.Entry<String, ?> e : properties.entrySet()) {
            RequestProperty prop;
            String propPath;
            String paramName = e.getKey();
            boolean skipParam = paramName.startsWith(":");
            if (paramName.equals("_charset_")) {
                skipParam = true;
            }
            if (requireItemPrefix && !this.hasItemPathPrefix(paramName)) {
                skipParam = true;
            }
            if ((propPath = paramName.startsWith("./") ? paramName.substring(1) : String.format("/%s", paramName)).indexOf("..") != -1) {
                LOG.warn("Property path containing '..' is not supported, skipping parameter {}", (Object)paramName);
                skipParam = true;
            }
            if (skipParam) continue;
            if (propPath.endsWith("@TypeHint")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@TypeHint");
                String typeHintValue = this.convertToString(e.getValue());
                if (typeHintValue == null) continue;
                prop.setTypeHintValue(typeHintValue);
                continue;
            }
            if (propPath.endsWith("@DefaultValue")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@DefaultValue");
                prop.setDefaultValues(this.convertToRequestParameterArray(e.getValue()));
                continue;
            }
            if (propPath.endsWith("@ValueFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@ValueFrom");
                String[] valueFrom = this.convertToStringArray(e.getValue());
                if (valueFrom.length != 1) continue;
                String refName = valueFrom[0];
                prop.setValues(this.convertToRequestParameterArray(refName));
                continue;
            }
            if (propPath.endsWith("@Delete")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Delete");
                prop.setDelete(true);
                continue;
            }
            if (propPath.endsWith("@MoveFrom")) {
                LOG.warn("Suffix {} not supported, skipping parameter {}", (Object)"@MoveFrom", (Object)paramName);
                continue;
            }
            if (propPath.endsWith("@CopyFrom")) {
                LOG.warn("Suffix {} not supported, skipping parameter {}", (Object)"@CopyFrom", (Object)paramName);
                continue;
            }
            prop = this.getOrCreateRequestProperty(reqProperties, propPath, null);
            prop.setValues(this.convertToRequestParameterArray(e.getValue()));
        }
        return reqProperties.values();
    }

    private RequestProperty getOrCreateRequestProperty(Map<String, RequestProperty> props, String paramPath, String suffix) {
        if (suffix != null && paramPath.endsWith(suffix)) {
            paramPath = paramPath.substring(0, paramPath.length() - suffix.length());
        }
        return props.computeIfAbsent(paramPath, RequestProperty::new);
    }

    protected void processDeletes(Authorizable authorizable, Collection<RequestProperty> reqProperties, List<Modification> changes) throws RepositoryException {
        for (RequestProperty property : reqProperties) {
            String relativePath;
            if (!property.isDelete() || !authorizable.hasProperty(relativePath = property.getPath().substring(1))) continue;
            authorizable.removeProperty(relativePath);
            changes.add(Modification.onDeleted((String)relativePath));
        }
    }

    protected void writeContent(Session session, Authorizable authorizable, Collection<RequestProperty> reqProperties, List<Modification> changes) throws RepositoryException {
        for (RequestProperty prop : reqProperties) {
            boolean isSpecialProp;
            if (!prop.hasValues()) continue;
            String relativePath = prop.getPath().substring(1);
            boolean bl = isSpecialProp = relativePath.equals("jcr:primaryType") || relativePath.equals("jcr:mixinTypes");
            if (authorizable.isGroup()) {
                if (relativePath.equals("groupId")) {
                    isSpecialProp = true;
                }
            } else if (relativePath.equals("userId") || relativePath.equals("pwd") || relativePath.equals("pwdConfirm")) {
                isSpecialProp = true;
            }
            if (isSpecialProp || prop.isFileUpload()) continue;
            this.setPropertyAsIs(session, authorizable, prop, changes);
        }
    }

    private void setPropertyAsIs(Session session, Authorizable parent, RequestProperty prop, List<Modification> changes) throws RepositoryException {
        String parentPath = parent.isGroup() ? this.systemUserManagerPaths.getGroupPrefix() + parent.getID() : this.systemUserManagerPaths.getUserPrefix() + parent.getID();
        int type = 0;
        if (prop.getTypeHint() != null) {
            try {
                type = PropertyType.valueFromName((String)prop.getTypeHint());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String relativePath = prop.getPath().substring(1);
        String[] values = prop.getStringValues();
        if (values == null) {
            boolean removedProp = this.removePropertyIfExists(parent, relativePath);
            if (removedProp) {
                changes.add(Modification.onDeleted((String)(parentPath + "/" + relativePath)));
            }
        } else if (values.length == 0) {
            if (parent.hasProperty(relativePath)) {
                Value val = session.getValueFactory().createValue("");
                parent.setProperty(relativePath, val);
                changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
            }
        } else if (values.length == 1) {
            if (values[0].length() == 0) {
                boolean removedProp = this.removePropertyIfExists(parent, relativePath);
                if (removedProp) {
                    changes.add(Modification.onDeleted((String)(parentPath + "/" + relativePath)));
                }
            } else {
                Value val;
                Calendar c;
                if (type == 5 && (c = this.dateParser.parse(values[0])) != null) {
                    if (prop.hasMultiValueTypeHint()) {
                        Value[] array = new Value[]{session.getValueFactory().createValue(c)};
                        parent.setProperty(relativePath, array);
                        changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
                    } else {
                        Value cVal = session.getValueFactory().createValue(c);
                        parent.setProperty(relativePath, cVal);
                        changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
                    }
                    return;
                }
                if (type == 0) {
                    val = session.getValueFactory().createValue(values[0], 1);
                    parent.setProperty(relativePath, val);
                } else if (prop.hasMultiValueTypeHint()) {
                    Value[] array = new Value[]{session.getValueFactory().createValue(values[0], type)};
                    parent.setProperty(relativePath, array);
                } else {
                    val = session.getValueFactory().createValue(values[0], type);
                    parent.setProperty(relativePath, val);
                }
                changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
            }
        } else {
            ValueFactory valFac;
            Value[] c;
            if (type == 5 && (c = this.dateParser.parse(values, valFac = session.getValueFactory())) != null) {
                parent.setProperty(relativePath, c);
                changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
                return;
            }
            Value[] vals = new Value[values.length];
            if (type == 0) {
                for (int i = 0; i < values.length; ++i) {
                    vals[i] = session.getValueFactory().createValue(values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    vals[i] = session.getValueFactory().createValue(values[i], type);
                }
            }
            parent.setProperty(relativePath, vals);
            changes.add(Modification.onModified((String)(parentPath + "/" + relativePath)));
        }
    }

    private boolean removePropertyIfExists(Authorizable authorizable, String path) throws RepositoryException {
        if (authorizable.getProperty(path) != null) {
            authorizable.removeProperty(path);
            return true;
        }
        return false;
    }

    protected boolean hasItemPathPrefix(String name) {
        return name.startsWith("/") || name.startsWith("./") || name.startsWith("../");
    }

    protected final boolean requireItemPathPrefix(Map<String, ?> properties) {
        boolean requirePrefix = false;
        Iterator<String> iterator = properties.keySet().iterator();
        while (iterator.hasNext() && !requirePrefix) {
            String name = iterator.next();
            requirePrefix = name.startsWith("./");
        }
        return requirePrefix;
    }

    protected String convertToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        if (obj instanceof RequestParameter) {
            ((RequestParameter)obj).getString();
        } else if (obj instanceof RequestParameter[]) {
            RequestParameter[] values = (RequestParameter[])obj;
            if (values.length > 0) {
                return values[0].getString();
            }
            return null;
        }
        return null;
    }

    @NotNull
    protected String[] convertToStringArray(Object obj) {
        String[] strArray = null;
        if (obj instanceof String) {
            strArray = new String[]{(String)obj};
        } else if (obj instanceof String[]) {
            strArray = (String[])obj;
        } else if (obj instanceof RequestParameter) {
            strArray = new String[]{((RequestParameter)obj).getString()};
        } else if (obj instanceof RequestParameter[]) {
            RequestParameter[] values = (RequestParameter[])obj;
            strArray = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strArray[i] = values[i].getString();
            }
        }
        return strArray == null ? new String[]{} : strArray;
    }

    @NotNull
    protected RequestParameter[] convertToRequestParameterArray(Object obj) {
        RequestParameter[] paramArray = null;
        if (obj instanceof String) {
            paramArray = new RequestParameter[]{new RequestParameterImpl((String)obj, null)};
        } else if (obj instanceof String[]) {
            String[] strValues = (String[])obj;
            paramArray = new RequestParameter[strValues.length];
            for (int i = 0; i < strValues.length; ++i) {
                paramArray[i] = new RequestParameterImpl(strValues[i], null);
            }
        } else if (obj instanceof RequestParameter) {
            paramArray = new RequestParameter[]{(RequestParameter)obj};
        } else if (obj instanceof RequestParameter[]) {
            paramArray = (RequestParameter[])obj;
        }
        return paramArray == null ? new RequestParameter[]{} : paramArray;
    }

    static class SlingUnsupportedEncodingException
    extends SlingIOException {
        private static final long serialVersionUID = -4482276105859280247L;

        SlingUnsupportedEncodingException(UnsupportedEncodingException uee) {
            super((IOException)uee);
        }
    }

    static class RequestParameterImpl
    implements RequestParameter {
        private String value;
        private String encoding;
        private byte[] content;

        RequestParameterImpl(String value, String encoding) {
            this.encoding = encoding;
            this.value = value;
            this.content = null;
        }

        String getEncoding() {
            return this.encoding;
        }

        void setEncoding(String encoding) {
            try {
                this.value = this.getString(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SlingUnsupportedEncodingException(uee);
            }
            this.encoding = encoding;
        }

        public byte[] get() {
            if (this.content == null) {
                try {
                    this.content = this.getString().getBytes(this.getEncoding());
                }
                catch (Exception e) {
                    this.content = this.getString().getBytes();
                }
            }
            return this.content;
        }

        public String getContentType() {
            return null;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.get());
        }

        public String getFileName() {
            return null;
        }

        public long getSize() {
            return this.get().length;
        }

        public String getString() {
            return this.value;
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.get(), encoding);
        }

        public boolean isFormField() {
            return true;
        }

        public String getName() {
            return null;
        }

        public String toString() {
            return this.getString();
        }
    }
}

