/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableValueMap
implements ValueMap {
    private static final String DECLARED_MEMBERS_KEY = "declaredMembers";
    private static final String MEMBERS_KEY = "members";
    private static final String DECLARED_MEMBER_OF_KEY = "declaredMemberOf";
    private static final String MEMBER_OF_KEY = "memberOf";
    private static final String PATH_KEY = "path";
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizableValueMap.class);
    private boolean fullyRead;
    private final Map<String, Object> cache;
    private Authorizable authorizable;
    private final SystemUserManagerPaths systemUserManagerPaths;

    public AuthorizableValueMap(Authorizable authorizable, SystemUserManagerPaths systemUserManagerPaths) {
        this.authorizable = authorizable;
        this.cache = new LinkedHashMap<String, Object>();
        this.fullyRead = false;
        this.systemUserManagerPaths = systemUserManagerPaths;
    }

    public <T> T get(String name, Class<T> type) {
        if (type == null) {
            return (T)this.get(name);
        }
        return this.convertToType(name, type);
    }

    public <T> T get(String name, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> type = this.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(name, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        this.readFully();
        return this.cache.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        return this.cache.entrySet();
    }

    public Object get(Object key) {
        Object value = this.cache.get(key);
        if (value == null) {
            value = this.read((String)key);
        }
        return value;
    }

    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    public int size() {
        this.readFully();
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Collection<Object> values() {
        this.readFully();
        return this.cache.values();
    }

    protected Object read(String key) {
        if (this.fullyRead) {
            return null;
        }
        try {
            if (key.equals(MEMBERS_KEY) && this.authorizable.isGroup()) {
                return this.getMembers((Group)this.authorizable, true);
            }
            if (key.equals(DECLARED_MEMBERS_KEY) && this.authorizable.isGroup()) {
                return this.getMembers((Group)this.authorizable, false);
            }
            if (key.equals(MEMBER_OF_KEY)) {
                return this.getMemberships(true);
            }
            if (key.equals(DECLARED_MEMBER_OF_KEY)) {
                return this.getMemberships(false);
            }
            if (key.equals(PATH_KEY)) {
                return this.getPath();
            }
            if (this.authorizable.hasProperty(key)) {
                Value[] property = this.authorizable.getProperty(key);
                Object value = this.valuesToJavaObject(property);
                this.cache.put(key, value);
                return value;
            }
        }
        catch (RepositoryException re) {
            LOG.error("Could not access authorizable property", (Throwable)re);
        }
        return null;
    }

    public static Object toJavaObject(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 12: {
                return value.getDecimal();
            }
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    protected Object valuesToJavaObject(Value[] values) throws RepositoryException {
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return AuthorizableValueMap.toJavaObject(values[0]);
        }
        Object[] valuesObjs = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesObjs[i] = AuthorizableValueMap.toJavaObject(values[i]);
        }
        return valuesObjs;
    }

    protected void readFully() {
        if (!this.fullyRead) {
            try {
                if (this.authorizable.isGroup()) {
                    this.cache.put(MEMBERS_KEY, this.getMembers((Group)this.authorizable, true));
                    this.cache.put(DECLARED_MEMBERS_KEY, this.getMembers((Group)this.authorizable, false));
                }
                this.cache.put(MEMBER_OF_KEY, this.getMemberships(true));
                this.cache.put(DECLARED_MEMBER_OF_KEY, this.getMemberships(false));
                String path = this.getPath();
                if (path != null) {
                    this.cache.put(PATH_KEY, path);
                }
                Iterator pi = this.authorizable.getPropertyNames();
                while (pi.hasNext()) {
                    String key = (String)pi.next();
                    if (this.cache.containsKey(key)) continue;
                    Value[] property = this.authorizable.getProperty(key);
                    Object value = this.valuesToJavaObject(property);
                    this.cache.put(key, value);
                }
                this.fullyRead = true;
            }
            catch (RepositoryException re) {
                LOG.error("Could not access certain properties of user {}", (Object)this.authorizable, (Object)re);
            }
        }
    }

    public String toString() {
        this.readFully();
        return this.cache.toString();
    }

    public Object remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends Object> arg0) {
        throw new UnsupportedOperationException();
    }

    private <T> T convertToType(String name, Class<T> type) {
        Object result = null;
        try {
            if (this.authorizable.hasProperty(name)) {
                Value[] values = this.authorizable.getProperty(name);
                if (values == null) {
                    return null;
                }
                boolean multiValue = values.length > 1;
                boolean array = type.isArray();
                if (multiValue) {
                    if (array) {
                        result = this.convertToArray(values, type.getComponentType());
                    } else if (values.length > 0) {
                        result = this.convertToType(-1, values[0], type);
                    }
                } else {
                    Value value = values[0];
                    result = array ? this.convertToArray(new Value[]{value}, type.getComponentType()) : this.convertToType(-1, value, type);
                }
            }
        }
        catch (ValueFormatException vfe) {
            LOG.info("converToType: Cannot convert value of " + name + " to " + type, (Throwable)vfe);
        }
        catch (RepositoryException re) {
            LOG.info("converToType: Cannot get value of " + name, (Throwable)re);
        }
        return (T)result;
    }

    private <T> T[] convertToArray(Value[] jcrValues, Class<T> type) throws ValueFormatException, RepositoryException {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < jcrValues.length; ++i) {
            T value = this.convertToType(i, jcrValues[i], type);
            if (value == null) continue;
            values.add(value);
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    private <T> T convertToType(int index, Value jcrValue, Class<T> type) throws ValueFormatException, RepositoryException {
        if (String.class == type) {
            return (T)jcrValue.getString();
        }
        if (Byte.class == type) {
            return (T)new Byte((byte)jcrValue.getLong());
        }
        if (Short.class == type) {
            return (T)new Short((short)jcrValue.getLong());
        }
        if (Integer.class == type) {
            return (T)new Integer((int)jcrValue.getLong());
        }
        if (Long.class == type) {
            return (T)new Long(jcrValue.getLong());
        }
        if (Float.class == type) {
            return (T)new Float(jcrValue.getDouble());
        }
        if (Double.class == type) {
            return (T)new Double(jcrValue.getDouble());
        }
        if (Boolean.class == type) {
            return (T)Boolean.valueOf(jcrValue.getBoolean());
        }
        if (Date.class == type) {
            return (T)jcrValue.getDate().getTime();
        }
        if (Calendar.class == type) {
            return (T)jcrValue.getDate();
        }
        if (Value.class == type) {
            return (T)jcrValue;
        }
        return null;
    }

    private Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (Property.class.isAssignableFrom(type)) {
            type = Property.class;
        }
        return type;
    }

    private String[] getMembers(Group group, boolean includeAll) throws RepositoryException {
        Iterator it;
        ArrayList<String> results = new ArrayList<String>();
        Iterator iterator = it = includeAll ? group.getMembers() : group.getDeclaredMembers();
        while (it.hasNext()) {
            Authorizable auth = (Authorizable)it.next();
            if (auth.isGroup()) {
                results.add(this.systemUserManagerPaths.getGroupPrefix() + auth.getID());
                continue;
            }
            results.add(this.systemUserManagerPaths.getUserPrefix() + auth.getID());
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] getMemberships(boolean includeAll) throws RepositoryException {
        Iterator it;
        ArrayList<String> results = new ArrayList<String>();
        Iterator iterator = it = includeAll ? this.authorizable.memberOf() : this.authorizable.declaredMemberOf();
        while (it.hasNext()) {
            Group group = (Group)it.next();
            results.add(this.systemUserManagerPaths.getGroupPrefix() + group.getID());
        }
        return results.toArray(new String[results.size()]);
    }

    private String getPath() throws RepositoryException {
        try {
            return this.authorizable.getPath();
        }
        catch (UnsupportedRepositoryOperationException e) {
            LOG.debug("Could not retrieve path of authorizable {}", (Object)this.authorizable, (Object)e);
            return null;
        }
    }

    public static class LazyInputStream
    extends InputStream {
        private final Value value;
        private InputStream delegatee;

        public LazyInputStream(Value value) {
            this.value = value;
        }

        @Override
        public void close() throws IOException {
            if (this.delegatee != null) {
                this.delegatee.close();
            }
        }

        @Override
        public int available() throws IOException {
            return this.getStream().available();
        }

        @Override
        public int read() throws IOException {
            return this.getStream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getStream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getStream().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getStream().skip(n);
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getStream().markSupported();
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.getStream().mark(readlimit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            this.getStream().reset();
        }

        private InputStream getStream() throws IOException {
            if (this.delegatee == null) {
                try {
                    this.delegatee = this.value.getBinary().getStream();
                }
                catch (RepositoryException re) {
                    throw (IOException)new IOException(re.getMessage()).initCause(re);
                }
            }
            return this.delegatee;
        }
    }
}

